/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.FieldType;
import com.flipkart.lyrics.model.MetaInfo;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class SetterHandler {
    private MetaInfo metaInfo;

    public SetterHandler(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public MethodSpec.Builder process(FieldSpec fieldSpec, FieldModel fieldModel) {
        String methodName = Helper.getGetterSetterName(fieldSpec.name, true, fieldModel.getFieldType() == FieldType.BOOLEAN, fieldModel.isPrimitive());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addStatement("this.$L = $L", new Object[]{fieldSpec.name, fieldSpec.name});
        ParameterSpec.Builder param = ParameterSpec.builder((TypeName)fieldSpec.type, (String)fieldSpec.name, (Modifier[])new Modifier[0]);
        if (fieldModel.isRequired()) {
            this.metaInfo.getValidationAnnotatorStyles().forEach(style -> style.processRequiredRuleForSetters(builder, fieldModel, param));
        } else {
            this.metaInfo.getValidationAnnotatorStyles().forEach(style -> style.processNotRequiredRuleForSetters(builder, fieldModel, param));
        }
        builder.addParameter(param.build());
        return builder;
    }
}

