/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.instances;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.FieldType;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class EnumValuesHandler
extends Handler {
    public EnumValuesHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        Map<String, Object[]> values = typeModel.getValues();
        List<Map.Entry<String, FieldModel>> orderedFields = this.orderFields(typeModel.getFields(), typeModel.getFieldOrder());
        String formattedParams = this.getFormattedParams(orderedFields);
        for (String key : values.keySet()) {
            if (formattedParams == null) {
                typeBuilder.addEnumConstant(key);
                continue;
            }
            typeBuilder.addEnumConstant(key, TypeSpec.anonymousClassBuilder((String)formattedParams, (Object[])values.get(key)).build());
        }
    }

    private List<Map.Entry<String, FieldModel>> orderFields(Map<String, FieldModel> fieldModels, List<String> fieldOrder) {
        Map.Entry[] orderedFields = new Map.Entry[fieldOrder.size()];
        for (Map.Entry<String, FieldModel> entry : fieldModels.entrySet()) {
            int index = fieldOrder.indexOf(entry.getKey());
            orderedFields[index] = entry;
        }
        return Arrays.asList(orderedFields);
    }

    private String getFormattedParams(List<Map.Entry<String, FieldModel>> orderedFields) {
        if (orderedFields.isEmpty()) {
            return null;
        }
        String formattedParams = "";
        for (Map.Entry<String, FieldModel> orderedField : orderedFields) {
            formattedParams = formattedParams + (orderedField.getValue().getFieldType().equals((Object)FieldType.STRING) ? "$S" : "$L") + ", ";
        }
        return formattedParams.substring(0, formattedParams.length() - 2);
    }
}

