/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.helper;

import com.flipkart.lyrics.annotators.AnnotationStyle;
import com.flipkart.lyrics.annotators.GsonStyle;
import com.flipkart.lyrics.annotators.JacksonStyle;
import com.flipkart.lyrics.annotators.validations.AndroidValidationStyle;
import com.flipkart.lyrics.annotators.validations.Jsr303Style;
import com.flipkart.lyrics.annotators.validations.Jsr305Style;
import com.flipkart.lyrics.annotators.validations.ValidationAnnotatorStyle;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.GenericVariableModel;
import com.flipkart.lyrics.model.VariableModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class Helper {
    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static TypeName getClassName(String name, Map<String, TypeVariableName> typeVariableNames) {
        int lastIndex = name.lastIndexOf(".");
        if (lastIndex < 0) {
            return (TypeName)typeVariableNames.get(name);
        }
        return ClassName.get((String)name.substring(0, lastIndex), (String)name.substring(lastIndex + 1), (String[])new String[0]);
    }

    public static ClassName getClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return ClassName.get((String)name.substring(0, lastIndex), (String)name.substring(lastIndex + 1), (String[])new String[0]);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getGetterSetterName(String name, boolean isSetter, boolean isBoolean, boolean isPrimitive) {
        String capitalizedName = Helper.capitalize(name);
        String prefix = "get";
        if (isBoolean) {
            if (capitalizedName.startsWith("Is")) {
                if (capitalizedName.length() > 2) {
                    capitalizedName = capitalizedName.substring(2);
                } else if (isPrimitive && !isSetter) {
                    capitalizedName = "";
                }
            }
            if (isPrimitive) {
                prefix = "is";
            }
        }
        if (isSetter) {
            prefix = "set";
        }
        return prefix + capitalizedName;
    }

    public static TypeName getResolvedTypeName(VariableModel variableModel, Map<String, TypeVariableName> typeVariableNames) {
        TypeName typeName;
        if (variableModel.getTypes().length > 0) {
            ClassName className = Helper.getClassName(variableModel.getType());
            TypeName[] typeNames = new TypeName[variableModel.getTypes().length];
            for (int i = 0; i < variableModel.getTypes().length; ++i) {
                typeNames[i] = Helper.getResolvedTypeName(variableModel.getTypes()[i], typeVariableNames);
            }
            typeName = ParameterizedTypeName.get((ClassName)className, (TypeName[])typeNames);
        } else {
            typeName = Helper.getClassName(variableModel.getType(), typeVariableNames);
        }
        return typeName;
    }

    public static Map<String, TypeVariableName> getTypeVariables(List<GenericVariableModel> genericVariables) {
        HashMap<String, TypeVariableName> typeVariableNames = new HashMap<String, TypeVariableName>();
        for (GenericVariableModel variable : genericVariables) {
            if (variable.getExtendsType() != null) {
                ClassName variableName = Helper.getClassName(variable.getExtendsType());
                typeVariableNames.put(variable.getName(), TypeVariableName.get((String)variable.getName(), (TypeName[])new TypeName[]{variableName}));
                continue;
            }
            typeVariableNames.put(variable.getName(), TypeVariableName.get((String)variable.getName()));
        }
        return typeVariableNames;
    }

    public static Modifier[] resolveModifiers(Tune tune, FieldModel fieldModel) {
        if (tune.getDefaultFieldModifier() == null) {
            return fieldModel.getModifiers();
        }
        if (tune.forceDefaultFieldModifiers() || fieldModel.getModifiers().length == 0 && !fieldModel.isPackageVisibility()) {
            return new Modifier[]{tune.getDefaultFieldModifier()};
        }
        return fieldModel.getModifiers();
    }

    public static List<AnnotationStyle> processAnnotationStyles(Tune tune) {
        ArrayList<AnnotationStyle> annotationStyles = new ArrayList<AnnotationStyle>();
        if (tune.areJacksonStyleAnnotationsNeeded()) {
            annotationStyles.add(new JacksonStyle());
        }
        if (tune.areGsonStyleAnnotationsNeeded()) {
            annotationStyles.add(new GsonStyle());
        }
        return annotationStyles;
    }

    public static List<ValidationAnnotatorStyle> processValidationAnnotationStyles(Tune tune) {
        ArrayList<ValidationAnnotatorStyle> validationAnnotatorStyles = new ArrayList<ValidationAnnotatorStyle>();
        if (tune.areJsr303AnnotationsNeeded()) {
            validationAnnotatorStyles.add(new Jsr303Style());
        }
        if (tune.areJsr305AnnotationsNeeded()) {
            validationAnnotatorStyles.add(new Jsr305Style());
        }
        if (tune.areAndroidValidationAnnotationsNeeded()) {
            validationAnnotatorStyles.add(new AndroidValidationStyle());
        }
        return validationAnnotatorStyles;
    }
}

