/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.rule;

import com.flipkart.masquerade.rule.CompositeRule;
import java.lang.annotation.Annotation;

public class Rule {
    private final String name;
    private final Class<? extends Annotation> annotationClass;
    private final Class<?> evaluatorClass;
    private final CompositeRule valueRule;

    public Rule(String name, Class<? extends Annotation> annotationClass, Class<?> evaluatorClass, CompositeRule valueRule) {
        if (name == null || annotationClass == null || evaluatorClass == null || valueRule == null) {
            throw new NullPointerException("Rule class does not accept any null parameters");
        }
        this.name = name;
        this.annotationClass = annotationClass;
        this.evaluatorClass = evaluatorClass;
        this.valueRule = valueRule;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public Class<?> getEvaluatorClass() {
        return this.evaluatorClass;
    }

    public CompositeRule getValueRule() {
        return this.valueRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.name.equals(rule.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

