/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.annotation.IgnoreCloak;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.BasicRule;
import com.flipkart.masquerade.rule.CompositeRule;
import com.flipkart.masquerade.rule.Conjunction;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.rule.ValueRule;
import com.flipkart.masquerade.util.FieldDescriptor;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class OverrideProcessor
extends BaseOverrideProcessor {
    public OverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public Optional<TypeSpec> createOverride(Rule rule, Class<?> clazz, CodeBlock.Builder initializer) {
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, clazz);
        for (Field field : Helper.getNonStaticFields(clazz)) {
            if (field.getType().isPrimitive() || field.isAnnotationPresent(IgnoreCloak.class)) continue;
            Class<? extends Annotation> annotationClass = rule.getAnnotationClass();
            Annotation[] annotations = field.getAnnotationsByType(annotationClass);
            if (annotations != null && annotations.length != 0) {
                for (Annotation annotation : annotations) {
                    this.constructOperation(rule, annotationClass, annotation, methodBuilder, field.getName(), clazz);
                }
            }
            this.addRecursiveStatement(clazz, field, methodBuilder);
        }
        MethodSpec methodSpec = methodBuilder.build();
        if (methodSpec.code.isEmpty()) {
            this.addNoOpInitializerCode(rule, clazz, initializer);
            return Optional.empty();
        }
        String implName = Helper.getImplementationName(rule, clazz);
        this.addInitializerCode(rule, clazz, initializer, implName);
        return Optional.ofNullable(this.generateImplementationType(rule, clazz, implName, methodSpec));
    }

    private void addRecursiveStatement(Class<?> clazz, Field field, MethodSpec.Builder methodBuilder) {
        if (!(field.getType().isPrimitive() || Helper.getWrapperTypes().contains(field.getType()) || String.class.isAssignableFrom(field.getType()) || field.getType().isEnum())) {
            String getter = Helper.getGetterName(field.getName());
            try {
                clazz.getMethod(getter, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("A cloak-able class should have a getter defined for all fields. Class: " + clazz.getName() + " Field: " + field.getName());
            }
            methodBuilder.addStatement("$L.$L($L.$L(), $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", Strings.OBJECT_PARAMETER, getter, "eval"});
        }
    }

    private void addNoOpInitializerCode(Rule rule, Class<?> clazz, CodeBlock.Builder initializer) {
        initializer.addStatement("$L.put($S, $L)", new Object[]{rule.getName(), clazz.getName(), Helper.getNoOpVariableName(rule)});
    }

    private void addInitializerCode(Rule rule, Class<?> clazz, CodeBlock.Builder initializer, String implName) {
        ClassName cloakName = ClassName.get((String)Helper.getImplementationPackage(this.configuration, clazz), (String)implName, (String[])new String[0]);
        initializer.addStatement("$L.put($S, new $T())", new Object[]{rule.getName(), clazz.getName(), cloakName});
    }

    private void constructOperation(Rule rule, Class<? extends Annotation> annotationClass, Annotation annotation, MethodSpec.Builder builder, String fieldName, Class<?> clazz) {
        ArrayList<Object> operands = new ArrayList<Object>();
        CompositeRule baseRule = rule.getValueRule();
        String operation = this.constructBasicOperation(baseRule, baseRule.getConjunction(), annotationClass, annotation, operands);
        String setter = Helper.getSetterName(fieldName);
        Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(setter)).findFirst().orElseThrow(() -> new UnsupportedOperationException("A cloak-able class should have a setter defined for all fields. Class: " + clazz.getName() + " Field: " + fieldName));
        builder.beginControlFlow("if (" + operation + ")", operands.toArray());
        builder.addStatement("$L.$L(null)", new Object[]{Strings.OBJECT_PARAMETER, setter});
        builder.endControlFlow();
    }

    private String constructBasicOperation(CompositeRule compositeRule, Conjunction conjunction, Class<? extends Annotation> annotationClass, Annotation annotation, List<Object> operands) {
        StringBuilder operation = new StringBuilder();
        for (ValueRule valueRule : compositeRule.getValueRules()) {
            Object defaultValue;
            Object value;
            if (valueRule instanceof CompositeRule) {
                CompositeRule innerRule = (CompositeRule)valueRule;
                String constructedCompositeOperation = this.constructBasicOperation(innerRule, innerRule.getConjunction(), annotationClass, annotation, operands);
                if (constructedCompositeOperation.length() == 0) continue;
                operation.append("(").append(constructedCompositeOperation).append(")").append(" ").append(conjunction.getSymbol()).append(" ");
                continue;
            }
            BasicRule basicRule = (BasicRule)valueRule;
            try {
                Method annotationValue = annotationClass.getDeclaredMethod(basicRule.getAnnotationMember(), new Class[0]);
                value = annotationValue.invoke((Object)annotation, new Object[0]);
                defaultValue = annotationValue.getDefaultValue();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Please provide a annotation member that exists");
            }
            if (basicRule.isDefaultIgnored() && value.equals(defaultValue)) continue;
            FieldDescriptor descriptor = this.generateDescriptor(value);
            basicRule.getOperator().getGenerateOperation().accept(operation, descriptor);
            operation.append(" ").append(conjunction.getSymbol()).append(" ");
            String evalFunc = Helper.getEvaluationFunction(basicRule);
            value = this.handleEnum(descriptor, value);
            operands.add(evalFunc);
            operands.add(value);
        }
        return operation.length() < 4 ? operation.toString() : operation.delete(operation.length() - 4, operation.length()).toString();
    }

    private FieldDescriptor generateDescriptor(Object value) {
        boolean isPrimitive = value.getClass().isPrimitive() || Helper.getWrapperTypes().contains(value.getClass());
        return new FieldDescriptor(isPrimitive, isPrimitive || value.getClass().isEnum(), isPrimitive || Comparable.class.isAssignableFrom(value.getClass()), value.getClass().isEnum());
    }

    private Object handleEnum(FieldDescriptor descriptor, Object value) {
        if (!descriptor.isEnumeration()) {
            return value;
        }
        ClassName enumName = ClassName.get((String)value.getClass().getPackage().getName(), (String)value.getClass().getSimpleName(), (String[])new String[0]);
        return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{enumName, value});
    }
}

