/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class RuleObjectProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;

    public RuleObjectProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
    }

    public void addEntry(Rule rule) {
        MethodSpec.Builder objectMaskBuilder = MethodSpec.methodBuilder((String)"hide");
        objectMaskBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        objectMaskBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
        objectMaskBuilder.addParameter(Object.class, Strings.OBJECT_PARAMETER, new Modifier[0]);
        objectMaskBuilder.addParameter(rule.getEvaluatorClass(), "eval", new Modifier[0]);
        objectMaskBuilder.beginControlFlow("if ($L == null)", new Object[]{Strings.OBJECT_PARAMETER});
        objectMaskBuilder.addStatement("return", new Object[0]);
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.addStatement("$T $L = this.$L.get($L.getClass().getName())", new Object[]{Helper.getRuleInterface(this.configuration, rule), "masker", rule.getName(), Strings.OBJECT_PARAMETER});
        objectMaskBuilder.beginControlFlow("if ($L != null)", new Object[]{"masker"});
        objectMaskBuilder.addStatement("$L.$L($L, $L, this)", new Object[]{"masker", Strings.INTERFACE_METHOD, Strings.OBJECT_PARAMETER, "eval"});
        objectMaskBuilder.nextControlFlow("else", new Object[0]);
        objectMaskBuilder.beginControlFlow("if ($L instanceof $T)", new Object[]{Strings.OBJECT_PARAMETER, Map.class});
        objectMaskBuilder.addStatement("this.$L(((Map) $L).values(), $L)", new Object[]{"hide", Strings.OBJECT_PARAMETER, "eval"});
        objectMaskBuilder.nextControlFlow("else if ($L instanceof $T)", new Object[]{Strings.OBJECT_PARAMETER, Collection.class});
        objectMaskBuilder.beginControlFlow("for (Object o : ((Collection) $L))", new Object[]{Strings.OBJECT_PARAMETER});
        objectMaskBuilder.addStatement("this.$L(o, $L)", new Object[]{"hide", "eval"});
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.nextControlFlow("else if ($L instanceof Object[])", new Object[]{Strings.OBJECT_PARAMETER});
        objectMaskBuilder.beginControlFlow("for (Object o : ((Object[]) $L))", new Object[]{Strings.OBJECT_PARAMETER});
        objectMaskBuilder.addStatement("this.$L(o, $L)", new Object[]{"hide", "eval"});
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.endControlFlow();
        this.cloakBuilder.addMethod(objectMaskBuilder.build());
    }
}

