/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.util;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.rule.BasicRule;
import com.flipkart.masquerade.rule.Rule;
import com.google.common.reflect.ClassPath;
import com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Helper {
    public static String getSetterName(String name) {
        String capitalizedName = Helper.capitalize(name);
        String prefix = "set";
        return prefix + capitalizedName;
    }

    public static String getGetterName(String name) {
        String capitalizedName = Helper.capitalize(name);
        String prefix = "get";
        return prefix + capitalizedName;
    }

    public static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        return ret;
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static ClassName getRuleInterface(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)(rule.getName() + "Mask"), (String[])new String[0]);
    }

    public static String getInterfaceName(Rule rule) {
        return rule.getName() + "Mask";
    }

    public static String getImplementationName(Rule rule, Class<?> clazz) {
        return Helper.generateImplementationName(rule, clazz.getSimpleName());
    }

    public static String getNoOpImplementationName(Rule rule) {
        return Helper.generateImplementationName(rule, "NoOp");
    }

    public static ClassName getNoOpImplementationClass(Configuration configuration, Rule rule) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)Helper.getNoOpImplementationName(rule), (String[])new String[0]);
    }

    private static String generateImplementationName(Rule rule, String prefix) {
        return prefix + rule.getName() + "Mask";
    }

    public static String getImplementationPackage(Configuration configuration, Class<?> clazz) {
        return configuration.getCloakPackage() + "." + clazz.getPackage().getName();
    }

    public static ClassName getEntryClass(Configuration configuration) {
        return ClassName.get((String)configuration.getCloakPackage(), (String)"Cloak", (String[])new String[0]);
    }

    public static String getNoOpVariableName(Rule rule) {
        return "noOp" + rule.getName();
    }

    public static Set<ClassPath.ClassInfo> getPackageClasses(ClassLoader classLoader, List<String> packagesToScan) throws IOException {
        ClassPath classpath = ClassPath.from((ClassLoader)classLoader);
        HashSet<ClassPath.ClassInfo> classDescriptions = new HashSet<ClassPath.ClassInfo>();
        for (String basePackage : packagesToScan) {
            classDescriptions.addAll((Collection<ClassPath.ClassInfo>)classpath.getTopLevelClassesRecursive(basePackage));
        }
        return classDescriptions;
    }

    public static List<Field> getNonStaticFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList()));
        }
        return fields;
    }

    public static String getEvaluationFunction(BasicRule basicRule) {
        return "eval." + basicRule.getEvaluatorFunction();
    }

    public static boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isPublic(Class clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }
}

