/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.DebugProcessor;
import com.flipkart.masquerade.processor.NoOpInitializationProcessor;
import com.flipkart.masquerade.processor.OverrideProcessor;
import com.flipkart.masquerade.processor.RuleProcessor;
import com.flipkart.masquerade.processor.ToStringInitializationProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.TypeSpecContainer;
import com.google.common.reflect.ClassPath;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;

public class Masquerade {
    private static final List<TypeSpecContainer> specs = new ArrayList<TypeSpecContainer>();

    public static void initialize(Configuration configuration, File destination) throws IOException, ClassNotFoundException {
        Masquerade.initialize(configuration, ClassLoader.getSystemClassLoader(), destination);
    }

    public static void initialize(Configuration configuration, ClassLoader classLoader, File destination) throws IOException, ClassNotFoundException {
        if (configuration == null || classLoader == null || destination == null) {
            throw new NullPointerException("Masquerade does not accept any null parameters");
        }
        if (configuration.getRules() == null || configuration.getCloakPackage() == null || configuration.getPackagesToScan() == null) {
            throw new NullPointerException("Configuration cannot return any null objects");
        }
        Set<ClassPath.ClassInfo> scannedClasses = Helper.getPackageClasses(classLoader, configuration.getPackagesToScan());
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Cloak");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder staticCode = CodeBlock.builder();
        RuleProcessor ruleProcessor = new RuleProcessor(configuration, builder);
        OverrideProcessor overrideProcessor = new OverrideProcessor(configuration, builder);
        NoOpInitializationProcessor noOpInitializationProcessor = new NoOpInitializationProcessor(configuration, builder);
        ToStringInitializationProcessor toStringInitializationProcessor = new ToStringInitializationProcessor(configuration, builder);
        DebugProcessor debugProcessor = new DebugProcessor(configuration, builder);
        debugProcessor.addConstructor();
        configuration.getRules().forEach(rule -> noOpInitializationProcessor.generateNoOpEntries((Rule)rule, staticCode));
        configuration.getRules().forEach(rule -> toStringInitializationProcessor.generateToStringEntries((Rule)rule, staticCode));
        specs.addAll(ruleProcessor.generateRuleTypeSpecs());
        for (ClassPath.ClassInfo info : scannedClasses) {
            Class<?> clazz = Class.forName(info.getName(), true, classLoader);
            if (clazz.isEnum() || clazz.isInterface() || Helper.isAbstract(clazz) || !Helper.isPublic(clazz)) continue;
            for (Rule rule2 : configuration.getRules()) {
                overrideProcessor.createOverride(rule2, clazz, staticCode).ifPresent(typeSpec -> specs.add(new TypeSpecContainer(Helper.getImplementationPackage(configuration, clazz), (TypeSpec)typeSpec)));
            }
        }
        builder.addInitializerBlock(staticCode.build());
        specs.add(new TypeSpecContainer(configuration.getCloakPackage(), builder.build()));
        for (TypeSpecContainer container : specs) {
            TypeSpec.Builder typeBuilder = container.getSpec().toBuilder().addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"com.flipkart.masquerade.Masquerade"}).build());
            JavaFile javaFile = JavaFile.builder((String)container.getPackagePath(), (TypeSpec)typeBuilder.build()).indent("    ").skipJavaLangImports(true).build();
            javaFile.writeTo(destination);
        }
    }
}

