/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.EnumOverrideProcessor;
import com.flipkart.masquerade.processor.InterfaceProcessor;
import com.flipkart.masquerade.processor.NoOpOverrideProcessor;
import com.flipkart.masquerade.processor.ReferenceMapProcessor;
import com.flipkart.masquerade.processor.RuleObjectProcessor;
import com.flipkart.masquerade.processor.ToStringProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.TypeSpecContainer;
import com.flipkart.masquerade.util.Verifier;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public class RuleProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;
    private final List<TypeSpecContainer> specs = new ArrayList<TypeSpecContainer>();

    public RuleProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
    }

    public List<TypeSpecContainer> generateRuleTypeSpecs() {
        ReferenceMapProcessor mapProcessor = new ReferenceMapProcessor(this.configuration, this.cloakBuilder);
        InterfaceProcessor interfaceProcessor = new InterfaceProcessor(this.configuration, this.cloakBuilder);
        RuleObjectProcessor ruleObjectProcessor = new RuleObjectProcessor(this.configuration, this.cloakBuilder);
        NoOpOverrideProcessor noOpOverrideProcessor = new NoOpOverrideProcessor(this.configuration, this.cloakBuilder);
        EnumOverrideProcessor enumOverrideProcessor = new EnumOverrideProcessor(this.configuration, this.cloakBuilder);
        ToStringProcessor toStringProcessor = new ToStringProcessor(this.configuration, this.cloakBuilder);
        for (Rule rule : this.configuration.getRules()) {
            Verifier.verifyEvaluationObject(rule);
            Verifier.verifyAnnotation(rule);
            Verifier.verifyTypes(rule);
            mapProcessor.addMap(rule);
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), interfaceProcessor.generateInterface(rule)));
            ruleObjectProcessor.addEntry(rule);
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), noOpOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), enumOverrideProcessor.createOverride(rule)));
            this.specs.add(new TypeSpecContainer(this.configuration.getCloakPackage(), toStringProcessor.createOverride(rule)));
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)Helper.getRuleInterface(this.configuration, rule), (String)Helper.getNoOpVariableName(rule), (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{Helper.getNoOpImplementationClass(this.configuration, rule)}).build();
            this.cloakBuilder.addField(fieldSpec);
            FieldSpec enumFieldSpec = FieldSpec.builder((TypeName)Helper.getRuleInterface(this.configuration, rule), (String)Helper.getEnumVariableName(rule), (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{Helper.getEnumImplementationClass(this.configuration, rule)}).build();
            this.cloakBuilder.addField(enumFieldSpec);
            FieldSpec toStringFieldSpec = FieldSpec.builder((TypeName)Helper.getRuleInterface(this.configuration, rule), (String)Helper.getToStringVariableName(rule), (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{Helper.getToStringImplementationClass(this.configuration, rule)}).build();
            this.cloakBuilder.addField(toStringFieldSpec);
        }
        return this.specs;
    }
}

