/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.util;

import com.flipkart.masquerade.util.FieldDescriptor;

public class OperationGenerator {
    public static void processEquals(StringBuilder operation, FieldDescriptor descriptor) {
        if (descriptor.isEquatable()) {
            operation.append("($L == $L)");
        } else {
            operation.append("($L.equals($S))");
        }
    }

    public static void processNotEquals(StringBuilder operation, FieldDescriptor descriptor) {
        if (descriptor.isEquatable()) {
            operation.append("($L != $L)");
        } else {
            operation.append("(!$L.equals($S))");
        }
    }

    public static void processGreaterThan(StringBuilder operation, FieldDescriptor descriptor) {
        if (descriptor.isPrimitive()) {
            operation.append("($L > $L)");
        } else if (descriptor.isComparable()) {
            String placeholder = descriptor.isEnumeration() ? "$L" : "$S";
            operation.append("($L.compareTo(" + placeholder + ") > 0)");
        } else {
            throw new UnsupportedOperationException("Cannot compare non-comparable types");
        }
    }

    public static void processGreaterThanEquals(StringBuilder operation, FieldDescriptor descriptor) {
        if (descriptor.isPrimitive()) {
            operation.append("($L >= $L)");
        } else if (descriptor.isComparable()) {
            String placeholder = descriptor.isEnumeration() ? "$L" : "$S";
            operation.append("($L.compareTo(" + placeholder + ") >= 0)");
        } else {
            throw new UnsupportedOperationException("Cannot compare non-comparable types");
        }
    }

    public static void processLesserThan(StringBuilder operation, FieldDescriptor descriptor) {
        if (descriptor.isPrimitive()) {
            operation.append("($L < $L)");
        } else if (descriptor.isComparable()) {
            String placeholder = descriptor.isEnumeration() ? "$L" : "$S";
            operation.append("($L.compareTo(" + placeholder + ") < 0)");
        } else {
            throw new UnsupportedOperationException("Cannot compare non-comparable types");
        }
    }

    public static void processLesserThanEquals(StringBuilder operation, FieldDescriptor descriptor) {
        if (descriptor.isPrimitive()) {
            operation.append("($L <= $L)");
        } else if (descriptor.isComparable()) {
            String placeholder = descriptor.isEnumeration() ? "$L" : "$S";
            operation.append("($L.compareTo(" + placeholder + ") <= 0)");
        } else {
            throw new UnsupportedOperationException("Cannot compare non-comparable types");
        }
    }
}

