/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.masquerade.util.Helper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;

public class FieldMeta {
    private final String name;
    private final Class<?> type;
    private final String serializableName;
    private final Field field;
    private final boolean synthetic;
    private final String syntheticValue;
    private JsonInclude.Include inclusionLevel;
    private boolean maskable = true;
    private final Function<JsonProperty, String> valueFunc = p -> {
        if (p.value().trim().isEmpty()) {
            return null;
        }
        return p.value();
    };

    public FieldMeta(Field field, Class<?> clazz) {
        this.name = field.getName();
        this.type = field.getType();
        this.serializableName = this.getSerializableName(field, clazz);
        this.field = field;
        this.synthetic = false;
        this.syntheticValue = null;
    }

    public FieldMeta(String name, Class<?> type, String syntheticValue) {
        this.name = name;
        this.serializableName = name;
        this.type = type;
        this.field = null;
        this.synthetic = true;
        this.syntheticValue = syntheticValue;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getSerializableName() {
        return this.serializableName;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public String getSyntheticValue() {
        return this.syntheticValue;
    }

    private String getSerializableName(Field field, Class<?> clazz) {
        Method getterMethod;
        String getter = Helper.getGetterName(field.getName(), Helper.isBoolean(field.getType()), field.getType().isPrimitive());
        String setter = Helper.getSetterName(field.getName(), Helper.isBoolean(field.getType()));
        Method setterMethod = null;
        try {
            getterMethod = clazz.getMethod(getter, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("A cloak-able class should have a getter defined for all fields. Class: " + clazz.getName() + " Field: " + field.getName());
        }
        try {
            setterMethod = clazz.getMethod(setter, field.getType());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        JsonProperty getterJsonProperty = getterMethod.getAnnotation(JsonProperty.class);
        JsonProperty setterJsonProperty = Optional.ofNullable(setterMethod).map(m -> m.getAnnotation(JsonProperty.class)).orElse(null);
        JsonProperty fieldJsonProperty = field.getAnnotation(JsonProperty.class);
        return Optional.ofNullable(fieldJsonProperty).map(this.valueFunc).orElse(Optional.ofNullable(getterJsonProperty).map(this.valueFunc).orElse(Optional.ofNullable(setterJsonProperty).map(this.valueFunc).orElse(this.handleBooleans(field))));
    }

    public Field getField() {
        return this.field;
    }

    private String handleBooleans(Field field) {
        if (!Helper.isBoolean(field.getType())) {
            return field.getName();
        }
        return Helper.deCapitalize(Helper.handleIsPrefix(field.getName()));
    }

    public JsonInclude.Include getInclusionLevel() {
        return this.inclusionLevel;
    }

    public void setInclusionLevel(JsonInclude.Include inclusionLevel) {
        this.inclusionLevel = inclusionLevel;
    }

    public boolean isMaskable() {
        return this.maskable;
    }

    public void setMaskable(boolean maskable) {
        this.maskable = maskable;
    }
}

