/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor.type;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;

public class MapOverrideProcessor
extends BaseOverrideProcessor {
    public MapOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public TypeSpec createOverride(Rule rule) {
        String implName = Helper.getMapImplementationName(rule);
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, Map.class);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.addStatement("$T $L = new $T($S)", new Object[]{StringBuilder.class, "serialized", StringBuilder.class, "{"});
            methodBuilder.addStatement("$L.forEach((k, v) -> $L.append($S).append(k).append($S).append($S).append($L.$L(v, $L)).append($S))", new Object[]{Strings.OBJECT_PARAMETER, "serialized", "\"", "\"", ":", Strings.CLOAK_PARAMETER, "hide", "eval", ","});
            methodBuilder.beginControlFlow("if ($L.length() > 1)", new Object[]{"serialized"});
            methodBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "}"});
            methodBuilder.addStatement("return $L.toString()", new Object[]{"serialized"});
        } else {
            methodBuilder.addStatement("$L.$L($L.values(), $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", Strings.OBJECT_PARAMETER, "eval"});
        }
        return this.generateImplementationType(rule, Map.class, implName, methodBuilder.build());
    }
}

