/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor.type;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;

public class CollectionOverrideProcessor
extends BaseOverrideProcessor {
    public CollectionOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public TypeSpec createOverride(Rule rule) {
        String implName = Helper.getCollectionImplementationName(rule);
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, Collection.class);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "["});
            methodBuilder.beginControlFlow("for (Object o : $L)", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("$L.$L(o, $L, $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", "eval", "serialized"});
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
            methodBuilder.endControlFlow();
            methodBuilder.beginControlFlow("if ($L.charAt($L.length() - 1) == ',')", new Object[]{"serialized", "serialized"});
            methodBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "]"});
        } else {
            methodBuilder.beginControlFlow("for (Object o : $L)", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("$L.$L(o, $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", "eval"});
            methodBuilder.endControlFlow();
        }
        return this.generateImplementationType(rule, Collection.class, implName, methodBuilder.build());
    }
}

