/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor.type;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;

public class PrimitiveOverrideProcessor
extends BaseOverrideProcessor {
    public PrimitiveOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public List<TypeSpec> createOverrides(Rule rule) {
        ArrayList<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        for (Class<?> primitiveType : Helper.getWrapperTypes()) {
            String implName = Helper.getPrimitiveImplementationName(rule, primitiveType);
            MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, primitiveType);
            if (this.configuration.isNativeSerializationEnabled()) {
                if (primitiveType.equals(Character.class)) {
                    methodBuilder.beginControlFlow("if ($L == Character.valueOf('\\u0000'))", new Object[]{Strings.OBJECT_PARAMETER});
                    methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\"\\u0000\""});
                    methodBuilder.addStatement("return", new Object[0]);
                    methodBuilder.endControlFlow();
                    methodBuilder.addStatement("$L.append($S + String.valueOf((char) $L) + $S)", new Object[]{"serialized", "\"", Strings.OBJECT_PARAMETER, "\""});
                } else {
                    methodBuilder.addStatement("$L.append(String.valueOf($L))", new Object[]{"serialized", Strings.OBJECT_PARAMETER});
                }
            }
            typeSpecs.add(this.generateImplementationType(rule, primitiveType, implName, methodBuilder.build()));
        }
        return typeSpecs;
    }
}

