/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.ReferenceMapProcessor;
import com.flipkart.masquerade.processor.type.ToStringInitializationProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.EntryType;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.RepositoryEntry;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;

public class RepositoryProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;
    private final ToStringInitializationProcessor toStringInitializationProcessor;
    private final ReferenceMapProcessor mapProcessor;

    public RepositoryProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
        this.toStringInitializationProcessor = new ToStringInitializationProcessor(configuration, cloakBuilder);
        this.mapProcessor = new ReferenceMapProcessor(configuration, cloakBuilder);
    }

    public void createReference() {
        ClassName className = Helper.getRepositoryClass(this.configuration);
        this.cloakBuilder.addField(FieldSpec.builder((TypeName)className, (String)Strings.SET_PARAMETER, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{className}).build());
        this.cloakBuilder.addMethod(MethodSpec.methodBuilder((String)Helper.getRepositoryGetter()).returns((TypeName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $L", new Object[]{Strings.SET_PARAMETER}).build());
    }

    public TypeSpec createRepository(List<RepositoryEntry> repositoryEntries) {
        TypeSpec.Builder repositoryBuilder = TypeSpec.classBuilder((String)"Trunk");
        repositoryBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder initializer = CodeBlock.builder();
        for (Rule rule : this.configuration.getRules()) {
            this.mapProcessor.addMap(rule, repositoryBuilder);
            this.handleEnumEntry(repositoryBuilder, rule, initializer);
            this.handlePrimitiveEntries(repositoryBuilder, rule, initializer);
            this.handleStringEntry(repositoryBuilder, rule, initializer);
            this.handleToStringEntries(repositoryBuilder, rule, initializer);
            this.handleProcessedEntries(repositoryBuilder, initializer, repositoryEntries);
            this.handleMapEntry(repositoryBuilder, rule, initializer);
            this.handleCollectionEntry(repositoryBuilder, rule, initializer);
            this.handleObjectArrayEntry(repositoryBuilder, rule, initializer);
            if (this.configuration.isNativeSerializationEnabled()) {
                this.handlePrimitiveArrayEntries(repositoryBuilder, rule, initializer);
                this.handleCharacterPrimitiveArrayEntries(repositoryBuilder, rule, initializer);
                continue;
            }
            this.handleNoOpEntry(repositoryBuilder, rule, initializer);
        }
        repositoryBuilder.addInitializerBlock(initializer.build());
        return repositoryBuilder.build();
    }

    private void handleEnumEntry(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getEnumImplementationClass(this.configuration, rule), Helper.getEnumVariableName(rule));
    }

    private void handleNoOpEntry(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getNoOpImplementationClass(this.configuration, rule), Helper.getNoOpVariableName(rule));
    }

    private void handleToStringEntries(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getToStringImplementationClass(this.configuration, rule), Helper.getToStringVariableName(rule));
        this.toStringInitializationProcessor.generateToStringEntries(rule).forEach(re -> initializer.addStatement("$L.put($S, $L)", new Object[]{rule.getName(), re.getClazz().getName(), Helper.getToStringVariableName(rule)}));
    }

    private void handlePrimitiveEntries(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        for (Class<?> wrapperType : Helper.getWrapperTypes()) {
            this.handleEntry(repositoryBuilder, initializer, Helper.getPrimitiveImplementationClass(this.configuration, rule, wrapperType), Helper.getPrimitiveVariableName(rule, wrapperType));
            initializer.addStatement("$L.put($S, $L)", new Object[]{rule.getName(), wrapperType.getName(), Helper.getPrimitiveVariableName(rule, wrapperType)});
        }
    }

    private void handleStringEntry(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getStringImplementationClass(this.configuration, rule), Helper.getStringVariableName(rule));
        initializer.addStatement("$L.put($S, $L)", new Object[]{rule.getName(), String.class.getName(), Helper.getStringVariableName(rule)});
    }

    private void handleMapEntry(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getMapImplementationClass(this.configuration, rule), Helper.getMapVariableName(rule));
    }

    private void handleCollectionEntry(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getCollectionImplementationClass(this.configuration, rule), Helper.getCollectionVariableName(rule));
    }

    private void handleObjectArrayEntry(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getObjectArrayImplementationClass(this.configuration, rule), Helper.getObjectArrayVariableName(rule));
    }

    private void handlePrimitiveArrayEntries(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        for (Class<?> primitiveType : Helper.getPrimitivesTypes()) {
            this.handleEntry(repositoryBuilder, initializer, Helper.getPrimitiveArrayImplementationClass(this.configuration, rule, primitiveType), Helper.getPrimitiveArrayVariableName(rule, primitiveType));
        }
    }

    private void handleCharacterPrimitiveArrayEntries(TypeSpec.Builder repositoryBuilder, Rule rule, CodeBlock.Builder initializer) {
        this.handleEntry(repositoryBuilder, initializer, Helper.getPrimitiveArrayImplementationClass(this.configuration, rule, Character.TYPE), Helper.getPrimitiveArrayVariableName(rule, Character.TYPE));
    }

    private void handleProcessedEntries(TypeSpec.Builder repositoryBuilder, CodeBlock.Builder initializer, List<RepositoryEntry> repositoryEntries) {
        for (RepositoryEntry entry : repositoryEntries) {
            if (entry.getEntryType() == EntryType.NEW) {
                String implName = Helper.getImplementationName(entry.getRule(), entry.getClazz());
                ClassName cloakName = ClassName.get((String)Helper.getImplementationPackage(this.configuration, entry.getClazz()), (String)implName, (String[])new String[0]);
                String variableName = Helper.getVariableName(cloakName);
                initializer.addStatement("$L.put($S, $L)", new Object[]{entry.getRule().getName(), entry.getClazz().getName(), variableName});
                this.handleEntry(repositoryBuilder, initializer, cloakName, variableName);
                continue;
            }
            if (entry.getEntryType() == EntryType.ENUM) {
                initializer.addStatement("$L.put($S, $L)", new Object[]{entry.getRule().getName(), entry.getClazz().getName(), Helper.getEnumVariableName(entry.getRule())});
                continue;
            }
            if (entry.getEntryType() != EntryType.NoOP) continue;
            initializer.addStatement("$L.put($S, $L)", new Object[]{entry.getRule().getName(), entry.getClazz().getName(), Helper.getNoOpVariableName(entry.getRule())});
        }
    }

    private void handleEntry(TypeSpec.Builder repositoryBuilder, CodeBlock.Builder initializer, ClassName className, String variableName) {
        FieldSpec fieldSpec = FieldSpec.builder((TypeName)className, (String)variableName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T()", new Object[]{className}).build();
        repositoryBuilder.addField(fieldSpec);
        repositoryBuilder.addMethod(MethodSpec.methodBuilder((String)variableName).returns((TypeName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $L", new Object[]{variableName}).build());
    }
}

