/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.RuleObjectProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SerializationRuleObjectProcessor
extends RuleObjectProcessor {
    public SerializationRuleObjectProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    @Override
    protected void handleReturnsForNullObjects(MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("$L.append($L)", new Object[]{"serialized", "_null"});
        objectMaskBuilder.addStatement("return", new Object[0]);
    }

    @Override
    protected void handleRegisteredClasses(MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.addStatement("$L.$L($L, $L, this, $L, $L)", new Object[]{"masker", Strings.INTERFACE_METHOD, Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER, "serialized"});
    }

    @Override
    protected void handleMaps(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        this.addMethodCall(objectMaskBuilder, Helper.getMapVariableName(rule), Map.class);
    }

    @Override
    protected void handleCollections(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        this.addMethodCall(objectMaskBuilder, Helper.getCollectionVariableName(rule), Collection.class);
    }

    @Override
    protected void handleObjectArrays(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        this.addMethodCall(objectMaskBuilder, Helper.getObjectArrayVariableName(rule), ArrayTypeName.of(Object.class));
    }

    private void addMethodCall(MethodSpec.Builder objectMaskBuilder, String methodName, Object clazz) {
        objectMaskBuilder.addStatement("$L.$L().$L(($T) $L, $L, this, $L, $L)", new Object[]{Strings.SET_PARAMETER, methodName, Strings.INTERFACE_METHOD, clazz, Strings.OBJECT_PARAMETER, "eval", Strings.SET_PARAMETER, "serialized"});
    }

    @Override
    protected void handlePrimitiveArrays(Rule rule, MethodSpec.Builder objectMaskBuilder) {
        objectMaskBuilder.nextControlFlow("else if ($L.getClass().isArray())", new Object[]{Strings.OBJECT_PARAMETER});
        objectMaskBuilder.beginControlFlow("if ($L instanceof $T[])", new Object[]{Strings.OBJECT_PARAMETER, Character.TYPE});
        this.addMethodCall(objectMaskBuilder, Helper.getPrimitiveArrayVariableName(rule, Character.TYPE), ArrayTypeName.of(Character.TYPE));
        ArrayList primitiveTypes = new ArrayList(Helper.getPrimitivesTypes());
        for (int i = 0; i < primitiveTypes.size(); ++i) {
            Class primitiveType = (Class)primitiveTypes.get(i);
            objectMaskBuilder.nextControlFlow("else if ($L instanceof $T[])", new Object[]{Strings.OBJECT_PARAMETER, primitiveType});
            this.addMethodCall(objectMaskBuilder, Helper.getPrimitiveArrayVariableName(rule, primitiveType), ArrayTypeName.of((Type)primitiveType));
        }
        objectMaskBuilder.endControlFlow();
    }

    @Override
    protected void handleReturns(MethodSpec.Builder objectMaskBuilder) {
    }
}

