/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;

public class InterfaceProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;

    public InterfaceProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
    }

    public TypeSpec generateInterface(Rule rule) {
        TypeSpec.Builder ruleInterface = TypeSpec.interfaceBuilder((String)Helper.getInterfaceName(rule));
        ruleInterface.addModifiers(new Modifier[]{Modifier.PUBLIC});
        ruleInterface.addTypeVariable(TypeVariableName.get((String)"T"));
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)Strings.INTERFACE_METHOD);
        methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
        methodBuilder.addParameter((TypeName)TypeVariableName.get((String)"T"), Strings.OBJECT_PARAMETER, new Modifier[0]);
        methodBuilder.addParameter(rule.getEvaluatorClass(), "eval", new Modifier[0]);
        methodBuilder.addParameter((TypeName)Helper.getEntryClass(this.configuration), Strings.CLOAK_PARAMETER, new Modifier[0]);
        methodBuilder.addParameter((TypeName)Helper.getRepositoryClass(this.configuration), Strings.SET_PARAMETER, new Modifier[0]);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.addParameter(StringBuilder.class, "serialized", new Modifier[0]);
        }
        ruleInterface.addMethod(methodBuilder.build());
        return ruleInterface.build();
    }
}

