/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.OverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.serialization.FieldMeta;
import com.flipkart.masquerade.serialization.SerializationProperty;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.google.common.base.Defaults;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SerializationOverrideProcessor
extends OverrideProcessor {
    public SerializationOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    @Override
    protected void declareInitializeVariables(MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "{"});
    }

    @Override
    protected List<FieldMeta> enrichFieldMetas(List<FieldMeta> fieldMetas, Class<?> clazz) {
        boolean sortedAlphabetically;
        ArrayList<FieldMeta> sortedFields = new ArrayList<FieldMeta>();
        JsonPropertyOrder propertyOrder = Helper.getAnnotation(clazz, JsonPropertyOrder.class);
        if (propertyOrder != null && propertyOrder.value().length > 0) {
            for (String name : propertyOrder.value()) {
                int index = this.findField(name, fieldMetas);
                if (index < 0) continue;
                sortedFields.add(fieldMetas.remove(index));
            }
        }
        if (!(sortedAlphabetically = this.configuration.serializationProperties().contains((Object)SerializationProperty.SORT_PROPERTIES_ALPHABETICALLY))) {
            sortedFields.addAll(fieldMetas);
            return sortedFields;
        }
        fieldMetas.sort(Comparator.comparing(FieldMeta::getSerializableName));
        sortedFields.addAll(fieldMetas);
        return sortedFields;
    }

    @Override
    protected void addSyntheticFields(Class<?> clazz, List<FieldMeta> fields) {
        JsonTypeInfo jsonTypeInfo = Helper.getAnnotation(clazz, JsonTypeInfo.class);
        JsonSubTypes jsonSubTypes = Helper.getAnnotation(clazz, JsonSubTypes.class);
        if (jsonTypeInfo == null || jsonSubTypes == null) {
            return;
        }
        if (!jsonTypeInfo.include().equals((Object)JsonTypeInfo.As.PROPERTY)) {
            return;
        }
        Optional<JsonSubTypes.Type> subType = Arrays.stream(jsonSubTypes.value()).filter(t -> t.value().equals(clazz)).findFirst();
        if (!subType.isPresent()) {
            return;
        }
        fields.add(0, new FieldMeta(jsonTypeInfo.property(), clazz, subType.get().name()));
    }

    @Override
    protected boolean skipProcessing(FieldMeta field) {
        return false;
    }

    @Override
    protected void handleSyntheticFields(FieldMeta field, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\"" + field.getSerializableName() + "\"" + ":" + "\"" + field.getSyntheticValue() + "\""});
        methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
    }

    @Override
    protected boolean skipAnnotationProcessing(FieldMeta field) {
        return field.getType().isPrimitive();
    }

    @Override
    protected void handleFieldKeys(Class<?> clazz, FieldMeta field, MethodSpec.Builder methodBuilder) {
        this.resolveInclusionLevel(clazz, field);
        if (field.getInclusionLevel() != JsonInclude.Include.ALWAYS) {
            CodeBlock inclusionCondition = this.constructInclusionCondition(field);
            if (field.isMaskable()) {
                methodBuilder.beginControlFlow("$L", new Object[]{inclusionCondition});
            }
        }
        methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\"" + field.getSerializableName() + "\"" + ":"});
    }

    @Override
    protected void handleFieldValues(FieldMeta field, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
        if (field.getInclusionLevel() != JsonInclude.Include.ALWAYS && field.isMaskable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    protected void returns(MethodSpec.Builder methodBuilder) {
        methodBuilder.beginControlFlow("if ($L.charAt($L.length() - 1) == ',')", new Object[]{"serialized", "serialized"});
        methodBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "}"});
    }

    @Override
    protected boolean skipRecursiveCall(Field field) {
        return false;
    }

    @Override
    protected void recursiveStatement(Rule rule, MethodSpec.Builder methodBuilder, Class<?> clazz, String getterName) {
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                this.addRecursiveStatement(methodBuilder, Helper.getPrimitiveArrayVariableName(rule, clazz.getComponentType()), getterName);
            } else {
                this.addRecursiveStatement(methodBuilder, Helper.getObjectArrayVariableName(rule), getterName);
            }
        } else if (String.class.isAssignableFrom(clazz)) {
            this.addRecursiveStatement(methodBuilder, Helper.getStringVariableName(rule), getterName);
        } else if (Map.class.isAssignableFrom(clazz)) {
            this.addRecursiveStatement(methodBuilder, Helper.getMapVariableName(rule), getterName);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.addRecursiveStatement(methodBuilder, Helper.getCollectionVariableName(rule), getterName);
        } else if (clazz.isPrimitive() || Helper.getWrapperTypes().contains(clazz)) {
            this.addRecursiveStatement(methodBuilder, Helper.getPrimitiveVariableName(rule, Primitives.wrap(clazz)), getterName);
        } else if (this.configuration.toStringSerializableClasses().contains(clazz)) {
            this.addRecursiveStatement(methodBuilder, Helper.getToStringVariableName(rule), getterName);
        } else if (clazz.isEnum()) {
            this.addRecursiveStatement(methodBuilder, Helper.getEnumVariableName(rule), getterName);
        } else if (Helper.getClassInformation(clazz) != null && Helper.getClassInformation(clazz).getSubClasses().isEmpty()) {
            this.addRecursiveStatement(methodBuilder, Helper.getVariableName(this.configuration, rule, clazz), getterName);
        } else {
            this.addDefaultRecursiveStatement(methodBuilder, getterName);
        }
    }

    private void addRecursiveStatement(MethodSpec.Builder methodBuilder, String methodName, String getterName) {
        methodBuilder.addStatement("$L.$L().$L($L.$L(), $L, $L, $L, $L)", new Object[]{Strings.SET_PARAMETER, methodName, Strings.INTERFACE_METHOD, Strings.OBJECT_PARAMETER, getterName, "eval", Strings.CLOAK_PARAMETER, Strings.SET_PARAMETER, "serialized"});
    }

    private void addDefaultRecursiveStatement(MethodSpec.Builder methodBuilder, String getterName) {
        methodBuilder.addStatement("$L.$L($L.$L(), $L, $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", Strings.OBJECT_PARAMETER, getterName, "eval", "serialized"});
    }

    private int findField(String name, List<FieldMeta> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            if (!fields.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void resolveInclusionLevel(Class<?> clazz, FieldMeta fieldMeta) {
        JsonSerialize classJsonSerialize = Helper.getAnnotation(clazz, JsonSerialize.class);
        JsonInclude classJsonInclude = Helper.getAnnotation(clazz, JsonInclude.class);
        JsonInclude.Include classInclusion = null;
        if (classJsonInclude == null && classJsonSerialize != null) {
            classInclusion = this.mapJsonSerialize(classJsonSerialize.include());
        } else if (classJsonInclude != null) {
            classInclusion = classJsonInclude.value();
        }
        JsonSerialize fieldJsonSerialize = fieldMeta.getField().getAnnotation(JsonSerialize.class);
        JsonInclude fieldJsonInclude = fieldMeta.getField().getAnnotation(JsonInclude.class);
        JsonInclude.Include fieldInclusion = null;
        if (fieldJsonInclude == null && fieldJsonSerialize != null) {
            fieldInclusion = this.mapJsonSerialize(fieldJsonSerialize.include());
        } else if (fieldJsonInclude != null) {
            fieldInclusion = fieldJsonInclude.value();
        }
        fieldMeta.setInclusionLevel(Optional.ofNullable(fieldInclusion).orElse(Optional.ofNullable(classInclusion).orElse(JsonInclude.Include.ALWAYS)));
    }

    private JsonInclude.Include mapJsonSerialize(JsonSerialize.Inclusion inclusion) {
        switch (inclusion) {
            case NON_NULL: {
                return JsonInclude.Include.NON_NULL;
            }
            case NON_EMPTY: {
                return JsonInclude.Include.NON_EMPTY;
            }
            case NON_DEFAULT: {
                return JsonInclude.Include.NON_DEFAULT;
            }
        }
        return JsonInclude.Include.ALWAYS;
    }

    private CodeBlock constructInclusionCondition(FieldMeta fieldMeta) {
        Field field = fieldMeta.getField();
        String getterName = Helper.getGetterName(field.getName(), Helper.isBoolean(field.getType()), field.getType().isPrimitive());
        if (field.getType().isPrimitive()) {
            if (fieldMeta.getInclusionLevel() == JsonInclude.Include.NON_DEFAULT) {
                Object value = Defaults.defaultValue(field.getType());
                return CodeBlock.of((String)"if ($L.$L() != $L)", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName, value});
            }
            fieldMeta.setMaskable(false);
            return null;
        }
        switch (fieldMeta.getInclusionLevel()) {
            case NON_DEFAULT: 
            case NON_NULL: {
                return CodeBlock.of((String)"if ($L.$L() != null)", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName});
            }
            case NON_EMPTY: {
                if (field.getType().isArray()) {
                    return CodeBlock.of((String)"if ($L.$L() != null && $L.$L().length > 0)", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName, Strings.OBJECT_PARAMETER, getterName});
                }
                if (Helper.getEmptiableTypes().stream().noneMatch(t -> t.isAssignableFrom(field.getType()))) {
                    fieldMeta.setMaskable(false);
                    return null;
                }
                return CodeBlock.of((String)"if ($L.$L() != null && !$L.$L().isEmpty())", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName, Strings.OBJECT_PARAMETER, getterName});
            }
        }
        fieldMeta.setMaskable(false);
        return null;
    }
}

