/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.util;

import com.flipkart.masquerade.rule.BasicRule;
import com.flipkart.masquerade.rule.CompositeRule;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.rule.ValueRule;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class Verifier {
    public static void verifyEvaluationObject(Rule rule) {
        Class<?> evaluatorClass = rule.getEvaluatorClass();
        ArrayList<String> accessors = new ArrayList<String>();
        Verifier.getAccessors(rule.getValueRule(), accessors);
        for (String accessor : accessors) {
            try {
                if (accessor.endsWith("()")) {
                    evaluatorClass.getMethod(accessor.substring(0, accessor.length() - 2), new Class[0]);
                    continue;
                }
                evaluatorClass.getField(accessor);
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                throw new UnsupportedOperationException("Please specify a PUBLIC method or field for evaluator accessor");
            }
        }
    }

    public static void verifyAnnotation(Rule rule) {
        Class<? extends Annotation> annotationClass = rule.getAnnotationClass();
        ArrayList<String> members = new ArrayList<String>();
        Verifier.getMembers(rule.getValueRule(), members);
        for (String member : members) {
            try {
                annotationClass.getDeclaredMethod(member, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("Please specify a method that belongs to the Annotation");
            }
        }
    }

    public static void verifyTypes(Rule rule) {
        Verifier.verifyValueRuleTypes(rule.getValueRule(), rule);
    }

    private static void verifyValueRuleTypes(ValueRule valueRule, Rule rule) {
        if (valueRule instanceof CompositeRule) {
            for (ValueRule subRule : ((CompositeRule)valueRule).getValueRules()) {
                Verifier.verifyValueRuleTypes(subRule, rule);
            }
        } else {
            BasicRule basicRule = (BasicRule)valueRule;
            Class<?> evaluatorClass = rule.getEvaluatorClass();
            Class<? extends Annotation> annotationClass = rule.getAnnotationClass();
            try {
                String accessor = basicRule.getEvaluatorFunction();
                Class<?> evaluatorReturnType = accessor.endsWith("()") ? evaluatorClass.getMethod(accessor.substring(0, accessor.length() - 2), new Class[0]).getReturnType() : evaluatorClass.getField(accessor).getType();
                Class<?> annotationMemberReturnType = annotationClass.getDeclaredMethod(basicRule.getAnnotationMember(), new Class[0]).getReturnType();
                if (!evaluatorReturnType.getName().equals(annotationMemberReturnType.getName())) {
                    throw new UnsupportedOperationException("Accessors and Annotation members should be compatible");
                }
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                throw new UnsupportedOperationException("Please specify a PUBLIC method or field for evaluator accessor");
            }
        }
    }

    private static void getMembers(ValueRule valueRule, List<String> members) {
        if (valueRule instanceof CompositeRule) {
            for (ValueRule subRule : ((CompositeRule)valueRule).getValueRules()) {
                Verifier.getMembers(subRule, members);
            }
        } else {
            BasicRule basicRule = (BasicRule)valueRule;
            members.add(basicRule.getAnnotationMember());
        }
    }

    private static void getAccessors(ValueRule valueRule, List<String> accessors) {
        if (valueRule instanceof CompositeRule) {
            for (ValueRule subRule : ((CompositeRule)valueRule).getValueRules()) {
                Verifier.getAccessors(subRule, accessors);
            }
        } else {
            BasicRule basicRule = (BasicRule)valueRule;
            accessors.add(basicRule.getEvaluatorFunction());
        }
    }
}

