/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.Masquerade;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="masquerade", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Masque
extends AbstractMojo {
    @Parameter(required=true)
    private String configurationClass;
    @Parameter(required=true)
    private File targetFile;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.addProjectDependenciesToClasspath();
        this.getLog().info((CharSequence)("Fetching Configuration from " + this.configurationClass));
        String classInput = this.configurationClass;
        try {
            Class<?> configurationClass = Class.forName(classInput, true, Thread.currentThread().getContextClassLoader());
            Configuration configuration = (Configuration)configurationClass.newInstance();
            this.getLog().info((CharSequence)"Configuration instance created.");
            Masquerade.initialize((Configuration)configuration, (ClassLoader)Thread.currentThread().getContextClassLoader(), (File)this.targetFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Wrong configuration class", e);
        }
        this.getLog().info((CharSequence)"Masquerade is open for invites.");
    }

    private void addProjectDependenciesToClasspath() {
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = this.getClassLoader(this.project, oldClassLoader, this.getLog());
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)"Skipping addition of project artifacts, there appears to be a dependecy resolution problem", (Throwable)e);
        }
    }

    public ClassLoader getClassLoader(MavenProject project, final ClassLoader parent, Log log) throws DependencyResolutionRequiredException {
        List classpathElements = project.getCompileClasspathElements();
        final ArrayList<URL> classpathUrls = new ArrayList<URL>(classpathElements.size());
        for (String classpathElement : classpathElements) {
            try {
                log.debug((CharSequence)("Adding project artifact to classpath: " + classpathElement));
                classpathUrls.add(new File(classpathElement).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.debug((CharSequence)("Unable to use classpath entry as it could not be understood as a valid URL: " + classpathElement), (Throwable)e);
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), parent);
            }
        });
    }
}

