/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.turbo.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AlertzConfig {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static AlertzConfig defaultAlertzConfig = new AlertzConfig();
    private int severity = 0;
    private Integer pendingMessage;
    private Integer sidelinedMessages;
    private Integer rowsAvailability;

    public int getPendingMessage() {
        return this.pendingMessage != null ? this.pendingMessage : 10000;
    }

    public int getSidelinedMessages() {
        return this.sidelinedMessages != null ? this.sidelinedMessages : 0;
    }

    public int getRowsAvailability() {
        return this.rowsAvailability != null ? this.rowsAvailability : 300000;
    }

    public int getSeverity() {
        if (this.severity < 0 || this.severity > 3) {
            this.severity = 0;
        }
        return this.severity;
    }

    public static String getSeverityString(int severity) {
        switch (severity) {
            case 0: {
                return "SEV0";
            }
            case 1: {
                return "SEV1";
            }
            case 2: {
                return "SEV2";
            }
            case 3: {
                return "SEV3";
            }
        }
        return "SEV0";
    }

    public static List<AlertzConfig> parseOrDefault(List<String> config) {
        if (config == null) {
            return AlertzConfig.defaultAlertzConfigList();
        }
        try {
            List<AlertzConfig> alertzConfigs = OBJECT_MAPPER.convertValue(config, new TypeReference<List<AlertzConfig>>(){});
            if (alertzConfigs == null || alertzConfigs.isEmpty()) {
                return AlertzConfig.defaultAlertzConfigList();
            }
            return alertzConfigs;
        }
        catch (Exception e) {
            return AlertzConfig.defaultAlertzConfigList();
        }
    }

    public static List<AlertzConfig> defaultAlertzConfigList() {
        ArrayList<AlertzConfig> alertzConfigs = new ArrayList<AlertzConfig>();
        alertzConfigs.add(defaultAlertzConfig);
        return alertzConfigs;
    }

    public String toString() {
        return "AlertzConfig(severity=" + this.getSeverity() + ", pendingMessage=" + this.getPendingMessage() + ", sidelinedMessages=" + this.getSidelinedMessages() + ", rowsAvailability=" + this.getRowsAvailability() + ")";
    }
}

