/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.client.entity;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.restbus.client.entity.Message;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundMessage.class);
    private String messageId;
    private Boolean isRelayed;
    private Date relayedAt;
    private String exchangeName;
    private String message;
    private String httpMethod;
    private String httpUri;
    private Date createdAt;
    private Date updatedAt;
    private Long inboundMessageId;
    private String exchangeType;
    private String appId;
    private String correlationId;
    private String groupId;
    private String replyTo;
    private String replyToHttpUri;
    private String replyToHttpMethod;
    private String txnId;
    private String context;
    private Integer destinationResponseStatus;
    private String customHeaders;
    private String routingKey;
    private String relayError;
    private Long retries;

    public OutboundMessage() {
    }

    public OutboundMessage(Message message) {
        this.messageId = message.getId();
        this.exchangeName = message.getExchangeName();
        this.exchangeType = message.getExchangeType();
        this.message = message.getPayload();
        this.inboundMessageId = message.getInboundMessageId();
        this.appId = message.getAppId();
        this.groupId = message.getGroupId();
        this.correlationId = message.getCorrelationId();
        this.routingKey = message.getRoutingKey();
        this.httpMethod = message.getHttpMethod();
        this.httpUri = message.getHttpUri();
        this.replyTo = message.getReplyTo();
        this.replyToHttpMethod = message.getReplyToHttpMethod();
        this.replyToHttpUri = message.getReplyToHttpUri();
        this.txnId = message.getTransactionId();
        this.routingKey = message.getRoutingKey();
        this.context = message.getContext();
        this.destinationResponseStatus = message.getDestinationResponseStatus();
        this.createdAt = message.getCreatedAt();
        this.updatedAt = message.getUpdatedAt();
        this.isRelayed = message.getIsRelayed();
        this.relayedAt = message.getRelayedAt();
        this.relayError = message.getRelayError();
        this.retries = message.getRetries();
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.customHeaders = mapper.writeValueAsString(message.getCustomHeaders());
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception while parsing headers", (Throwable)e);
        }
    }

    public Boolean isRelayed() {
        return this.isRelayed;
    }

    public void setRelayed(Boolean isRelayed) {
        this.isRelayed = isRelayed;
    }

    public Date getRelayedAt() {
        return this.relayedAt;
    }

    public void setRelayedAt(Date relayedAt) {
        this.relayedAt = relayedAt;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Long getInboundMessageId() {
        return this.inboundMessageId;
    }

    public void setInboundMessageId(Long inboundMessageId) {
        this.inboundMessageId = inboundMessageId;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public String getRelayError() {
        return this.relayError;
    }

    public void setRelayError(String relayError) {
        this.relayError = relayError;
    }

    public Long getRetries() {
        return this.retries;
    }

    public void setRetries(Long retries) {
        this.retries = retries;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(String httpUri) {
        this.httpUri = httpUri;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReplyToHttpUri() {
        return this.replyToHttpUri;
    }

    public void setReplyToHttpUri(String replyToHttpUri) {
        this.replyToHttpUri = replyToHttpUri;
    }

    public String getReplyToHttpMethod() {
        return this.replyToHttpMethod;
    }

    public void setReplyToHttpMethod(String replyToHttpMethod) {
        this.replyToHttpMethod = replyToHttpMethod;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Integer getDestinationResponseStatus() {
        return this.destinationResponseStatus;
    }

    public void setDestinationResponseStatus(Integer destinationResponseStatus) {
        this.destinationResponseStatus = destinationResponseStatus;
    }

    public String getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(String customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutboundMessage other = (OutboundMessage)obj;
        return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
    }

    public String toString() {
        return "OutboundMessage {messageId='" + this.messageId + '\'' + ", exchangeName='" + this.exchangeName + '\'' + ", httpMethod='" + this.httpMethod + '\'' + ", httpUri='" + this.httpUri + '\'' + ", exchangeType='" + this.exchangeType + '\'' + ", groupId='" + this.groupId + '\'' + ", txnId='" + this.txnId + '\'' + '}';
    }

    public static enum HttpMethod {
        PUT,
        POST;

    }

    public static enum ExchangeType {
        queue,
        topic;

    }
}

