/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.client.shards;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.shards.ExchangeBasedOMShardStrategy;
import com.flipkart.restbus.client.shards.OMShardStrategy;
import com.flipkart.restbus.client.shards.TimeBasedOMShardStrategy;
import org.apache.commons.lang.StringUtils;

public class MixedShardStrategy
extends OMShardStrategy {
    private TimeBasedOMShardStrategy timeStrategy;
    private ExchangeBasedOMShardStrategy exchangeStrategy;

    public MixedShardStrategy(TimeBasedOMShardStrategy timeStrategy, ExchangeBasedOMShardStrategy exchangeStrategy) {
        this.timeStrategy = timeStrategy;
        this.exchangeStrategy = exchangeStrategy;
    }

    @Override
    public String getShardSuffix(OutboundMessage message) {
        String timeSuffix = this.timeStrategy.getShardSuffix(message);
        String exchangeSuffix = this.exchangeStrategy.getShardSuffix(message);
        if (this.valid(timeSuffix) && this.valid(exchangeSuffix)) {
            return exchangeSuffix + "_" + timeSuffix;
        }
        if (this.valid(exchangeSuffix)) {
            return exchangeSuffix;
        }
        return timeSuffix;
    }

    private boolean valid(String s) {
        return StringUtils.isNotBlank((String)s);
    }
}

