/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.shards.Shard;
import com.flipkart.restbus.client.shards.ShardStrategy;
import com.flipkart.restbus.hibernate.client.OutboundMessageRepository;
import com.flipkart.restbus.hibernate.utils.OutboundMessageUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class HibernateOutboundMessageShardRepository
implements OutboundMessageRepository {
    private final ShardStrategy<OutboundMessage> shardStrategy;
    private final Session session;

    public HibernateOutboundMessageShardRepository(Session session, ShardStrategy<OutboundMessage> shardStrategy) {
        this.session = session;
        this.shardStrategy = shardStrategy;
    }

    @Override
    public void persist(OutboundMessage message) {
        message.setCreatedAt(OutboundMessageUtils.convertToSqlTimestamp(message.getCreatedAt()));
        Shard shard = this.shardStrategy.resolve(message);
        OutboundMessageUtils.ensureShard(this.session, shard);
        OutboundMessageUtils.insertInto(this.session, shard, message);
    }

    @Override
    public void persist(List<OutboundMessage> messages) {
        final Map<String, List<OutboundMessage>> shardToOutboundMessages = this.groupOutboundMessagesByShardName(messages);
        this.session.doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                for (Map.Entry entry : shardToOutboundMessages.entrySet()) {
                    String shardName = (String)entry.getKey();
                    List outboundMessages = (List)entry.getValue();
                    PreparedStatement preparedStatement = connection.prepareStatement(OutboundMessageUtils.getCreateSqlQueryForOutboundMessages(shardName));
                    try {
                        OutboundMessageUtils.bulkInsertMessages(preparedStatement, outboundMessages);
                    }
                    finally {
                        if (null == preparedStatement) continue;
                        preparedStatement.close();
                    }
                }
            }
        });
    }

    @Override
    public void persist(String dbShard, List<OutboundMessage> messages) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private Map<String, List<OutboundMessage>> groupOutboundMessagesByShardName(List<OutboundMessage> messages) {
        HashMap<String, List<OutboundMessage>> map = new HashMap<String, List<OutboundMessage>>();
        for (OutboundMessage message : messages) {
            message.setCreatedAt(OutboundMessageUtils.convertToSqlTimestamp(message.getCreatedAt()));
            Shard shard = this.shardStrategy.resolve(message);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(message);
        }
        return map;
    }

    @Override
    public OutboundMessage findMessageById(String messageId, String tableName) {
        return OutboundMessageUtils.findOutboundMessageByMessageId(this.session, messageId, tableName);
    }
}

