/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.client;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.client.shards.Shard;
import com.flipkart.restbus.client.shards.ShardStrategy;
import com.flipkart.restbus.hibernate.client.OutboundMessageRepository;
import com.flipkart.restbus.hibernate.models.OutboundMessageEntity;
import com.flipkart.restbus.hibernate.models.TurboAppMessageEntity;
import com.flipkart.restbus.hibernate.models.TurboOutboundMessageEntity;
import com.flipkart.restbus.hibernate.utils.OutboundMessageUtils;
import com.flipkart.restbus.hibernate.utils.TurboOutboundMessageUtils;
import com.flipkart.restbus.turbo.config.TurboSessionProvider;
import com.flipkart.restbus.turbo.shard.DynamicShardStrategy;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class TurboHibernateOutboundMessageShardRepository
implements OutboundMessageRepository {
    private final Session session;
    private Boolean isMultiDbWriteEnabled;
    private Boolean isSingleDbWriteEnabled;
    private boolean turboOutboundWithoutTrxEnabled;
    private final ShardStrategy<OutboundMessage> omsShardStrategy;
    private final DynamicShardStrategy<OutboundMessage> turboShardStrategy;

    public TurboHibernateOutboundMessageShardRepository(Session session, ShardStrategy<OutboundMessage> omsShardStrategy, DynamicShardStrategy<OutboundMessage> turboShardStrategy, Boolean isMultiDbWriteEnabled, Boolean isSingleDbWriteEnabled, boolean turboOutboundWithoutTrxEnabled) {
        this.session = session;
        this.omsShardStrategy = omsShardStrategy;
        this.turboShardStrategy = turboShardStrategy;
        this.isMultiDbWriteEnabled = isMultiDbWriteEnabled;
        this.isSingleDbWriteEnabled = isSingleDbWriteEnabled;
        this.turboOutboundWithoutTrxEnabled = turboOutboundWithoutTrxEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(OutboundMessage message) {
        OutboundMessageEntity outboundMessageEntity = new OutboundMessageEntity(message);
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            message.setCreatedAt(TurboOutboundMessageUtils.convertToSqlTimestamp(message.getCreatedAt()));
            Shard shard = this.omsShardStrategy.resolve(message);
            TurboOutboundMessageUtils.ensureShard(this.session, shard);
            TurboOutboundMessageUtils.insertInto(this.session, shard, outboundMessageEntity);
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            final Shard outboundShard = this.turboShardStrategy.resolve("messages", message);
            final Shard appShard = this.turboShardStrategy.resolve("message_meta_data", message);
            Session outboundSession = TurboSessionProvider.getSession();
            try {
                final ArrayList<TurboOutboundMessageEntity> outboundMessageEntities = new ArrayList<TurboOutboundMessageEntity>();
                outboundMessageEntities.add(new TurboOutboundMessageEntity(message));
                ArrayList<String> messageIds = new ArrayList<String>();
                messageIds.add(message.getMessageId());
                outboundSession.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboOutboundMessages(outboundShard.getShardName()));
                        try {
                            TurboOutboundMessageUtils.bulkInsertTurboMessages(preparedStatement, outboundMessageEntities);
                        }
                        catch (BatchUpdateException e) {
                            throw e;
                        }
                        finally {
                            if (null != preparedStatement) {
                                preparedStatement.close();
                            }
                        }
                    }
                });
                if (!this.turboOutboundWithoutTrxEnabled) {
                    final List<TurboAppMessageEntity> turboAppMessageEntities = TurboOutboundMessageUtils.prepareTurboAppEntities(outboundSession, messageIds, this.turboShardStrategy.resolve("messages", message).getShardName());
                    this.session.doWork(new Work(){

                        public void execute(Connection connection) throws SQLException {
                            PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboMetaData(appShard.getShardName()));
                            try {
                                TurboOutboundMessageUtils.bulkInsertTurboMetaData(preparedStatement, turboAppMessageEntities);
                            }
                            catch (BatchUpdateException e) {
                                throw e;
                            }
                            finally {
                                if (null != preparedStatement) {
                                    preparedStatement.close();
                                }
                            }
                        }
                    });
                }
            }
            finally {
                TurboSessionProvider.closeSession(outboundSession);
            }
        }
    }

    @Override
    public void persist(List<OutboundMessage> messages) {
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            this.fkscFormatWrite(messages);
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            this.turboFormatWrite(TurboSessionProvider.getSession(), messages);
        }
    }

    @Override
    public void persist(String dbShard, List<OutboundMessage> messages) throws ConfigurationException {
        if (this.isSingleDbWriteEnabled.booleanValue()) {
            this.fkscFormatWrite(messages);
        }
        if (this.isMultiDbWriteEnabled.booleanValue()) {
            this.turboFormatWrite(TurboSessionProvider.getSession(dbShard), messages);
        }
    }

    private List<String> getMessageIds(List<OutboundMessage> messages) {
        ArrayList<String> messageIds = new ArrayList<String>();
        for (OutboundMessage message : messages) {
            messageIds.add(message.getMessageId());
        }
        return messageIds;
    }

    private Map<String, List<OutboundMessageEntity>> groupOutboundMessagesByShardName(List<OutboundMessage> messages) {
        HashMap<String, List<OutboundMessageEntity>> map = new HashMap<String, List<OutboundMessageEntity>>();
        for (OutboundMessage message : messages) {
            message.setCreatedAt(TurboOutboundMessageUtils.convertToSqlTimestamp(message.getCreatedAt()));
            OutboundMessageEntity outboundMessageEntity = new OutboundMessageEntity(message);
            Shard shard = this.omsShardStrategy.resolve(message);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(outboundMessageEntity);
        }
        return map;
    }

    private Map<String, List<TurboOutboundMessageEntity>> groupTurboOutboundMessagesByShardName(List<OutboundMessage> messages) {
        HashMap<String, List<TurboOutboundMessageEntity>> map = new HashMap<String, List<TurboOutboundMessageEntity>>();
        for (OutboundMessage message : messages) {
            message.setCreatedAt(TurboOutboundMessageUtils.convertToSqlTimestamp(message.getCreatedAt()));
            TurboOutboundMessageEntity outboundMessageEntity = new TurboOutboundMessageEntity(message);
            Shard shard = this.turboShardStrategy.resolve("messages", message);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(outboundMessageEntity);
        }
        return map;
    }

    private Map<String, List<OutboundMessage>> groupOutboundMessageByAppShardName(List<OutboundMessage> messages) {
        HashMap<String, List<OutboundMessage>> map = new HashMap<String, List<OutboundMessage>>();
        for (OutboundMessage message : messages) {
            Shard shard = this.turboShardStrategy.resolve("message_meta_data", message);
            String shardName = shard.getShardName();
            if (!map.containsKey(shardName)) {
                map.put(shardName, new ArrayList());
            }
            ((List)map.get(shardName)).add(message);
        }
        return map;
    }

    @Override
    public OutboundMessage findMessageById(String messageId, String tableName) {
        return OutboundMessageUtils.findOutboundMessageByMessageId(this.session, messageId, tableName);
    }

    private void fkscFormatWrite(List<OutboundMessage> messages) {
        final Map<String, List<OutboundMessageEntity>> shardToOutboundMessages = this.groupOutboundMessagesByShardName(messages);
        this.session.doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                for (Map.Entry entry : shardToOutboundMessages.entrySet()) {
                    Shard shard = TurboHibernateOutboundMessageShardRepository.this.omsShardStrategy.resolve(((List)entry.getValue()).get(0));
                    TurboOutboundMessageUtils.ensureShard(TurboHibernateOutboundMessageShardRepository.this.session, shard);
                    String shardName = (String)entry.getKey();
                    List outboundMessages = (List)entry.getValue();
                    PreparedStatement preparedStatement = connection.prepareStatement(OutboundMessageUtils.getCreateSqlQueryForOutboundMessages(shardName));
                    try {
                        TurboOutboundMessageUtils.bulkInsertMessages(preparedStatement, outboundMessages);
                    }
                    finally {
                        if (null == preparedStatement) continue;
                        preparedStatement.close();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turboFormatWrite(Session outboundSession, List<OutboundMessage> messages) {
        try {
            String shardName;
            Map<String, List<TurboOutboundMessageEntity>> shardToTurboOutboundMessages = this.groupTurboOutboundMessagesByShardName(messages);
            Map<String, List<OutboundMessage>> appShardToMessages = this.groupOutboundMessageByAppShardName(messages);
            for (Map.Entry<String, List<TurboOutboundMessageEntity>> entry : shardToTurboOutboundMessages.entrySet()) {
                shardName = entry.getKey();
                final List<TurboOutboundMessageEntity> turboOutboundMessageEntities = entry.getValue();
                outboundSession.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboOutboundMessages(shardName));
                        try {
                            TurboOutboundMessageUtils.bulkInsertTurboMessages(preparedStatement, turboOutboundMessageEntities);
                        }
                        catch (BatchUpdateException e) {
                            throw e;
                        }
                        finally {
                            if (null != preparedStatement) {
                                preparedStatement.close();
                            }
                        }
                    }
                });
            }
            if (!this.turboOutboundWithoutTrxEnabled) {
                for (Map.Entry<String, List<Object>> entry : appShardToMessages.entrySet()) {
                    shardName = entry.getKey();
                    String outboundShardName = this.turboShardStrategy.resolve("messages", (OutboundMessage)entry.getValue().get(0)).getShardName();
                    final List<TurboAppMessageEntity> turboAppMessageEntities = TurboOutboundMessageUtils.prepareTurboAppEntities(outboundSession, this.getMessageIds(entry.getValue()), outboundShardName);
                    this.session.doWork(new Work(){

                        public void execute(Connection connection) throws SQLException {
                            PreparedStatement preparedStatement = connection.prepareStatement(TurboOutboundMessageUtils.getCreateSqlQueryForTurboMetaData(shardName));
                            try {
                                TurboOutboundMessageUtils.bulkInsertTurboMetaData(preparedStatement, turboAppMessageEntities);
                            }
                            catch (BatchUpdateException e) {
                                throw e;
                            }
                            finally {
                                if (null != preparedStatement) {
                                    preparedStatement.close();
                                }
                            }
                        }
                    });
                }
            }
        }
        finally {
            TurboSessionProvider.closeSession(outboundSession);
        }
    }
}

