/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.hibernate.models;

import com.flipkart.restbus.client.entity.OutboundMessage;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="outbound_messages")
public class OutboundMessageEntity
extends OutboundMessage {
    private Long id;
    private Byte relayedByte;

    public OutboundMessageEntity() {
        this.setCreatedAt(new Timestamp(new Date().getTime()));
        this.setUpdatedAt(this.getCreatedAt());
    }

    public OutboundMessageEntity(OutboundMessage message) {
        this();
        this.setMessageId(message.getMessageId());
        this.setExchangeName(message.getExchangeName());
        this.setExchangeType(message.getExchangeType());
        this.setMessage(message.getMessage());
        this.setInboundMessageId(message.getInboundMessageId());
        this.setAppId(message.getAppId());
        this.setGroupId(message.getGroupId());
        this.setCorrelationId(message.getCorrelationId());
        this.setRoutingKey(message.getRoutingKey());
        this.setHttpMethod(message.getHttpMethod());
        this.setHttpUri(message.getHttpUri());
        this.setReplyTo(message.getReplyTo());
        this.setReplyToHttpMethod(message.getReplyToHttpMethod());
        this.setReplyToHttpUri(message.getReplyToHttpUri());
        this.setTxnId(message.getTxnId());
        this.setRoutingKey(message.getRoutingKey());
        this.setContext(message.getContext());
        this.setDestinationResponseStatus(message.getDestinationResponseStatus());
        if (message.getCreatedAt() != null) {
            this.setCreatedAt(message.getCreatedAt());
        }
        if (message.getUpdatedAt() != null) {
            this.setUpdatedAt(message.getUpdatedAt());
        }
        this.setRelayed(message.isRelayed());
        this.setRelayedAt(message.getRelayedAt());
        this.setRelayError(message.getRelayError());
        this.setRetries(message.getRetries());
        this.setCustomHeaders(message.getCustomHeaders());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="message_id")
    public String getMessageId() {
        return super.getMessageId();
    }

    @Override
    @Transient
    public Boolean isRelayed() {
        return super.isRelayed();
    }

    @Column(name="relayed")
    public Byte getRelayedByte() {
        return this.relayedByte;
    }

    public void setRelayedByte(Byte relayedByte) {
        this.relayedByte = relayedByte;
    }

    @Override
    @Column(name="relayed_at")
    public Date getRelayedAt() {
        return super.getRelayedAt();
    }

    @Override
    @Column(name="exchange_name")
    public String getExchangeName() {
        return super.getExchangeName();
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at")
    public Date getCreatedAt() {
        return super.getCreatedAt();
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    @Version
    @Column(name="updated_at")
    public Date getUpdatedAt() {
        return super.getUpdatedAt();
    }

    @Override
    @Column(name="inbound_message_id")
    public Long getInboundMessageId() {
        return super.getInboundMessageId();
    }

    @Override
    @Column(name="exchange_type")
    public String getExchangeType() {
        return super.getExchangeType();
    }

    @Override
    @Column(name="app_id")
    public String getAppId() {
        return super.getAppId();
    }

    @Override
    @Column(name="correlation_id")
    public String getCorrelationId() {
        return super.getCorrelationId();
    }

    @Override
    @Column(name="group_id")
    public String getGroupId() {
        return super.getGroupId();
    }

    @Override
    @Column(name="http_method")
    public String getHttpMethod() {
        return super.getHttpMethod();
    }

    @Override
    @Column(name="http_uri")
    public String getHttpUri() {
        return super.getHttpUri();
    }

    @Override
    @Column(name="reply_to")
    public String getReplyTo() {
        return super.getReplyTo();
    }

    @Override
    @Column(name="reply_to_http_method")
    public String getReplyToHttpMethod() {
        return super.getReplyToHttpMethod();
    }

    @Override
    @Column(name="routing_key")
    public String getRoutingKey() {
        return super.getRoutingKey();
    }

    @Override
    @Column(name="relay_error")
    public String getRelayError() {
        return super.getRelayError();
    }

    @Override
    @Column(name="retries")
    public Long getRetries() {
        return super.getRetries();
    }

    @Override
    @Column(name="reply_to_http_uri")
    public String getReplyToHttpUri() {
        return super.getReplyToHttpUri();
    }

    @Override
    @Column(name="txn_id")
    public String getTxnId() {
        return super.getTxnId();
    }

    @Override
    public String getContext() {
        return super.getContext();
    }

    @Override
    @Column(name="destination_response_status")
    public Integer getDestinationResponseStatus() {
        return super.getDestinationResponseStatus();
    }

    @Override
    @Column(name="custom_headers")
    public String getCustomHeaders() {
        return super.getCustomHeaders();
    }
}

