/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.turbo.config;

import com.flipkart.restbus.turbo.shard.ExchangeBasedTurboShardStrategy;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class TurboConfig
implements Serializable {
    private static final String HIBERNATE_CONNECTION_PASSWORD = "hibernate.connection.password";
    Boolean multiDbWriteEnabled = false;
    Boolean singleDbWriteEnabled = true;
    Boolean turboOutboundWithoutTrxEnabled = false;
    Properties mysql;
    public boolean sharding;
    String appDbType;
    Map<String, Properties> db_shards;
    public ExchangeBasedTurboShardStrategy.Config queue_shard_strategy;
    private Long payloadLength;
    private static final Logger logger = LoggerFactory.getLogger(TurboConfig.class);

    public static TurboConfig parseDocument(InputStream yaml) {
        TurboConfig config;
        try {
            Representer representer = new Representer();
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml snake = new Yaml((BaseConstructor)new Constructor(TurboConfig.class), representer);
            config = (TurboConfig)snake.load(yaml);
        }
        catch (YAMLException e) {
            e.printStackTrace();
            config = null;
        }
        return config;
    }

    public Boolean isTurboOutboundWithoutTrxEnabled() {
        return this.turboOutboundWithoutTrxEnabled;
    }

    public void setTurboOutboundWithoutTrxEnabled(Boolean turboOutboundWithoutTrxEnabled) {
        this.turboOutboundWithoutTrxEnabled = turboOutboundWithoutTrxEnabled;
    }

    public Boolean getMultiDbWriteEnabled() {
        return this.multiDbWriteEnabled;
    }

    public void setMultiDbWriteEnabled(Boolean multiDbWriteEnabled) {
        this.multiDbWriteEnabled = multiDbWriteEnabled;
    }

    public Boolean getSingleDbWriteEnabled() {
        return this.singleDbWriteEnabled;
    }

    public void setSingleDbWriteEnabled(Boolean singleDbWriteEnabled) {
        this.singleDbWriteEnabled = singleDbWriteEnabled;
    }

    public Properties getMysql() {
        return this.mysql;
    }

    public void setMysql(Properties mysql) {
        this.mysql = mysql;
    }

    public Properties getDbShard(String dbShard) {
        if (dbShard == null) {
            return null;
        }
        return this.db_shards.get(dbShard);
    }

    public Map<String, Properties> getDbShards() {
        return this.db_shards;
    }

    public void setDb_shards(Map<String, Properties> db_shards) {
        this.db_shards = db_shards;
        if (db_shards != null) {
            HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
            for (Map.Entry<String, Properties> entry : db_shards.entrySet()) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)entry.getValue());
                propertiesMap.put(entry.getKey(), properties);
            }
            this.db_shards = propertiesMap;
        }
    }

    public String getAppDbType() {
        return this.appDbType;
    }

    public void setAppDbType(String appDbType) {
        this.appDbType = appDbType;
    }

    public Long getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(Long payloadLength) {
        this.payloadLength = payloadLength;
    }
}

