/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.turbo.config;

import com.flipkart.restbus.turbo.config.TurboConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurboConfigProvider {
    private static TurboConfig config = null;
    private static final String DEFAULT_TURBO_CONFIG_FILE_PATH = "/etc/fk-sc-mq/turbo.yml";
    private static final Logger logger = LoggerFactory.getLogger(TurboConfigProvider.class);

    public static TurboConfig getConfig() {
        if (config == null) {
            String configFilePath = System.getProperty("SC_MQ_TURBO_CONFIG");
            if (configFilePath == null || configFilePath.isEmpty()) {
                configFilePath = DEFAULT_TURBO_CONFIG_FILE_PATH;
            }
            config = TurboConfigProvider.loadConfigFromPath(configFilePath);
        }
        return config;
    }

    public static TurboConfig loadConfigFromPath(String configFilePath) {
        TurboConfig config;
        if (configFilePath == null || configFilePath.trim().length() == 0) {
            throw new IllegalArgumentException("config path can't be empty/null");
        }
        try {
            Map<String, Properties> dbShards;
            FileInputStream document = new FileInputStream(new File(configFilePath));
            config = TurboConfig.parseDocument(document);
            if (config.getMysql() != null) {
                config.getMysql().setProperty("hibernate.connection.autocommit", "true");
            }
            if ((dbShards = config.getDbShards()) != null) {
                for (Properties property : dbShards.values()) {
                    property.setProperty("hibernate.connection.autocommit", "true");
                }
            }
            logger.info("Turbo Outbound Message config loaded from " + configFilePath);
        }
        catch (FileNotFoundException e) {
            if (DEFAULT_TURBO_CONFIG_FILE_PATH.equals(configFilePath)) {
                logger.debug("Default turbo config at /etc/fk-sc-mq/turbo.yml not found.");
            } else {
                logger.error(configFilePath + " file not found.");
            }
            config = new TurboConfig();
        }
        return config;
    }

    public static TurboConfig setConfig(TurboConfig turboConfig) {
        if (turboConfig == null) {
            throw new IllegalArgumentException("Turbo Config can't be null");
        }
        config = turboConfig;
        return config;
    }
}

