/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.turbo.shard;

import com.flipkart.restbus.client.entity.OutboundMessage;
import com.flipkart.restbus.turbo.shard.TurboShardStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExchangeBasedTurboShardStrategy
extends TurboShardStrategy {
    private Config config;
    private Map<String, String> patternToCluster;

    public ExchangeBasedTurboShardStrategy(Config config) {
        this.config = config;
        this.generateReverseMapping();
    }

    private void generateReverseMapping() {
        this.patternToCluster = new HashMap<String, String>();
        if (this.config != null && this.config.clusters != null) {
            for (String clusterName : this.config.clusters.keySet()) {
                List<String> patterns = this.config.clusters.get(clusterName);
                for (String pattern : patterns) {
                    this.patternToCluster.put(pattern, clusterName);
                }
            }
        }
    }

    @Override
    public String getShardPrefix(OutboundMessage message) {
        String exchangeName = message.getExchangeName();
        String clusterName = null;
        for (Map.Entry<String, String> entry : this.patternToCluster.entrySet()) {
            String pattern = entry.getKey();
            String cluster = entry.getValue();
            if (!exchangeName.matches(pattern)) continue;
            clusterName = cluster;
            break;
        }
        return clusterName != null ? clusterName : this.config.default_suffix;
    }

    public static class Config {
        public String default_suffix;
        public Map<String, List<String>> clusters;
    }
}

