/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.restbus.turbo.shard;

import com.flipkart.restbus.turbo.config.TurboConfig;
import com.flipkart.restbus.turbo.config.TurboConfigProvider;
import com.flipkart.restbus.turbo.shard.ExchangeBasedTurboShardStrategy;
import com.flipkart.restbus.turbo.shard.TurboShardStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurboShardStrategyProvider {
    private static final Logger logger = LoggerFactory.getLogger(TurboShardStrategyProvider.class);
    private static final String TYPE_QUEUE_BASED = "queue_based";
    private static TurboShardStrategy strategy = null;

    private static TurboShardStrategy createShardStrategy(TurboConfig config) {
        ExchangeBasedTurboShardStrategy shardStrategy = null;
        if (config != null && config.sharding && config.queue_shard_strategy != null) {
            shardStrategy = new ExchangeBasedTurboShardStrategy(config.queue_shard_strategy);
        }
        return shardStrategy;
    }

    public static TurboShardStrategy getStrategy() {
        if (strategy == null) {
            TurboConfig turboConfig = TurboConfigProvider.getConfig();
            strategy = TurboShardStrategyProvider.getStrategy(turboConfig);
            logger.info("Using shard strategy: " + strategy);
        }
        return strategy;
    }

    public static TurboShardStrategy getStrategy(TurboConfig config) {
        return TurboShardStrategyProvider.createShardStrategy(config);
    }
}

