/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.varadhi.entities.InternalQueueCategory;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@queueType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Main.class, name="main"), @JsonSubTypes.Type(value=Retry.class, name="retry"), @JsonSubTypes.Type(value=DeadLetter.class, name="dead-letter")})
public abstract sealed class InternalQueueType {
    @JsonIgnore
    public abstract InternalQueueCategory getCategory();

    public static Main mainType() {
        return Main.MAIN;
    }

    public static DeadLetter deadLetterType() {
        return DeadLetter.DEADLETTER;
    }

    public static Retry retryType(int retryCount) {
        if (retryCount < 1 || retryCount > 9) {
            throw new IllegalArgumentException("Invalid retry count: " + retryCount);
        }
        return Retry.RETRY[retryCount - 1];
    }

    public static final class Main
    extends InternalQueueType {
        public static final Main MAIN = new Main();

        @Override
        public InternalQueueCategory getCategory() {
            return InternalQueueCategory.MAIN;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Main;
        }

        public int hashCode() {
            return Main.class.hashCode();
        }

        public String toString() {
            return "Main";
        }

        @JsonCreator
        @Generated
        public Main() {
        }
    }

    public static final class DeadLetter
    extends InternalQueueType {
        public static final DeadLetter DEADLETTER = new DeadLetter();

        @Override
        public InternalQueueCategory getCategory() {
            return InternalQueueCategory.DEAD_LETTER;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof DeadLetter;
        }

        public int hashCode() {
            return DeadLetter.class.hashCode();
        }

        public String toString() {
            return "DeadLetter";
        }

        @JsonCreator
        @Generated
        public DeadLetter() {
        }
    }

    public static final class Retry
    extends InternalQueueType {
        public static final Retry[] RETRY = new Retry[]{new Retry(1), new Retry(2), new Retry(3), new Retry(4), new Retry(5), new Retry(6), new Retry(7), new Retry(8), new Retry(9)};
        private final int retryCount;

        @Override
        public InternalQueueCategory getCategory() {
            return InternalQueueCategory.RETRY;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Retry)) {
                return false;
            }
            Retry other = (Retry)o;
            return this.getRetryCount() == other.getRetryCount();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = Retry.class.hashCode();
            result = result * 59 + this.getRetryCount();
            return result;
        }

        public String toString() {
            return "Retry-" + this.retryCount;
        }

        @Generated
        public int getRetryCount() {
            return this.retryCount;
        }

        @JsonCreator
        @Generated
        public Retry(int retryCount) {
            this.retryCount = retryCount;
        }
    }
}

