/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.varadhi.entities.ConsumptionPolicy;
import com.flipkart.varadhi.entities.Endpoint;
import com.flipkart.varadhi.entities.LifecycleEntity;
import com.flipkart.varadhi.entities.LifecycleStatus;
import com.flipkart.varadhi.entities.RetryPolicy;
import com.flipkart.varadhi.entities.SubscriptionShards;
import java.util.Map;
import lombok.Generated;

public class VaradhiSubscription
extends LifecycleEntity {
    private final String project;
    private final String topic;
    private String description;
    private boolean grouped;
    private Endpoint endpoint;
    private RetryPolicy retryPolicy;
    private ConsumptionPolicy consumptionPolicy;
    private SubscriptionShards shards;
    private Map<String, String> properties;
    private static final String SHARDS_ERROR = "Shards cannot be null or empty";
    private static final String PROPERTIES_ERROR = "Properties cannot be null or empty";

    private VaradhiSubscription(String name, int version, String project, String topic, String description, boolean grouped, Endpoint endpoint, RetryPolicy retryPolicy, ConsumptionPolicy consumptionPolicy, SubscriptionShards shards, LifecycleStatus status, Map<String, String> properties) {
        super(name, version);
        this.project = VaradhiSubscription.validateNotNullOrEmpty(project, "Project");
        this.topic = VaradhiSubscription.validateNotNullOrEmpty(topic, "Topic");
        this.description = description;
        this.grouped = grouped;
        this.endpoint = endpoint;
        this.retryPolicy = retryPolicy;
        this.consumptionPolicy = consumptionPolicy;
        this.shards = VaradhiSubscription.validateShards(shards);
        this.status = status;
        this.properties = VaradhiSubscription.validateProperties(properties);
    }

    public static VaradhiSubscription of(String name, String project, String topic, String description, boolean grouped, Endpoint endpoint, RetryPolicy retryPolicy, ConsumptionPolicy consumptionPolicy, SubscriptionShards shards, Map<String, String> properties, LifecycleStatus.ActorCode actorCode) {
        return new VaradhiSubscription(name, 0, project, topic, description, grouped, endpoint, retryPolicy, consumptionPolicy, shards, new LifecycleStatus(LifecycleStatus.State.CREATING, actorCode), properties);
    }

    @JsonIgnore
    public int getIntProperty(String property) {
        String value = this.properties.get(property);
        if (value == null) {
            throw new IllegalArgumentException("Property not found: " + property);
        }
        return Integer.parseInt(value);
    }

    private static String validateNotNullOrEmpty(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be null or empty");
        }
        return value;
    }

    private static SubscriptionShards validateShards(SubscriptionShards shards) {
        if (shards == null || shards.getShardCount() <= 0) {
            throw new IllegalArgumentException(SHARDS_ERROR);
        }
        return shards;
    }

    private static Map<String, String> validateProperties(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException(PROPERTIES_ERROR);
        }
        return properties;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isGrouped() {
        return this.grouped;
    }

    @Generated
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Generated
    public ConsumptionPolicy getConsumptionPolicy() {
        return this.consumptionPolicy;
    }

    @Generated
    public SubscriptionShards getShards() {
        return this.shards;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    @Generated
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Generated
    public void setConsumptionPolicy(ConsumptionPolicy consumptionPolicy) {
        this.consumptionPolicy = consumptionPolicy;
    }

    @Generated
    public void setShards(SubscriptionShards shards) {
        this.shards = shards;
    }

    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaradhiSubscription)) {
            return false;
        }
        VaradhiSubscription other = (VaradhiSubscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isGrouped() != other.isGrouped()) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Endpoint this$endpoint = this.getEndpoint();
        Endpoint other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        RetryPolicy this$retryPolicy = this.getRetryPolicy();
        RetryPolicy other$retryPolicy = other.getRetryPolicy();
        if (this$retryPolicy == null ? other$retryPolicy != null : !((Object)this$retryPolicy).equals(other$retryPolicy)) {
            return false;
        }
        ConsumptionPolicy this$consumptionPolicy = this.getConsumptionPolicy();
        ConsumptionPolicy other$consumptionPolicy = other.getConsumptionPolicy();
        if (this$consumptionPolicy == null ? other$consumptionPolicy != null : !((Object)this$consumptionPolicy).equals(other$consumptionPolicy)) {
            return false;
        }
        SubscriptionShards this$shards = this.getShards();
        SubscriptionShards other$shards = other.getShards();
        if (this$shards == null ? other$shards != null : !this$shards.equals(other$shards)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VaradhiSubscription;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isGrouped() ? 79 : 97);
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Endpoint $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        RetryPolicy $retryPolicy = this.getRetryPolicy();
        result = result * 59 + ($retryPolicy == null ? 43 : ((Object)$retryPolicy).hashCode());
        ConsumptionPolicy $consumptionPolicy = this.getConsumptionPolicy();
        result = result * 59 + ($consumptionPolicy == null ? 43 : ((Object)$consumptionPolicy).hashCode());
        SubscriptionShards $shards = this.getShards();
        result = result * 59 + ($shards == null ? 43 : $shards.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

