/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.flipkart.varadhi.entities.CodeRange;
import com.flipkart.varadhi.entities.ConsumptionPolicy;
import com.flipkart.varadhi.entities.Endpoint;
import com.flipkart.varadhi.entities.LifecycleStatus;
import com.flipkart.varadhi.entities.RetryPolicy;
import com.flipkart.varadhi.entities.SubscriptionMultiShard;
import com.flipkart.varadhi.entities.SubscriptionShards;
import com.flipkart.varadhi.entities.SubscriptionUnitShard;
import com.flipkart.varadhi.entities.TopicCapacityPolicy;
import com.flipkart.varadhi.entities.VaradhiSubscription;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SubscriptionUtils {
    private static final int DEFAULT_NUM_SHARDS = 2;
    private static final int DEFAULT_QPS = 1000;
    private static final int DEFAULT_THROUGHPUT_KBPS = 20000;
    private static final int DEFAULT_READ_FANOUT = 2;

    public static Endpoint getHttpEndpoint() {
        return new Endpoint.HttpEndpoint(URI.create("http://localhost:8080"), "GET", "", 500L, 500L, false);
    }

    public static RetryPolicy getRetryPolicy() {
        return new RetryPolicy(new CodeRange[]{new CodeRange(500, 502)}, RetryPolicy.BackoffType.LINEAR, 1, 100, 4, 3);
    }

    public static Map<String, String> getSubscriptionDefaultProperties() {
        return new HashMap<String, String>(Map.of("unsideline.api.message_count", "100", "unsideline.api.group_count", "20", "getmessages.api.messages_limit", "100"));
    }

    public static ConsumptionPolicy getConsumptionPolicy() {
        return new ConsumptionPolicy(10, 1, 1.0f, false, 1.0f, null);
    }

    public static SubscriptionShards getShards(int numShards, TopicCapacityPolicy shardCapacity) {
        HashMap<Integer, SubscriptionUnitShard> subShards = new HashMap<Integer, SubscriptionUnitShard>();
        for (int shardId = 0; shardId < numShards; ++shardId) {
            subShards.put(shardId, SubscriptionUtils.getShard(shardId, shardCapacity));
        }
        return new SubscriptionMultiShard(subShards);
    }

    public static SubscriptionUnitShard getShard(int shardId, TopicCapacityPolicy capacity) {
        return new SubscriptionUnitShard(shardId, capacity, null, null, null);
    }

    public static TopicCapacityPolicy getCapacity(int qps, int throughputKbps) {
        return SubscriptionUtils.getCapacity(qps, throughputKbps, 2);
    }

    public static TopicCapacityPolicy getCapacity(int qps, int throughputKbps, int readFanOut) {
        return new TopicCapacityPolicy(qps, throughputKbps, readFanOut);
    }

    public static List<SubscriptionUnitShard> shardsOf(VaradhiSubscription subscription) {
        ArrayList<SubscriptionUnitShard> shards = new ArrayList<SubscriptionUnitShard>();
        for (int shardId = 0; shardId < subscription.getShards().getShardCount(); ++shardId) {
            shards.add(subscription.getShards().getShard(shardId));
        }
        return shards;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int numShards = 2;
        private TopicCapacityPolicy subCapacity;
        private String description;
        private boolean isGrouped = false;
        private Endpoint endpoint;
        private RetryPolicy retryPolicy;
        private ConsumptionPolicy consumptionPolicy;
        private SubscriptionShards shards;
        private final Map<String, String> properties = SubscriptionUtils.getSubscriptionDefaultProperties();

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setGrouped(boolean isGrouped) {
            this.isGrouped = isGrouped;
            return this;
        }

        public Builder setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder setConsumptionPolicy(ConsumptionPolicy consumptionPolicy) {
            this.consumptionPolicy = consumptionPolicy;
            return this;
        }

        public Builder setShards(SubscriptionShards shards) {
            this.shards = shards;
            return this;
        }

        public Builder setCapacity(TopicCapacityPolicy capacity) {
            this.subCapacity = capacity;
            return this;
        }

        public Builder setNumShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        public Builder setProperty(String property, String value) {
            this.properties.put(property, value);
            return this;
        }

        public VaradhiSubscription build(String name, String subProject, String subscribedTopic) {
            if (this.subCapacity == null) {
                this.subCapacity = SubscriptionUtils.getCapacity(1000, 20000, 2);
            }
            if (this.shards == null) {
                double shardCapacityFactor = 1.0 / (double)this.numShards;
                TopicCapacityPolicy shardCapacity = this.subCapacity.from(shardCapacityFactor, 2);
                this.shards = SubscriptionUtils.getShards(this.numShards, shardCapacity);
            }
            return VaradhiSubscription.of((String)name, (String)subProject, (String)subscribedTopic, (String)Optional.ofNullable(this.description).orElse("Test Subscription " + name + " Subscribed to " + subscribedTopic), (boolean)this.isGrouped, (Endpoint)Optional.ofNullable(this.endpoint).orElse(SubscriptionUtils.getHttpEndpoint()), (RetryPolicy)Optional.ofNullable(this.retryPolicy).orElse(SubscriptionUtils.getRetryPolicy()), (ConsumptionPolicy)Optional.ofNullable(this.consumptionPolicy).orElse(SubscriptionUtils.getConsumptionPolicy()), (SubscriptionShards)this.shards, this.properties, (LifecycleStatus.ActorCode)LifecycleStatus.ActorCode.SYSTEM_ACTION);
        }
    }
}

