/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="protocol")
@JsonSubTypes(value={@JsonSubTypes.Type(value=HttpEndpoint.class, name="HTTP1_1"), @JsonSubTypes.Type(value=HttpEndpoint.class, name="HTTP2")})
public abstract sealed class Endpoint {
    @JsonIgnore
    public abstract Protocol getProtocol();

    public static final class HttpEndpoint
    extends Endpoint {
        private final URI uri;
        private final String method;
        private final String contentType;
        private final long connectTimeoutMs;
        private final long requestTimeoutMs;
        private final boolean http2Supported;

        @Override
        public Protocol getProtocol() {
            return this.http2Supported ? Protocol.HTTP2 : Protocol.HTTP1_1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpEndpoint)) {
                return false;
            }
            HttpEndpoint other = (HttpEndpoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
                return false;
            }
            if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
                return false;
            }
            if (this.isHttp2Supported() != other.isHttp2Supported()) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpEndpoint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            long $connectTimeoutMs = this.getConnectTimeoutMs();
            result = result * 59 + (int)($connectTimeoutMs >>> 32 ^ $connectTimeoutMs);
            long $requestTimeoutMs = this.getRequestTimeoutMs();
            result = result * 59 + (int)($requestTimeoutMs >>> 32 ^ $requestTimeoutMs);
            result = result * 59 + (this.isHttp2Supported() ? 79 : 97);
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            return result;
        }

        @Generated
        public HttpEndpoint(URI uri, String method, String contentType, long connectTimeoutMs, long requestTimeoutMs, boolean http2Supported) {
            this.uri = uri;
            this.method = method;
            this.contentType = contentType;
            this.connectTimeoutMs = connectTimeoutMs;
            this.requestTimeoutMs = requestTimeoutMs;
            this.http2Supported = http2Supported;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Generated
        public long getConnectTimeoutMs() {
            return this.connectTimeoutMs;
        }

        @Generated
        public long getRequestTimeoutMs() {
            return this.requestTimeoutMs;
        }

        @Generated
        public boolean isHttp2Supported() {
            return this.http2Supported;
        }

        @Generated
        public String toString() {
            return "Endpoint.HttpEndpoint(uri=" + String.valueOf(this.getUri()) + ", method=" + this.getMethod() + ", contentType=" + this.getContentType() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", http2Supported=" + this.isHttp2Supported() + ")";
        }
    }

    public static enum Protocol {
        HTTP1_1,
        HTTP2;

    }
}

