/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.varadhi.entities.InternalQueueCategory;
import com.flipkart.varadhi.entities.InternalQueueType;
import com.flipkart.varadhi.entities.StorageSubscription;
import com.flipkart.varadhi.entities.StorageTopic;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;

public class InternalCompositeSubscription {
    private final InternalQueueType queueType;
    private StorageSubscription<StorageTopic>[] storageSubscriptions;
    private int produceIndex;
    private int consumeIndex;

    public static InternalCompositeSubscription of(StorageSubscription<StorageTopic> storageSubscription, InternalQueueType queueType) {
        return new InternalCompositeSubscription(queueType, new StorageSubscription[]{storageSubscription}, 0, 0);
    }

    @JsonIgnore
    public StorageTopic getTopicForProduce() {
        if (this.queueType.getCategory() == InternalQueueCategory.MAIN) {
            throw new IllegalArgumentException("Main Subscription does not have a topic to produce");
        }
        return this.storageSubscriptions[this.produceIndex].getStorageTopic();
    }

    @JsonIgnore
    public StorageSubscription<StorageTopic> getSubscriptionForConsume() {
        return this.storageSubscriptions[this.consumeIndex];
    }

    @JsonIgnore
    public List<StorageSubscription<StorageTopic>> getActiveSubscriptions() {
        return Lists.newArrayList((Object[])this.storageSubscriptions);
    }

    @Generated
    public InternalQueueType getQueueType() {
        return this.queueType;
    }

    @Generated
    public StorageSubscription<StorageTopic>[] getStorageSubscriptions() {
        return this.storageSubscriptions;
    }

    @Generated
    public int getProduceIndex() {
        return this.produceIndex;
    }

    @Generated
    public int getConsumeIndex() {
        return this.consumeIndex;
    }

    @Generated
    public InternalCompositeSubscription(InternalQueueType queueType, StorageSubscription<StorageTopic>[] storageSubscriptions, int produceIndex, int consumeIndex) {
        this.queueType = queueType;
        this.storageSubscriptions = storageSubscriptions;
        this.produceIndex = produceIndex;
        this.consumeIndex = consumeIndex;
    }
}

