/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Generated;

public class LifecycleStatus {
    private State state;
    private String message;
    private ActorCode actorCode;

    public LifecycleStatus(State state, ActorCode actorCode) {
        this(state, state.getDefaultMessage(), actorCode);
    }

    public void update(State state, String message, ActorCode actorCode) {
        if (this.state == state) {
            throw new IllegalArgumentException("Resource is already in " + String.valueOf((Object)state) + " state");
        }
        this.state = state;
        this.message = message != null && !message.isEmpty() ? message : state.getDefaultMessage();
        this.actorCode = actorCode;
    }

    public void update(State state) {
        this.update(state, state.getDefaultMessage(), this.actorCode);
    }

    public void update(State state, String message) {
        this.update(state, message, this.actorCode);
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public ActorCode getActorCode() {
        return this.actorCode;
    }

    @JsonCreator
    @Generated
    public LifecycleStatus(State state, String message, ActorCode actorCode) {
        this.state = state;
        this.message = message;
        this.actorCode = actorCode;
    }

    public static enum State {
        CREATING("Creation in progress."),
        CREATED("Successfully created."),
        CREATE_FAILED("Creation failed."),
        DELETING("Deletion in progress."),
        DELETE_FAILED("Deletion failed."),
        INACTIVE("Currently inactive.");

        private final String defaultMessage;

        public boolean isRetriable() {
            return this == CREATE_FAILED || this == DELETE_FAILED;
        }

        public boolean isTerminal() {
            return this == CREATED || this == INACTIVE;
        }

        @Generated
        public String getDefaultMessage() {
            return this.defaultMessage;
        }

        @Generated
        private State(String defaultMessage) {
            this.defaultMessage = defaultMessage;
        }
    }

    public static enum ActorCode {
        USER_ACTION,
        ADMIN_ACTION,
        SYSTEM_ACTION;


        public boolean isUserAllowed() {
            return this == USER_ACTION;
        }
    }
}

