/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.flipkart.varadhi.entities.ValidateResource;
import com.flipkart.varadhi.entities.VersionedEntity;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class ResourceValidator
implements ConstraintValidator<ValidateResource, VersionedEntity> {
    String regExp;
    int minLength;
    int maxLength;
    boolean allowNullOrBlank;

    public void initialize(ValidateResource constraintAnnotation) {
        this.regExp = constraintAnnotation.regexp();
        this.maxLength = constraintAnnotation.max();
        this.minLength = constraintAnnotation.min();
        this.allowNullOrBlank = constraintAnnotation.allowNullOrBlank();
    }

    public boolean isValid(VersionedEntity value, ConstraintValidatorContext context) {
        if (null == value.getName() || value.getName().isBlank()) {
            return this.allowNullOrBlank;
        }
        int nameLength = value.getName().length();
        if (-1 != this.minLength && nameLength < this.minLength) {
            return false;
        }
        if (-1 != this.maxLength && nameLength > this.maxLength) {
            return false;
        }
        if (!this.regExp.isBlank()) {
            return Pattern.matches(this.regExp, value.getName());
        }
        return true;
    }
}

