/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import lombok.Generated;

public class TopicCapacityPolicy
implements Comparable<TopicCapacityPolicy> {
    private int qps;
    private int throughputKBps;
    private int readFanOut;

    public TopicCapacityPolicy(int qps, int throughputKBps, int readFanOut) {
        this.qps = qps;
        this.throughputKBps = throughputKBps;
        this.readFanOut = readFanOut;
    }

    public TopicCapacityPolicy from(double factor, int readFanOut) {
        int qps = (int)Math.ceil((double)this.qps * factor);
        int kbps = (int)Math.ceil((double)this.throughputKBps * factor);
        return new TopicCapacityPolicy(qps, kbps, readFanOut);
    }

    @Override
    public int compareTo(TopicCapacityPolicy o) {
        return this.throughputKBps - o.throughputKBps;
    }

    public String toString() {
        return String.format("%dKBps, %d Qps, %d readFanOut", this.throughputKBps, this.qps, this.readFanOut);
    }

    @Generated
    public int getQps() {
        return this.qps;
    }

    @Generated
    public int getThroughputKBps() {
        return this.throughputKBps;
    }

    @Generated
    public int getReadFanOut() {
        return this.readFanOut;
    }

    @Generated
    public void setQps(int qps) {
        this.qps = qps;
    }

    @Generated
    public void setThroughputKBps(int throughputKBps) {
        this.throughputKBps = throughputKBps;
    }

    @Generated
    public void setReadFanOut(int readFanOut) {
        this.readFanOut = readFanOut;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicCapacityPolicy)) {
            return false;
        }
        TopicCapacityPolicy other = (TopicCapacityPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQps() != other.getQps()) {
            return false;
        }
        if (this.getThroughputKBps() != other.getThroughputKBps()) {
            return false;
        }
        return this.getReadFanOut() == other.getReadFanOut();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopicCapacityPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQps();
        result = result * 59 + this.getThroughputKBps();
        result = result * 59 + this.getReadFanOut();
        return result;
    }

    @Generated
    public TopicCapacityPolicy() {
    }
}

