/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.flipkart.varadhi.entities.MetaStoreEntity;
import java.util.Objects;
import lombok.Generated;

public final class Assignment
extends MetaStoreEntity {
    private static final String NAME_SEPARATOR = ":";
    private final String subscriptionId;
    private final int shardId;
    private final String consumerId;

    @JsonCreator
    Assignment(String name, String subscriptionId, int shardId, String consumerId, int version) {
        super(name, version);
        this.subscriptionId = subscriptionId;
        this.shardId = shardId;
        this.consumerId = consumerId;
    }

    public Assignment(String subscriptionId, int shardId, String consumerId) {
        super(Assignment.getShardName(subscriptionId, shardId), 0);
        this.subscriptionId = subscriptionId;
        this.shardId = shardId;
        this.consumerId = consumerId;
    }

    private static String getShardName(String subscriptionId, int shardId) {
        return String.format("%s%s%d", subscriptionId, NAME_SEPARATOR, shardId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Assignment that = (Assignment)o;
        return this.shardId == that.shardId && Objects.equals(this.subscriptionId, that.subscriptionId) && Objects.equals(this.consumerId, that.consumerId);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumerId == null ? 0 : this.consumerId.hashCode());
        result = 31 * result + this.shardId;
        result = 31 * result + (this.subscriptionId == null ? 0 : this.subscriptionId.hashCode());
        return result;
    }

    public String toString() {
        return String.format("{ConsumerId:%s Subscription:%s Shard:%d}", this.consumerId, this.subscriptionId, this.shardId);
    }

    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public int getShardId() {
        return this.shardId;
    }

    @Generated
    public String getConsumerId() {
        return this.consumerId;
    }
}

