/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.varadhi.entities.LifecycleStatus;
import com.flipkart.varadhi.entities.MetaStoreEntity;
import lombok.Generated;

public abstract class LifecycleEntity
extends MetaStoreEntity {
    protected LifecycleStatus status;

    protected LifecycleEntity(String name, int version) {
        super(name, version);
    }

    public void markCreated() {
        this.status.update(LifecycleStatus.State.CREATED);
    }

    public void markCreateFailed(String message) {
        this.status.update(LifecycleStatus.State.CREATE_FAILED, message);
    }

    public void markDeleting(LifecycleStatus.ActorCode actorCode, String message) {
        this.status.update(LifecycleStatus.State.DELETING, message, actorCode);
    }

    public void markDeleteFailed(String message) {
        this.status.update(LifecycleStatus.State.DELETE_FAILED, message);
    }

    public void markInactive(LifecycleStatus.ActorCode actorCode, String message) {
        this.status.update(LifecycleStatus.State.INACTIVE, message, actorCode);
    }

    public void restore(LifecycleStatus.ActorCode actorCode, String message) {
        this.status.update(LifecycleStatus.State.CREATED, message, actorCode);
    }

    @JsonIgnore
    public boolean isActive() {
        return this.status.getState() == LifecycleStatus.State.CREATED;
    }

    @JsonIgnore
    public boolean isInactive() {
        return this.status.getState() == LifecycleStatus.State.INACTIVE;
    }

    @JsonIgnore
    public boolean isRetriable() {
        return this.status.getState().isRetriable();
    }

    @Generated
    public LifecycleStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LifecycleEntity)) {
            return false;
        }
        LifecycleEntity other = (LifecycleEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LifecycleStatus this$status = this.getStatus();
        LifecycleStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LifecycleEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LifecycleStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }
}

