/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class UnsidelineRequest {
    public static final long UNSPECIFIED_TS = 0L;
    private long latestFailedAt;
    private List<String> groupIds;
    private List<String> messageIds;

    private UnsidelineRequest(long failedAt, List<String> groupIds, List<String> messageIds) {
        this.latestFailedAt = failedAt;
        this.groupIds = groupIds;
        this.messageIds = messageIds;
    }

    public static UnsidelineRequest ofFailedAt(long latestFailedAt) {
        return new UnsidelineRequest(latestFailedAt, new ArrayList<String>(), new ArrayList<String>());
    }

    public static UnsidelineRequest ofGroupIds(List<String> groupIds) {
        return new UnsidelineRequest(0L, groupIds, new ArrayList<String>());
    }

    public static UnsidelineRequest ofMessageIds(List<String> messageIds) {
        return new UnsidelineRequest(0L, new ArrayList<String>(), messageIds);
    }

    public void validate(int maxGroupIds, int maxMessageIds) {
        if (this.latestFailedAt == 0L && this.messageIds.isEmpty() && this.groupIds.isEmpty()) {
            throw new IllegalArgumentException("At least one unsideline criteria needs to be specified.");
        }
        if (this.latestFailedAt != 0L && (!this.groupIds.isEmpty() || !this.messageIds.isEmpty()) || this.latestFailedAt == 0L && !this.groupIds.isEmpty() && !this.messageIds.isEmpty()) {
            throw new IllegalArgumentException("Only one of the unsideline criteria should be specified.");
        }
        if (this.groupIds.size() > maxGroupIds) {
            throw new IllegalArgumentException("Number of groupIds in one API call cannot be more than " + maxGroupIds + ".");
        }
        if (this.messageIds.size() > maxMessageIds) {
            throw new IllegalArgumentException("Number of messageIds in one API call cannot be more than " + maxMessageIds + ".");
        }
    }

    @Generated
    public long getLatestFailedAt() {
        return this.latestFailedAt;
    }

    @Generated
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Generated
    public List<String> getMessageIds() {
        return this.messageIds;
    }
}

