/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.varadhi.entities.ConsumptionPolicy;
import com.flipkart.varadhi.entities.Endpoint;
import com.flipkart.varadhi.entities.MetaStoreEntity;
import com.flipkart.varadhi.entities.RetryPolicy;
import com.flipkart.varadhi.entities.SubscriptionUnitShard;
import com.flipkart.varadhi.entities.UnsidelineRequest;
import com.flipkart.varadhi.entities.VaradhiSubscription;
import com.flipkart.varadhi.entities.cluster.Operation;
import java.util.UUID;
import lombok.Generated;

public class ShardOperation
extends MetaStoreEntity
implements Operation {
    private final OpData opData;
    private long startTime;
    private long endTime;
    private Operation.State state;
    private String errorMsg;

    @JsonCreator
    ShardOperation(String operationId, int version, long startTime, long endTime, Operation.State state, String errorMsg, OpData opData) {
        super(operationId, version);
        this.state = state;
        this.errorMsg = errorMsg;
        this.startTime = startTime;
        this.endTime = endTime;
        this.opData = opData;
    }

    ShardOperation(OpData opData) {
        super(opData.getOperationId(), 0);
        this.state = Operation.State.IN_PROGRESS;
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.opData = opData;
    }

    public static ShardOperation startOp(String subOpId, SubscriptionUnitShard shard, VaradhiSubscription subscription) {
        return new ShardOperation(new StartData(subOpId, shard, subscription));
    }

    public static ShardOperation stopOp(String subOpId, SubscriptionUnitShard shard, VaradhiSubscription subscription) {
        return new ShardOperation(new StopData(subOpId, shard, subscription));
    }

    public static ShardOperation unsidelineOp(String subOpId, SubscriptionUnitShard shard, VaradhiSubscription subscription, UnsidelineRequest request) {
        return new ShardOperation(new UnsidelineData(subOpId, shard, subscription, request));
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.opData.getOperationId();
    }

    @Override
    @JsonIgnore
    public boolean isDone() {
        return this.state == Operation.State.ERRORED || this.state == Operation.State.COMPLETED;
    }

    @Override
    public void markFail(String reason) {
        this.state = Operation.State.ERRORED;
        this.errorMsg = reason;
        this.endTime = System.currentTimeMillis();
    }

    @Override
    public void markCompleted() {
        this.state = Operation.State.COMPLETED;
        this.endTime = System.currentTimeMillis();
    }

    @Override
    public boolean hasFailed() {
        return this.state == Operation.State.ERRORED;
    }

    public void reset() {
        this.state = Operation.State.IN_PROGRESS;
        this.errorMsg = null;
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    public void update(Operation.State opState, String OpError) {
        this.state = opState;
        this.errorMsg = OpError;
        if (this.isDone()) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public String toString() {
        return String.format("{data=%s, state=%s, startTime=%d, endTime=%d}", new Object[]{this.opData, this.state, this.startTime, this.endTime});
    }

    @Generated
    public OpData getOpData() {
        return this.opData;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    @Generated
    public Operation.State getState() {
        return this.state;
    }

    @Override
    @Generated
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardOperation)) {
            return false;
        }
        ShardOperation other = (ShardOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        OpData this$opData = this.getOpData();
        OpData other$opData = other.getOpData();
        if (this$opData == null ? other$opData != null : !this$opData.equals(other$opData)) {
            return false;
        }
        Operation.State this$state = this.getState();
        Operation.State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShardOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        OpData $opData = this.getOpData();
        result = result * 59 + ($opData == null ? 43 : $opData.hashCode());
        Operation.State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        return result;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@opDataType")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=StartData.class, name="startShardData"), @JsonSubTypes.Type(value=StopData.class, name="stopShardData"), @JsonSubTypes.Type(value=UnsidelineData.class, name="unsidelineShardData")})
    public static class OpData {
        private String operationId;
        private String parentOpId;
        private int shardId;
        private String subscriptionId;
        private String project;

        public String toString() {
            return String.format("ParentOpId=%s Id='%s', subscriptionId='%s', shardId=%d", this.parentOpId, this.operationId, this.subscriptionId, this.shardId);
        }

        @Generated
        public String getOperationId() {
            return this.operationId;
        }

        @Generated
        public String getParentOpId() {
            return this.parentOpId;
        }

        @Generated
        public int getShardId() {
            return this.shardId;
        }

        @Generated
        public String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Generated
        public void setParentOpId(String parentOpId) {
            this.parentOpId = parentOpId;
        }

        @Generated
        public void setShardId(int shardId) {
            this.shardId = shardId;
        }

        @Generated
        public void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Generated
        public void setProject(String project) {
            this.project = project;
        }

        @Generated
        public OpData(String operationId, String parentOpId, int shardId, String subscriptionId, String project) {
            this.operationId = operationId;
            this.parentOpId = parentOpId;
            this.shardId = shardId;
            this.subscriptionId = subscriptionId;
            this.project = project;
        }

        @Generated
        public OpData() {
        }
    }

    public static class StartData
    extends OpData {
        private boolean grouped;
        private Endpoint endpoint;
        private ConsumptionPolicy consumptionPolicy;
        private RetryPolicy retryPolicy;
        private SubscriptionUnitShard shard;

        StartData(String subOpId, SubscriptionUnitShard shard, VaradhiSubscription subscription) {
            super(UUID.randomUUID().toString(), subOpId, shard.getShardId(), subscription.getName(), subscription.getProject());
            this.grouped = subscription.isGrouped();
            this.endpoint = subscription.getEndpoint();
            this.consumptionPolicy = subscription.getConsumptionPolicy();
            this.retryPolicy = subscription.getRetryPolicy();
            this.shard = shard;
        }

        @Override
        public String toString() {
            return String.format("Start.OpData{%s}", super.toString());
        }

        @Generated
        public boolean isGrouped() {
            return this.grouped;
        }

        @Generated
        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public ConsumptionPolicy getConsumptionPolicy() {
            return this.consumptionPolicy;
        }

        @Generated
        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        @Generated
        public SubscriptionUnitShard getShard() {
            return this.shard;
        }

        @Generated
        public StartData() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartData)) {
                return false;
            }
            StartData other = (StartData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isGrouped() != other.isGrouped()) {
                return false;
            }
            Endpoint this$endpoint = this.getEndpoint();
            Endpoint other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            ConsumptionPolicy this$consumptionPolicy = this.getConsumptionPolicy();
            ConsumptionPolicy other$consumptionPolicy = other.getConsumptionPolicy();
            if (this$consumptionPolicy == null ? other$consumptionPolicy != null : !((Object)this$consumptionPolicy).equals(other$consumptionPolicy)) {
                return false;
            }
            RetryPolicy this$retryPolicy = this.getRetryPolicy();
            RetryPolicy other$retryPolicy = other.getRetryPolicy();
            if (this$retryPolicy == null ? other$retryPolicy != null : !((Object)this$retryPolicy).equals(other$retryPolicy)) {
                return false;
            }
            SubscriptionUnitShard this$shard = this.getShard();
            SubscriptionUnitShard other$shard = other.getShard();
            return !(this$shard == null ? other$shard != null : !this$shard.equals(other$shard));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StartData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isGrouped() ? 79 : 97);
            Endpoint $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            ConsumptionPolicy $consumptionPolicy = this.getConsumptionPolicy();
            result = result * 59 + ($consumptionPolicy == null ? 43 : ((Object)$consumptionPolicy).hashCode());
            RetryPolicy $retryPolicy = this.getRetryPolicy();
            result = result * 59 + ($retryPolicy == null ? 43 : ((Object)$retryPolicy).hashCode());
            SubscriptionUnitShard $shard = this.getShard();
            result = result * 59 + ($shard == null ? 43 : $shard.hashCode());
            return result;
        }
    }

    public static class StopData
    extends OpData {
        StopData(String subOpId, SubscriptionUnitShard shard, VaradhiSubscription subscription) {
            super(UUID.randomUUID().toString(), subOpId, shard.getShardId(), subscription.getName(), subscription.getProject());
        }

        @Override
        public String toString() {
            return String.format("Stop.OpData{%s}", super.toString());
        }

        @Generated
        public StopData() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StopData)) {
                return false;
            }
            StopData other = (StopData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StopData;
        }

        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class UnsidelineData
    extends OpData {
        UnsidelineRequest request;

        UnsidelineData(String subOpId, SubscriptionUnitShard shard, VaradhiSubscription subscription, UnsidelineRequest request) {
            super(UUID.randomUUID().toString(), subOpId, shard.getShardId(), subscription.getName(), subscription.getProject());
            this.request = request;
        }

        @Override
        public String toString() {
            return String.format("Unsideline.OpData{%s}", super.toString());
        }

        @Generated
        public UnsidelineRequest getRequest() {
            return this.request;
        }

        @Generated
        public UnsidelineData() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnsidelineData)) {
                return false;
            }
            UnsidelineData other = (UnsidelineData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnsidelineRequest this$request = this.getRequest();
            UnsidelineRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !this$request.equals(other$request));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnsidelineData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            UnsidelineRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            return result;
        }
    }
}

