/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.varadhi.entities.MetaStoreEntity;
import com.flipkart.varadhi.entities.UnsidelineRequest;
import com.flipkart.varadhi.entities.cluster.Assignment;
import com.flipkart.varadhi.entities.cluster.Operation;
import com.flipkart.varadhi.entities.cluster.OrderedOperation;
import com.flipkart.varadhi.entities.cluster.ShardOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class SubscriptionOperation
extends MetaStoreEntity
implements OrderedOperation {
    private final String requestedBy;
    private final long startTime;
    private final OpData data;
    private final int retryAttempt;
    private final List<OpResult> results;
    private long endTime;

    @JsonCreator
    SubscriptionOperation(String operationId, int version, String requestedBy, long startTime, long endTime, OpData data, int retryAttempt, List<OpResult> results) {
        super(operationId, version);
        this.requestedBy = requestedBy;
        this.startTime = startTime;
        this.endTime = endTime;
        this.data = data;
        this.retryAttempt = retryAttempt;
        this.results = results;
    }

    SubscriptionOperation(OpData data, String requestedBy) {
        super(data.operationId, 0);
        this.requestedBy = requestedBy;
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.retryAttempt = 0;
        this.data = data;
        this.results = new ArrayList<OpResult>();
        this.results.add(OpResult.of(0));
    }

    public static SubscriptionOperation startOp(String subscriptionId, String requestedBy) {
        return new SubscriptionOperation(new StartData(subscriptionId), requestedBy);
    }

    public static SubscriptionOperation stopOp(String subscriptionId, String requestedBy) {
        return new SubscriptionOperation(new StopData(subscriptionId), requestedBy);
    }

    public static SubscriptionOperation reAssignShardOp(Assignment assignment, String requestedBy) {
        return new SubscriptionOperation(new ReassignShardData(assignment), requestedBy);
    }

    public static SubscriptionOperation unsidelineOp(String subscriptionId, UnsidelineRequest request, String requestedBy) {
        return new SubscriptionOperation(new UnsidelineData(subscriptionId, request), requestedBy);
    }

    @Override
    public SubscriptionOperation nextRetry() {
        int attempt = this.retryAttempt + 1;
        this.results.add(0, OpResult.of(attempt));
        return new SubscriptionOperation(this.getId(), this.getVersion(), this.requestedBy, this.startTime, this.endTime, this.data, attempt, this.results);
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.data.getOperationId();
    }

    @Override
    @JsonIgnore
    public Operation.State getState() {
        return this.results.get((int)0).state;
    }

    @Override
    @JsonIgnore
    public String getErrorMsg() {
        return this.results.get((int)0).errorMsg;
    }

    @Override
    @JsonIgnore
    public String getOrderingKey() {
        return "Sub_" + this.data.getSubscriptionId();
    }

    @Override
    @JsonIgnore
    public boolean isDone() {
        return this.results.get(0).isDone();
    }

    @Override
    public void markFail(String reason) {
        this.results.get(0).markFail(reason);
        this.endTime = System.currentTimeMillis();
    }

    @Override
    public void markCompleted() {
        this.results.get(0).markCompleted();
        this.endTime = System.currentTimeMillis();
    }

    @Override
    public boolean hasFailed() {
        return this.results.get(0).hasFailed();
    }

    @JsonIgnore
    public boolean isInRetry() {
        return this.retryAttempt > 0;
    }

    public void update(Operation.State opState, String opError) {
        this.results.get(0).update(opState, opError);
        if (this.isDone()) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public void update(List<ShardOperation> shardOps) {
        StringBuilder sb = new StringBuilder();
        int completedCount = 0;
        for (ShardOperation shardOp : shardOps) {
            ShardOperation.OpData opData = shardOp.getOpData();
            if (shardOp.hasFailed()) {
                if (!sb.isEmpty()) {
                    sb.append(", ");
                }
                sb.append(String.format("Shard:%d failed:%s", opData.getShardId(), shardOp.getErrorMsg()));
            }
            if (!shardOp.isDone()) continue;
            ++completedCount;
        }
        if (completedCount == shardOps.size()) {
            if (sb.isEmpty()) {
                this.markCompleted();
            } else {
                this.markFail(sb.toString());
            }
        }
    }

    public String toString() {
        return String.format("{data=%s retryAttempt=%d, requestedBy=%s, startTime=%d, endTime=%d}", this.data, this.retryAttempt, this.requestedBy, this.startTime, this.endTime);
    }

    @Generated
    public String getRequestedBy() {
        return this.requestedBy;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public OpData getData() {
        return this.data;
    }

    @Override
    @Generated
    public int getRetryAttempt() {
        return this.retryAttempt;
    }

    @Generated
    public List<OpResult> getResults() {
        return this.results;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionOperation)) {
            return false;
        }
        SubscriptionOperation other = (SubscriptionOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getRetryAttempt() != other.getRetryAttempt()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        String this$requestedBy = this.getRequestedBy();
        String other$requestedBy = other.getRequestedBy();
        if (this$requestedBy == null ? other$requestedBy != null : !this$requestedBy.equals(other$requestedBy)) {
            return false;
        }
        OpData this$data = this.getData();
        OpData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        List<OpResult> this$results = this.getResults();
        List<OpResult> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        result = result * 59 + this.getRetryAttempt();
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        String $requestedBy = this.getRequestedBy();
        result = result * 59 + ($requestedBy == null ? 43 : $requestedBy.hashCode());
        OpData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        List<OpResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@opDataType")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=StartData.class, name="startSubData"), @JsonSubTypes.Type(value=StopData.class, name="stopSubData"), @JsonSubTypes.Type(value=ReassignShardData.class, name="reassignShardData"), @JsonSubTypes.Type(value=UnsidelineData.class, name="unsidelineData")})
    public static class OpData {
        private String operationId;
        private String subscriptionId;

        public String toString() {
            return String.format("Id=%s, subscriptionId=%s", this.operationId, this.subscriptionId);
        }

        @Generated
        public String getOperationId() {
            return this.operationId;
        }

        @Generated
        public String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Generated
        public void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Generated
        public void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpData)) {
                return false;
            }
            OpData other = (OpData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$operationId = this.getOperationId();
            String other$operationId = other.getOperationId();
            if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
                return false;
            }
            String this$subscriptionId = this.getSubscriptionId();
            String other$subscriptionId = other.getSubscriptionId();
            return !(this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OpData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $operationId = this.getOperationId();
            result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
            String $subscriptionId = this.getSubscriptionId();
            result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
            return result;
        }

        @Generated
        public OpData(String operationId, String subscriptionId) {
            this.operationId = operationId;
            this.subscriptionId = subscriptionId;
        }

        @Generated
        public OpData() {
        }
    }

    static class OpResult {
        private final long startTime;
        private final int retryAttempt;
        private Operation.State state;
        private String errorMsg;
        private long endTime;

        OpResult(long startTime, int retryAttempt, Operation.State state, String errorMsg, long endTime) {
            this.startTime = startTime;
            this.retryAttempt = retryAttempt;
            this.state = state;
            this.errorMsg = errorMsg;
            this.endTime = endTime;
        }

        static OpResult of(int retryCount) {
            return new OpResult(System.currentTimeMillis(), retryCount, Operation.State.IN_PROGRESS, null, 0L);
        }

        @JsonIgnore
        public boolean isDone() {
            return this.state == Operation.State.COMPLETED || this.state == Operation.State.ERRORED;
        }

        public void markFail(String reason) {
            this.state = Operation.State.ERRORED;
            this.errorMsg = reason;
            this.endTime = System.currentTimeMillis();
        }

        public void markCompleted() {
            this.state = Operation.State.COMPLETED;
            this.endTime = System.currentTimeMillis();
        }

        public boolean hasFailed() {
            return this.state == Operation.State.ERRORED;
        }

        public void update(Operation.State opState, String opError) {
            this.state = opState;
            this.errorMsg = opError;
            if (this.isDone()) {
                this.endTime = System.currentTimeMillis();
            }
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public int getRetryAttempt() {
            return this.retryAttempt;
        }

        @Generated
        public Operation.State getState() {
            return this.state;
        }

        @Generated
        public String getErrorMsg() {
            return this.errorMsg;
        }

        @Generated
        public long getEndTime() {
            return this.endTime;
        }
    }

    public static class StartData
    extends OpData {
        StartData(String subscriptionId) {
            super(UUID.randomUUID().toString(), subscriptionId);
        }

        @Override
        public String toString() {
            return String.format("Start.OpData{%s}", super.toString());
        }

        @Generated
        public StartData() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartData)) {
                return false;
            }
            StartData other = (StartData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StartData;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class StopData
    extends OpData {
        StopData(String subscriptionId) {
            super(UUID.randomUUID().toString(), subscriptionId);
        }

        @Override
        public String toString() {
            return String.format("Stop.OpData{%s}", super.toString());
        }

        @Generated
        public StopData() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StopData)) {
                return false;
            }
            StopData other = (StopData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StopData;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class ReassignShardData
    extends OpData {
        private Assignment assignment;

        ReassignShardData(Assignment assignment) {
            super(UUID.randomUUID().toString(), assignment.getSubscriptionId());
            this.assignment = assignment;
        }

        @Override
        public String toString() {
            return String.format("ReassignShard.OpData{%s %s}", super.toString(), this.assignment);
        }

        @Generated
        public Assignment getAssignment() {
            return this.assignment;
        }

        @Generated
        public void setAssignment(Assignment assignment) {
            this.assignment = assignment;
        }

        @Generated
        public ReassignShardData() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReassignShardData)) {
                return false;
            }
            ReassignShardData other = (ReassignShardData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Assignment this$assignment = this.getAssignment();
            Assignment other$assignment = other.getAssignment();
            return !(this$assignment == null ? other$assignment != null : !((Object)this$assignment).equals(other$assignment));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReassignShardData;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Assignment $assignment = this.getAssignment();
            result = result * 59 + ($assignment == null ? 43 : ((Object)$assignment).hashCode());
            return result;
        }
    }

    public static class UnsidelineData
    extends OpData {
        private UnsidelineRequest request;

        UnsidelineData(String subscriptionId, UnsidelineRequest request) {
            super(UUID.randomUUID().toString(), subscriptionId);
            this.request = request;
        }

        @Override
        public String toString() {
            return String.format("Unsideline.OpData{%s}", super.toString());
        }

        @Generated
        public UnsidelineRequest getRequest() {
            return this.request;
        }

        @Generated
        public void setRequest(UnsidelineRequest request) {
            this.request = request;
        }

        @Generated
        public UnsidelineData() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnsidelineData)) {
                return false;
            }
            UnsidelineData other = (UnsidelineData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnsidelineRequest this$request = this.getRequest();
            UnsidelineRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !this$request.equals(other$request));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnsidelineData;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            UnsidelineRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            return result;
        }
    }
}

