/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.cluster;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.varadhi.entities.cluster.AssignmentState;
import com.flipkart.varadhi.entities.cluster.ConsumerState;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class SubscriptionState {
    private final AssignmentState assignmentState;
    @Nullable
    private final ConsumerState consumerState;

    public static SubscriptionState mergeShardStates(List<SubscriptionState> states) {
        int totalShards = states.size();
        long partial = states.stream().filter(state -> state.assignmentState == AssignmentState.PARTIALLY_ASSIGNED).count();
        if (partial > 0L) {
            throw new IllegalStateException("Invalid state. A single shard cannot be in partial state");
        }
        long assigned = states.stream().filter(state -> state.assignmentState == AssignmentState.ASSIGNED).count();
        long unassigned = states.stream().filter(state -> state.assignmentState == AssignmentState.NOT_ASSIGNED).count();
        if (assigned > 0L && unassigned > 0L) {
            return new SubscriptionState(AssignmentState.PARTIALLY_ASSIGNED, null);
        }
        if (unassigned == (long)totalShards) {
            return new SubscriptionState(AssignmentState.NOT_ASSIGNED, null);
        }
        if (assigned == (long)totalShards) {
            long unknownConsumerState = states.stream().filter(s -> s.consumerState == null).count();
            if (unknownConsumerState > 0L) {
                return new SubscriptionState(AssignmentState.ASSIGNED, null);
            }
            Optional<ConsumerState> erroredState = states.stream().map(state -> state.consumerState).filter(state -> state == ConsumerState.ERRORED).findAny();
            if (erroredState.isPresent()) {
                return new SubscriptionState(AssignmentState.ASSIGNED, ConsumerState.ERRORED);
            }
            Optional<ConsumerState> pausedState = states.stream().map(state -> state.consumerState).filter(state -> state == ConsumerState.PAUSED).findAny();
            if (pausedState.isPresent()) {
                return new SubscriptionState(AssignmentState.ASSIGNED, ConsumerState.PAUSED);
            }
            Optional<ConsumerState> throttledState = states.stream().map(state -> state.consumerState).filter(state -> state == ConsumerState.THROTTLED).findAny();
            if (throttledState.isPresent()) {
                return new SubscriptionState(AssignmentState.ASSIGNED, ConsumerState.THROTTLED);
            }
            return new SubscriptionState(AssignmentState.ASSIGNED, ConsumerState.CONSUMING);
        }
        throw new IllegalStateException("Invalid state");
    }

    public static SubscriptionState forRunning() {
        return new SubscriptionState(AssignmentState.ASSIGNED, ConsumerState.CONSUMING);
    }

    public static SubscriptionState forStopped() {
        return new SubscriptionState(AssignmentState.NOT_ASSIGNED, null);
    }

    public static SubscriptionState forPartiallyAssigned() {
        return new SubscriptionState(AssignmentState.PARTIALLY_ASSIGNED, null);
    }

    @JsonIgnore
    public boolean isRunningSuccessfully() {
        return this.assignmentState == AssignmentState.ASSIGNED && this.consumerState == ConsumerState.CONSUMING;
    }

    @JsonIgnore
    public boolean isStoppedSuccessfully() {
        return this.assignmentState == AssignmentState.NOT_ASSIGNED;
    }

    public String toString() {
        return "SubscriptionState(" + String.valueOf((Object)this.assignmentState) + ", " + String.valueOf((Object)this.consumerState) + ")";
    }

    @Generated
    public AssignmentState getAssignmentState() {
        return this.assignmentState;
    }

    @Nullable
    @Generated
    public ConsumerState getConsumerState() {
        return this.consumerState;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionState)) {
            return false;
        }
        SubscriptionState other = (SubscriptionState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssignmentState this$assignmentState = this.getAssignmentState();
        AssignmentState other$assignmentState = other.getAssignmentState();
        if (this$assignmentState == null ? other$assignmentState != null : !((Object)((Object)this$assignmentState)).equals((Object)other$assignmentState)) {
            return false;
        }
        ConsumerState this$consumerState = this.getConsumerState();
        ConsumerState other$consumerState = other.getConsumerState();
        return !(this$consumerState == null ? other$consumerState != null : !((Object)((Object)this$consumerState)).equals((Object)other$consumerState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssignmentState $assignmentState = this.getAssignmentState();
        result = result * 59 + ($assignmentState == null ? 43 : ((Object)((Object)$assignmentState)).hashCode());
        ConsumerState $consumerState = this.getConsumerState();
        result = result * 59 + ($consumerState == null ? 43 : ((Object)((Object)$consumerState)).hashCode());
        return result;
    }

    @Generated
    public SubscriptionState(AssignmentState assignmentState, @Nullable ConsumerState consumerState) {
        this.assignmentState = assignmentState;
        this.consumerState = consumerState;
    }
}

