/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.filters;

import com.flipkart.varadhi.entities.filters.Condition;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.stream.Collectors;

public class BooleanConditions {

    public record NotCondition(Condition value) implements Condition
    {
        @Override
        public String toString() {
            return "not(" + this.value.toString() + ")";
        }

        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return !this.value.evaluate(headers);
        }
    }

    public record NorCondition(List<Condition> values) implements Condition
    {
        @Override
        public String toString() {
            return "not(" + this.values.stream().map(Condition::toString).collect(Collectors.joining(" or ")) + ")";
        }

        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return this.values.stream().noneMatch(condition -> condition.evaluate(headers));
        }
    }

    public record OrCondition(List<Condition> values) implements Condition
    {
        @Override
        public String toString() {
            return this.values.stream().map(Condition::toString).collect(Collectors.joining(" or "));
        }

        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return this.values.stream().anyMatch(condition -> condition.evaluate(headers));
        }
    }

    public record NandCondition(List<Condition> values) implements Condition
    {
        @Override
        public String toString() {
            return "not(" + this.values.stream().map(Condition::toString).collect(Collectors.joining(" and ")) + ")";
        }

        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return !this.values.stream().allMatch(condition -> condition.evaluate(headers));
        }
    }

    public record AndCondition(List<Condition> values) implements Condition
    {
        @Override
        public String toString() {
            return this.values.stream().map(Condition::toString).collect(Collectors.joining(" and "));
        }

        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return this.values.stream().allMatch(condition -> condition.evaluate(headers));
        }
    }
}

