/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.filters;

import com.flipkart.varadhi.entities.filters.Condition;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.stream.Collectors;

public class StringConditions {

    public record InCondition(String key, List<String> values) implements Condition
    {
        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return headers.get((Object)this.key).stream().anyMatch(this.values::contains);
        }

        @Override
        public String toString() {
            return String.format("in(%s,[%s])", this.key, this.values.stream().map(value -> String.format("\"%s\"", value)).collect(Collectors.joining(",")));
        }
    }

    public record ExistsCondition(String key) implements Condition
    {
        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return headers.containsKey((Object)this.key);
        }

        @Override
        public String toString() {
            return String.format("exists(%s)", this.key);
        }
    }

    public record EndsWithCondition(String key, String value) implements Condition
    {
        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return headers.get((Object)this.key).stream().anyMatch(headerValue -> headerValue.endsWith(this.value));
        }

        @Override
        public String toString() {
            return String.format("endsWith(%s,\"%s\")", this.key, this.value);
        }
    }

    public record StartsWithCondition(String key, String value) implements Condition
    {
        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return headers.get((Object)this.key).stream().anyMatch(headerValue -> headerValue.startsWith(this.value));
        }

        @Override
        public String toString() {
            return String.format("startsWith(%s,\"%s\")", this.key, this.value);
        }
    }

    public record ContainsCondition(String key, String value) implements Condition
    {
        @Override
        public boolean evaluate(Multimap<String, String> headers) {
            return headers.get((Object)this.key).stream().anyMatch(headerValue -> headerValue.contains(this.value));
        }

        @Override
        public String toString() {
            return String.format("contains(%s,\"%s\")", this.key, this.value);
        }
    }
}

