/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.util.Iterator;

public class HeadersDeserializer
extends StdDeserializer<ArrayListMultimap<String, String>> {
    public HeadersDeserializer() {
        this(ArrayListMultimap.class);
    }

    public HeadersDeserializer(Class<ArrayListMultimap<String, String>> clazz) {
        super(clazz);
    }

    public ArrayListMultimap<String, String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String key = (String)fieldNames.next();
            JsonNode valuesNode = node.get(key);
            if (!valuesNode.isArray()) continue;
            for (JsonNode valueNode : valuesNode) {
                multiMap.put((Object)key, (Object)valueNode.asText());
            }
        }
        return multiMap;
    }

    public ArrayListMultimap<String, String> deserializeWithType(JsonParser p, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, deserializationContext);
    }
}

