/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.varadhi.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.flipkart.varadhi.entities.Message;
import com.flipkart.varadhi.entities.Offset;
import com.flipkart.varadhi.entities.StdHeaders;
import com.flipkart.varadhi.entities.utils.HeadersDeserializer;
import com.flipkart.varadhi.entities.utils.HeadersSerializer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class DlqMessage
implements Message {
    private final byte[] payload;
    @JsonSerialize(using=HeadersSerializer.class)
    @JsonDeserialize(using=HeadersDeserializer.class)
    private final ArrayListMultimap<String, String> requestHeaders;
    private final Offset offset;
    private final int partitionIndex;

    @Override
    @JsonIgnore
    public String getMessageId() {
        return this.getHeader(StdHeaders.get().msgId());
    }

    @Override
    @JsonIgnore
    public String getGroupId() {
        return this.getHeader(StdHeaders.get().groupId());
    }

    @Override
    @JsonIgnore
    public boolean hasHeader(String key) {
        return this.requestHeaders.containsKey((Object)key);
    }

    @Override
    @JsonIgnore
    public String getHeader(String key) {
        return !this.requestHeaders.containsKey((Object)key) || this.requestHeaders.get((Object)key).isEmpty() ? null : (String)this.requestHeaders.get((Object)key).getFirst();
    }

    @Override
    @JsonIgnore
    public List<String> getHeaders(String key) {
        return new ArrayList<String>(this.requestHeaders.get((Object)key));
    }

    @Override
    @JsonIgnore
    public Multimap<String, String> getHeaders() {
        return this.requestHeaders;
    }

    @Generated
    public DlqMessage(byte[] payload, ArrayListMultimap<String, String> requestHeaders, Offset offset, int partitionIndex) {
        this.payload = payload;
        this.requestHeaders = requestHeaders;
        this.offset = offset;
        this.partitionIndex = partitionIndex;
    }

    @Override
    @Generated
    public byte[] getPayload() {
        return this.payload;
    }

    @Generated
    public ArrayListMultimap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Generated
    public Offset getOffset() {
        return this.offset;
    }

    @Generated
    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DlqMessage)) {
            return false;
        }
        DlqMessage other = (DlqMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitionIndex() != other.getPartitionIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getPayload(), other.getPayload())) {
            return false;
        }
        ArrayListMultimap<String, String> this$requestHeaders = this.getRequestHeaders();
        ArrayListMultimap<String, String> other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !this$requestHeaders.equals(other$requestHeaders)) {
            return false;
        }
        Offset this$offset = this.getOffset();
        Offset other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !this$offset.equals(other$offset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DlqMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitionIndex();
        result = result * 59 + Arrays.hashCode(this.getPayload());
        ArrayListMultimap<String, String> $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : $requestHeaders.hashCode());
        Offset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DlqMessage(payload=" + Arrays.toString(this.getPayload()) + ", requestHeaders=" + String.valueOf(this.getRequestHeaders()) + ", offset=" + String.valueOf(this.getOffset()) + ", partitionIndex=" + this.getPartitionIndex() + ")";
    }
}

