// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25860 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__25860,(0),null);
var network = cljs.core.nth.call(null,vec__25860,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__25860,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_25957){
var state_val_25958 = (state_25957[(1)]);
if((state_val_25958 === (7))){
var inst_25878 = (state_25957[(7)]);
var inst_25883 = inst_25878.cljs$lang$protocol_mask$partition0$;
var inst_25884 = (inst_25883 & (64));
var inst_25885 = inst_25878.cljs$core$ISeq$;
var inst_25886 = (cljs.core.PROTOCOL_SENTINEL === inst_25885);
var inst_25887 = ((inst_25884) || (inst_25886));
var state_25957__$1 = state_25957;
if(cljs.core.truth_(inst_25887)){
var statearr_25959_26005 = state_25957__$1;
(statearr_25959_26005[(1)] = (10));

} else {
var statearr_25960_26006 = state_25957__$1;
(statearr_25960_26006[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (20))){
var state_25957__$1 = state_25957;
var statearr_25961_26007 = state_25957__$1;
(statearr_25961_26007[(2)] = false);

(statearr_25961_26007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (27))){
var inst_25877 = (state_25957[(8)]);
var inst_25903 = (state_25957[(9)]);
var inst_25900 = (state_25957[(10)]);
var inst_25941 = (state_25957[(2)]);
var inst_25942 = cljs.core.into.call(null,inst_25900,inst_25877);
var inst_25943 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25944 = cljs.core.swap_BANG_.call(null,inst_25943,cljs.core.empty);
var inst_25945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25946 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25947 = (new cljs.core.PersistentVector(null,2,(5),inst_25945,inst_25946,null));
var inst_25948 = cljs.core.assoc_in.call(null,db,inst_25947,inst_25942);
var inst_25949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25950 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25951 = (new cljs.core.PersistentVector(null,2,(5),inst_25949,inst_25950,null));
var inst_25952 = cljs.core.assoc_in.call(null,inst_25948,inst_25951,inst_25903);
var _ = (function (){var statearr_25962 = state_25957;
(statearr_25962[(4)] = cljs.core.rest.call(null,(state_25957[(4)])));

return statearr_25962;
})();
var state_25957__$1 = (function (){var statearr_25963 = state_25957;
(statearr_25963[(11)] = inst_25941);

(statearr_25963[(12)] = inst_25944);

return statearr_25963;
})();
var statearr_25964_26008 = state_25957__$1;
(statearr_25964_26008[(2)] = inst_25952);

(statearr_25964_26008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (1))){
var state_25957__$1 = state_25957;
var statearr_25965_26009 = state_25957__$1;
(statearr_25965_26009[(2)] = null);

(statearr_25965_26009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (24))){
var inst_25903 = (state_25957[(9)]);
var inst_25928 = (state_25957[(2)]);
var inst_25929 = cljs.core.get.call(null,inst_25928,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25930 = cljs.core.get.call(null,inst_25928,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25931 = (inst_25903 > inst_25930);
var state_25957__$1 = (function (){var statearr_25966 = state_25957;
(statearr_25966[(13)] = inst_25929);

return statearr_25966;
})();
if(cljs.core.truth_(inst_25931)){
var statearr_25967_26010 = state_25957__$1;
(statearr_25967_26010[(1)] = (25));

} else {
var statearr_25968_26011 = state_25957__$1;
(statearr_25968_26011[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (4))){
var inst_25863 = (state_25957[(2)]);
var state_25957__$1 = state_25957;
var statearr_25969_26012 = state_25957__$1;
(statearr_25969_26012[(2)] = inst_25863);

(statearr_25969_26012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (15))){
var inst_25907 = (state_25957[(14)]);
var inst_25877 = (state_25957[(8)]);
var inst_25899 = (state_25957[(2)]);
var inst_25900 = cljs.core.get.call(null,inst_25899,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25901 = cljs.core.get.call(null,inst_25899,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25902 = fluree.db.flake.size_bytes.call(null,inst_25877);
var inst_25903 = (inst_25901 + inst_25902);
var inst_25904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25905 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25906 = (new cljs.core.PersistentVector(null,2,(5),inst_25904,inst_25905,null));
var inst_25907__$1 = cljs.core.get_in.call(null,db,inst_25906);
var inst_25909 = (inst_25907__$1 == null);
var inst_25910 = cljs.core.not.call(null,inst_25909);
var state_25957__$1 = (function (){var statearr_25970 = state_25957;
(statearr_25970[(14)] = inst_25907__$1);

(statearr_25970[(9)] = inst_25903);

(statearr_25970[(10)] = inst_25900);

return statearr_25970;
})();
if(inst_25910){
var statearr_25971_26013 = state_25957__$1;
(statearr_25971_26013[(1)] = (16));

} else {
var statearr_25972_26014 = state_25957__$1;
(statearr_25972_26014[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (21))){
var inst_25920 = (state_25957[(2)]);
var state_25957__$1 = state_25957;
var statearr_25973_26015 = state_25957__$1;
(statearr_25973_26015[(2)] = inst_25920);

(statearr_25973_26015[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (13))){
var inst_25878 = (state_25957[(7)]);
var inst_25896 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25878);
var state_25957__$1 = state_25957;
var statearr_25974_26016 = state_25957__$1;
(statearr_25974_26016[(2)] = inst_25896);

(statearr_25974_26016[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (22))){
var inst_25907 = (state_25957[(14)]);
var inst_25925 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25907);
var state_25957__$1 = state_25957;
var statearr_25975_26017 = state_25957__$1;
(statearr_25975_26017[(2)] = inst_25925);

(statearr_25975_26017[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (6))){
var inst_25878 = (state_25957[(7)]);
var inst_25876 = (state_25957[(2)]);
var inst_25877 = fluree.db.util.async.throw_err.call(null,inst_25876);
var inst_25878__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25880 = (inst_25878__$1 == null);
var inst_25881 = cljs.core.not.call(null,inst_25880);
var state_25957__$1 = (function (){var statearr_25976 = state_25957;
(statearr_25976[(7)] = inst_25878__$1);

(statearr_25976[(8)] = inst_25877);

return statearr_25976;
})();
if(inst_25881){
var statearr_25977_26018 = state_25957__$1;
(statearr_25977_26018[(1)] = (7));

} else {
var statearr_25978_26019 = state_25957__$1;
(statearr_25978_26019[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (25))){
var inst_25933 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25934 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25935 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25936 = cljs.core.PersistentHashMap.fromArrays(inst_25934,inst_25935);
var inst_25937 = cljs.core.ex_info.call(null,inst_25933,inst_25936);
var inst_25938 = (function(){throw inst_25937})();
var state_25957__$1 = state_25957;
var statearr_25979_26020 = state_25957__$1;
(statearr_25979_26020[(2)] = inst_25938);

(statearr_25979_26020[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (17))){
var state_25957__$1 = state_25957;
var statearr_25980_26021 = state_25957__$1;
(statearr_25980_26021[(2)] = false);

(statearr_25980_26021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (3))){
var inst_25955 = (state_25957[(2)]);
var state_25957__$1 = state_25957;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25957__$1,inst_25955);
} else {
if((state_val_25958 === (12))){
var inst_25891 = (state_25957[(2)]);
var state_25957__$1 = state_25957;
var statearr_25981_26022 = state_25957__$1;
(statearr_25981_26022[(2)] = inst_25891);

(statearr_25981_26022[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (2))){
var _ = (function (){var statearr_25982 = state_25957;
(statearr_25982[(4)] = cljs.core.cons.call(null,(5),(state_25957[(4)])));

return statearr_25982;
})();
var inst_25871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25872 = [pred_id];
var inst_25873 = (new cljs.core.PersistentVector(null,1,(5),inst_25871,inst_25872,null));
var inst_25874 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25873);
var state_25957__$1 = state_25957;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25957__$1,(6),inst_25874);
} else {
if((state_val_25958 === (23))){
var inst_25907 = (state_25957[(14)]);
var state_25957__$1 = state_25957;
var statearr_25983_26023 = state_25957__$1;
(statearr_25983_26023[(2)] = inst_25907);

(statearr_25983_26023[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (19))){
var state_25957__$1 = state_25957;
var statearr_25984_26024 = state_25957__$1;
(statearr_25984_26024[(2)] = true);

(statearr_25984_26024[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (11))){
var state_25957__$1 = state_25957;
var statearr_25986_26025 = state_25957__$1;
(statearr_25986_26025[(2)] = false);

(statearr_25986_26025[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (9))){
var inst_25894 = (state_25957[(2)]);
var state_25957__$1 = state_25957;
if(cljs.core.truth_(inst_25894)){
var statearr_25987_26026 = state_25957__$1;
(statearr_25987_26026[(1)] = (13));

} else {
var statearr_25988_26027 = state_25957__$1;
(statearr_25988_26027[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (5))){
var _ = (function (){var statearr_25989 = state_25957;
(statearr_25989[(4)] = cljs.core.rest.call(null,(state_25957[(4)])));

return statearr_25989;
})();
var state_25957__$1 = state_25957;
var ex25985 = (state_25957__$1[(2)]);
var statearr_25990_26028 = state_25957__$1;
(statearr_25990_26028[(5)] = ex25985);


if((ex25985 instanceof Error)){
var statearr_25991_26029 = state_25957__$1;
(statearr_25991_26029[(1)] = (4));

(statearr_25991_26029[(5)] = null);

} else {
throw ex25985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (14))){
var inst_25878 = (state_25957[(7)]);
var state_25957__$1 = state_25957;
var statearr_25992_26030 = state_25957__$1;
(statearr_25992_26030[(2)] = inst_25878);

(statearr_25992_26030[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (26))){
var state_25957__$1 = state_25957;
var statearr_25993_26031 = state_25957__$1;
(statearr_25993_26031[(2)] = null);

(statearr_25993_26031[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (16))){
var inst_25907 = (state_25957[(14)]);
var inst_25912 = inst_25907.cljs$lang$protocol_mask$partition0$;
var inst_25913 = (inst_25912 & (64));
var inst_25914 = inst_25907.cljs$core$ISeq$;
var inst_25915 = (cljs.core.PROTOCOL_SENTINEL === inst_25914);
var inst_25916 = ((inst_25913) || (inst_25915));
var state_25957__$1 = state_25957;
if(cljs.core.truth_(inst_25916)){
var statearr_25994_26032 = state_25957__$1;
(statearr_25994_26032[(1)] = (19));

} else {
var statearr_25995_26033 = state_25957__$1;
(statearr_25995_26033[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (10))){
var state_25957__$1 = state_25957;
var statearr_25996_26034 = state_25957__$1;
(statearr_25996_26034[(2)] = true);

(statearr_25996_26034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (18))){
var inst_25923 = (state_25957[(2)]);
var state_25957__$1 = state_25957;
if(cljs.core.truth_(inst_25923)){
var statearr_25997_26035 = state_25957__$1;
(statearr_25997_26035[(1)] = (22));

} else {
var statearr_25998_26036 = state_25957__$1;
(statearr_25998_26036[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25958 === (8))){
var state_25957__$1 = state_25957;
var statearr_25999_26037 = state_25957__$1;
(statearr_25999_26037[(2)] = false);

(statearr_25999_26037[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto____0 = (function (){
var statearr_26000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26000[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto__);

(statearr_26000[(1)] = (1));

return statearr_26000;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto____1 = (function (state_25957){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_25957);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26001){var ex__2471__auto__ = e26001;
var statearr_26002_26038 = state_25957;
(statearr_26002_26038[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_25957[(4)]))){
var statearr_26003_26039 = state_25957;
(statearr_26003_26039[(1)] = cljs.core.first.call(null,(state_25957[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26040 = state_25957;
state_25957 = G__26040;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto__ = function(state_25957){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto____1.call(this,state_25957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26004 = f__2491__auto__.call(null);
(statearr_26004[(6)] = c__2490__auto__);

return statearr_26004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26239){
var state_val_26240 = (state_26239[(1)]);
if((state_val_26240 === (7))){
var state_26239__$1 = state_26239;
var statearr_26241_26307 = state_26239__$1;
(statearr_26241_26307[(2)] = null);

(statearr_26241_26307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (20))){
var inst_26161 = (state_26239[(7)]);
var inst_26162 = (state_26239[(8)]);
var inst_26164 = (state_26239[(9)]);
var inst_26132 = (state_26239[(10)]);
var inst_26082 = (state_26239[(11)]);
var inst_26081 = (state_26239[(12)]);
var inst_26165 = (state_26239[(13)]);
var inst_26163 = (state_26239[(14)]);
var inst_26175 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26177 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26178 = (new cljs.core.PersistentVector(null,2,(5),inst_26176,inst_26177,null));
var inst_26179 = cljs.core.get_in.call(null,inst_26132,inst_26178);
var inst_26180 = (inst_26081 + inst_26179);
var inst_26181 = [inst_26161,inst_26162,inst_26163,inst_26164,inst_26180];
var inst_26182 = cljs.core.PersistentHashMap.fromArrays(inst_26175,inst_26181);
var inst_26183 = cljs.core.assoc.call(null,inst_26132,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26165,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26182);
var state_26239__$1 = (function (){var statearr_26242 = state_26239;
(statearr_26242[(15)] = inst_26183);

return statearr_26242;
})();
if(cljs.core.truth_(inst_26082)){
var statearr_26243_26308 = state_26239__$1;
(statearr_26243_26308[(1)] = (23));

} else {
var statearr_26244_26309 = state_26239__$1;
(statearr_26244_26309[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (27))){
var inst_26183 = (state_26239[(15)]);
var state_26239__$1 = state_26239;
var statearr_26245_26310 = state_26239__$1;
(statearr_26245_26310[(2)] = inst_26183);

(statearr_26245_26310[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (1))){
var state_26239__$1 = state_26239;
var statearr_26246_26311 = state_26239__$1;
(statearr_26246_26311[(2)] = null);

(statearr_26246_26311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (24))){
var inst_26183 = (state_26239[(15)]);
var inst_26186 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26183);
var inst_26187 = (inst_26186 == null);
var state_26239__$1 = state_26239;
var statearr_26247_26312 = state_26239__$1;
(statearr_26247_26312[(2)] = inst_26187);

(statearr_26247_26312[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (39))){
var inst_26215 = (state_26239[(16)]);
var inst_26172 = (state_26239[(17)]);
var inst_26214 = (state_26239[(18)]);
var inst_26222 = (state_26239[(19)]);
var inst_26213 = (state_26239[(20)]);
var inst_26229 = (state_26239[(2)]);
var inst_26160 = inst_26172;
var inst_26161 = inst_26214;
var inst_26162 = inst_26215;
var inst_26163 = inst_26222;
var inst_26164 = inst_26229;
var inst_26165 = inst_26213;
var state_26239__$1 = (function (){var statearr_26248 = state_26239;
(statearr_26248[(7)] = inst_26161);

(statearr_26248[(8)] = inst_26162);

(statearr_26248[(9)] = inst_26164);

(statearr_26248[(21)] = inst_26160);

(statearr_26248[(13)] = inst_26165);

(statearr_26248[(14)] = inst_26163);

return statearr_26248;
})();
var statearr_26249_26313 = state_26239__$1;
(statearr_26249_26313[(2)] = null);

(statearr_26249_26313[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (4))){
var inst_26044 = (state_26239[(2)]);
var state_26239__$1 = state_26239;
var statearr_26250_26314 = state_26239__$1;
(statearr_26250_26314[(2)] = inst_26044);

(statearr_26250_26314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (15))){
var inst_26104 = (state_26239[(22)]);
var state_26239__$1 = state_26239;
var statearr_26251_26315 = state_26239__$1;
(statearr_26251_26315[(2)] = inst_26104);

(statearr_26251_26315[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (21))){
var inst_26161 = (state_26239[(7)]);
var inst_26051 = (state_26239[(23)]);
var inst_26076 = (state_26239[(24)]);
var inst_26066 = (state_26239[(25)]);
var inst_26091 = (state_26239[(26)]);
var inst_26142 = (state_26239[(27)]);
var inst_26162 = (state_26239[(8)]);
var inst_26164 = (state_26239[(9)]);
var inst_26172 = (state_26239[(17)]);
var inst_26160 = (state_26239[(21)]);
var inst_26068 = (state_26239[(28)]);
var inst_26132 = (state_26239[(10)]);
var inst_26085 = (state_26239[(29)]);
var inst_26082 = (state_26239[(11)]);
var inst_26081 = (state_26239[(12)]);
var inst_26083 = (state_26239[(30)]);
var inst_26080 = (state_26239[(31)]);
var inst_26171 = (state_26239[(32)]);
var inst_26165 = (state_26239[(13)]);
var inst_26141 = (state_26239[(33)]);
var inst_26163 = (state_26239[(14)]);
var inst_26072 = (state_26239[(34)]);
var inst_26210 = inst_26171.s;
var inst_26211 = fluree.db.flake.sid__GT_cid.call(null,inst_26210);
var inst_26212 = (function (){var flakes_bytes = inst_26081;
var first__26139 = inst_26141;
var t = inst_26051;
var vec__26137 = inst_26068;
var spot = inst_26161;
var add_flakes = inst_26068;
var seq__26138 = inst_26142;
var root_setting_change_QMARK_ = inst_26083;
var ref_QMARK__map = inst_26080;
var r = inst_26172;
var seq__26168 = inst_26172;
var psot = inst_26162;
var first__26169 = inst_26171;
var add_pred_to_idx_QMARK_ = inst_26091;
var _ = inst_26066;
var cid = inst_26211;
var ecount = inst_26165;
var vec__26167 = inst_26160;
var pred_ecount = inst_26085;
var G__26136 = inst_26160;
var db_STAR_ = inst_26132;
var schema_change_QMARK_ = inst_26082;
var add_preds = inst_26072;
var opst = inst_26164;
var idx_QMARK__map = inst_26076;
var post = inst_26163;
var f = inst_26171;
return (function (p1__26043_SHARP_){
if(cljs.core.truth_(p1__26043_SHARP_)){
var x__4214__auto__ = p1__26043_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_26213 = cljs.core.update.call(null,inst_26165,inst_26211,inst_26212);
var inst_26214 = cljs.core.conj.call(null,inst_26161,inst_26171);
var inst_26215 = cljs.core.conj.call(null,inst_26162,inst_26171);
var inst_26216 = inst_26171.p;
var inst_26217 = cljs.core.get.call(null,inst_26076,inst_26216);
var state_26239__$1 = (function (){var statearr_26252 = state_26239;
(statearr_26252[(16)] = inst_26215);

(statearr_26252[(18)] = inst_26214);

(statearr_26252[(20)] = inst_26213);

return statearr_26252;
})();
if(cljs.core.truth_(inst_26217)){
var statearr_26253_26316 = state_26239__$1;
(statearr_26253_26316[(1)] = (34));

} else {
var statearr_26254_26317 = state_26239__$1;
(statearr_26254_26317[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (31))){
var inst_26198 = (state_26239[(35)]);
var state_26239__$1 = state_26239;
var statearr_26255_26318 = state_26239__$1;
(statearr_26255_26318[(2)] = inst_26198);

(statearr_26255_26318[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (32))){
var inst_26208 = (state_26239[(2)]);
var state_26239__$1 = state_26239;
var statearr_26256_26319 = state_26239__$1;
(statearr_26256_26319[(2)] = inst_26208);

(statearr_26256_26319[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (33))){
var inst_26198 = (state_26239[(35)]);
var inst_26203 = (state_26239[(2)]);
var inst_26204 = fluree.db.util.async.throw_err.call(null,inst_26203);
var inst_26205 = cljs.core.assoc.call(null,inst_26198,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26204);
var state_26239__$1 = state_26239;
var statearr_26257_26320 = state_26239__$1;
(statearr_26257_26320[(2)] = inst_26205);

(statearr_26257_26320[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (13))){
var inst_26051 = (state_26239[(23)]);
var inst_26068 = (state_26239[(28)]);
var inst_26132 = (state_26239[(10)]);
var inst_26081 = (state_26239[(12)]);
var inst_26122 = (state_26239[(2)]);
var inst_26123 = cljs.core.assoc.call(null,inst_26122,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26051);
var inst_26124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26125 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26126 = (new cljs.core.PersistentVector(null,2,(5),inst_26124,inst_26125,null));
var inst_26127 = cljs.core.update_in.call(null,inst_26123,inst_26126,cljs.core._PLUS_,inst_26081);
var inst_26128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26129 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26130 = (new cljs.core.PersistentVector(null,2,(5),inst_26128,inst_26129,null));
var inst_26131 = cljs.core.count.call(null,inst_26068);
var inst_26132__$1 = cljs.core.update_in.call(null,inst_26127,inst_26130,cljs.core._PLUS_,inst_26131);
var inst_26140 = cljs.core.seq.call(null,inst_26068);
var inst_26141 = cljs.core.first.call(null,inst_26140);
var inst_26142 = cljs.core.next.call(null,inst_26140);
var inst_26143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26144 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26145 = (new cljs.core.PersistentVector(null,2,(5),inst_26143,inst_26144,null));
var inst_26146 = cljs.core.get_in.call(null,inst_26132__$1,inst_26145);
var inst_26147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26148 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26149 = (new cljs.core.PersistentVector(null,2,(5),inst_26147,inst_26148,null));
var inst_26150 = cljs.core.get_in.call(null,inst_26132__$1,inst_26149);
var inst_26151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26152 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26153 = (new cljs.core.PersistentVector(null,2,(5),inst_26151,inst_26152,null));
var inst_26154 = cljs.core.get_in.call(null,inst_26132__$1,inst_26153);
var inst_26155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26156 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26157 = (new cljs.core.PersistentVector(null,2,(5),inst_26155,inst_26156,null));
var inst_26158 = cljs.core.get_in.call(null,inst_26132__$1,inst_26157);
var inst_26159 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26160 = inst_26068;
var inst_26161 = inst_26146;
var inst_26162 = inst_26150;
var inst_26163 = inst_26154;
var inst_26164 = inst_26158;
var inst_26165 = inst_26159;
var state_26239__$1 = (function (){var statearr_26258 = state_26239;
(statearr_26258[(7)] = inst_26161);

(statearr_26258[(27)] = inst_26142);

(statearr_26258[(8)] = inst_26162);

(statearr_26258[(9)] = inst_26164);

(statearr_26258[(21)] = inst_26160);

(statearr_26258[(10)] = inst_26132__$1);

(statearr_26258[(13)] = inst_26165);

(statearr_26258[(33)] = inst_26141);

(statearr_26258[(14)] = inst_26163);

return statearr_26258;
})();
var statearr_26259_26321 = state_26239__$1;
(statearr_26259_26321[(2)] = null);

(statearr_26259_26321[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (22))){
var inst_26232 = (state_26239[(2)]);
var state_26239__$1 = state_26239;
var statearr_26260_26322 = state_26239__$1;
(statearr_26260_26322[(2)] = inst_26232);

(statearr_26260_26322[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (36))){
var inst_26080 = (state_26239[(31)]);
var inst_26171 = (state_26239[(32)]);
var inst_26222 = (state_26239[(2)]);
var inst_26223 = inst_26171.p;
var inst_26224 = cljs.core.get.call(null,inst_26080,inst_26223);
var state_26239__$1 = (function (){var statearr_26261 = state_26239;
(statearr_26261[(19)] = inst_26222);

return statearr_26261;
})();
if(cljs.core.truth_(inst_26224)){
var statearr_26262_26323 = state_26239__$1;
(statearr_26262_26323[(1)] = (37));

} else {
var statearr_26263_26324 = state_26239__$1;
(statearr_26263_26324[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (29))){
var inst_26183 = (state_26239[(15)]);
var inst_26193 = (state_26239[(2)]);
var inst_26194 = fluree.db.util.async.throw_err.call(null,inst_26193);
var inst_26195 = cljs.core.assoc.call(null,inst_26183,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26194);
var state_26239__$1 = state_26239;
var statearr_26264_26325 = state_26239__$1;
(statearr_26264_26325[(2)] = inst_26195);

(statearr_26264_26325[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (6))){
var inst_26051 = (state_26239[(23)]);
var inst_26056 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26057 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26058 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26056)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26057)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26051),"."].join('');
var inst_26059 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26060 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26061 = cljs.core.PersistentHashMap.fromArrays(inst_26059,inst_26060);
var inst_26062 = cljs.core.ex_info.call(null,inst_26058,inst_26061);
var inst_26063 = (function(){throw inst_26062})();
var state_26239__$1 = state_26239;
var statearr_26265_26326 = state_26239__$1;
(statearr_26265_26326[(2)] = inst_26063);

(statearr_26265_26326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (28))){
var inst_26083 = (state_26239[(30)]);
var inst_26198 = (state_26239[(2)]);
var state_26239__$1 = (function (){var statearr_26266 = state_26239;
(statearr_26266[(35)] = inst_26198);

return statearr_26266;
})();
if(cljs.core.truth_(inst_26083)){
var statearr_26267_26327 = state_26239__$1;
(statearr_26267_26327[(1)] = (30));

} else {
var statearr_26268_26328 = state_26239__$1;
(statearr_26268_26328[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (25))){
var inst_26189 = (state_26239[(2)]);
var state_26239__$1 = state_26239;
if(cljs.core.truth_(inst_26189)){
var statearr_26269_26329 = state_26239__$1;
(statearr_26269_26329[(1)] = (26));

} else {
var statearr_26270_26330 = state_26239__$1;
(statearr_26270_26330[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (34))){
var inst_26171 = (state_26239[(32)]);
var inst_26163 = (state_26239[(14)]);
var inst_26219 = cljs.core.conj.call(null,inst_26163,inst_26171);
var state_26239__$1 = state_26239;
var statearr_26271_26331 = state_26239__$1;
(statearr_26271_26331[(2)] = inst_26219);

(statearr_26271_26331[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (17))){
var inst_26111 = (state_26239[(36)]);
var inst_26115 = (state_26239[(2)]);
var inst_26116 = fluree.db.util.async.throw_err.call(null,inst_26115);
var inst_26103 = inst_26111;
var inst_26104 = inst_26116;
var state_26239__$1 = (function (){var statearr_26272 = state_26239;
(statearr_26272[(37)] = inst_26103);

(statearr_26272[(22)] = inst_26104);

return statearr_26272;
})();
var statearr_26273_26332 = state_26239__$1;
(statearr_26273_26332[(2)] = null);

(statearr_26273_26332[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (3))){
var inst_26237 = (state_26239[(2)]);
var state_26239__$1 = state_26239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26239__$1,inst_26237);
} else {
if((state_val_26240 === (12))){
var inst_26103 = (state_26239[(37)]);
var inst_26110 = (state_26239[(38)]);
var inst_26109 = cljs.core.seq.call(null,inst_26103);
var inst_26110__$1 = cljs.core.first.call(null,inst_26109);
var inst_26111 = cljs.core.next.call(null,inst_26109);
var state_26239__$1 = (function (){var statearr_26274 = state_26239;
(statearr_26274[(38)] = inst_26110__$1);

(statearr_26274[(36)] = inst_26111);

return statearr_26274;
})();
if(cljs.core.truth_(inst_26110__$1)){
var statearr_26275_26333 = state_26239__$1;
(statearr_26275_26333[(1)] = (14));

} else {
var statearr_26276_26334 = state_26239__$1;
(statearr_26276_26334[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (2))){
var inst_26051 = (state_26239[(23)]);
var _ = (function (){var statearr_26277 = state_26239;
(statearr_26277[(4)] = cljs.core.cons.call(null,(5),(state_26239[(4)])));

return statearr_26277;
})();
var inst_26050 = cljs.core.first.call(null,flakes);
var inst_26051__$1 = inst_26050.t;
var inst_26052 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26053 = (inst_26052 - (1));
var inst_26054 = cljs.core.not_EQ_.call(null,inst_26051__$1,inst_26053);
var state_26239__$1 = (function (){var statearr_26278 = state_26239;
(statearr_26278[(23)] = inst_26051__$1);

return statearr_26278;
})();
if(inst_26054){
var statearr_26279_26335 = state_26239__$1;
(statearr_26279_26335[(1)] = (6));

} else {
var statearr_26280_26336 = state_26239__$1;
(statearr_26280_26336[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (23))){
var inst_26082 = (state_26239[(11)]);
var state_26239__$1 = state_26239;
var statearr_26281_26337 = state_26239__$1;
(statearr_26281_26337[(2)] = inst_26082);

(statearr_26281_26337[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (35))){
var inst_26163 = (state_26239[(14)]);
var state_26239__$1 = state_26239;
var statearr_26282_26338 = state_26239__$1;
(statearr_26282_26338[(2)] = inst_26163);

(statearr_26282_26338[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (19))){
var inst_26234 = (state_26239[(2)]);
var _ = (function (){var statearr_26283 = state_26239;
(statearr_26283[(4)] = cljs.core.rest.call(null,(state_26239[(4)])));

return statearr_26283;
})();
var state_26239__$1 = state_26239;
var statearr_26284_26339 = state_26239__$1;
(statearr_26284_26339[(2)] = inst_26234);

(statearr_26284_26339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (11))){
var inst_26091 = (state_26239[(26)]);
var inst_26091__$1 = (state_26239[(2)]);
var inst_26099 = cljs.core.seq.call(null,inst_26091__$1);
var inst_26100 = cljs.core.first.call(null,inst_26099);
var inst_26101 = cljs.core.next.call(null,inst_26099);
var inst_26102 = db;
var inst_26103 = inst_26091__$1;
var inst_26104 = inst_26102;
var state_26239__$1 = (function (){var statearr_26286 = state_26239;
(statearr_26286[(26)] = inst_26091__$1);

(statearr_26286[(37)] = inst_26103);

(statearr_26286[(39)] = inst_26101);

(statearr_26286[(22)] = inst_26104);

(statearr_26286[(40)] = inst_26100);

return statearr_26286;
})();
var statearr_26287_26340 = state_26239__$1;
(statearr_26287_26340[(2)] = null);

(statearr_26287_26340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (9))){
var inst_26068 = (state_26239[(28)]);
var inst_26085 = (state_26239[(29)]);
var inst_26087 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_26068,inst_26085);
var state_26239__$1 = state_26239;
var statearr_26288_26341 = state_26239__$1;
(statearr_26288_26341[(2)] = inst_26087);

(statearr_26288_26341[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (5))){
var _ = (function (){var statearr_26289 = state_26239;
(statearr_26289[(4)] = cljs.core.rest.call(null,(state_26239[(4)])));

return statearr_26289;
})();
var state_26239__$1 = state_26239;
var ex26285 = (state_26239__$1[(2)]);
var statearr_26290_26342 = state_26239__$1;
(statearr_26290_26342[(5)] = ex26285);


if((ex26285 instanceof Error)){
var statearr_26291_26343 = state_26239__$1;
(statearr_26291_26343[(1)] = (4));

(statearr_26291_26343[(5)] = null);

} else {
throw ex26285;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (14))){
var inst_26110 = (state_26239[(38)]);
var inst_26104 = (state_26239[(22)]);
var inst_26113 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_26104,inst_26110);
var state_26239__$1 = state_26239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26239__$1,(17),inst_26113);
} else {
if((state_val_26240 === (26))){
var inst_26183 = (state_26239[(15)]);
var inst_26191 = fluree.db.query.schema.schema_map.call(null,inst_26183);
var state_26239__$1 = state_26239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26239__$1,(29),inst_26191);
} else {
if((state_val_26240 === (16))){
var inst_26120 = (state_26239[(2)]);
var state_26239__$1 = state_26239;
var statearr_26292_26344 = state_26239__$1;
(statearr_26292_26344[(2)] = inst_26120);

(statearr_26292_26344[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (38))){
var inst_26164 = (state_26239[(9)]);
var state_26239__$1 = state_26239;
var statearr_26293_26345 = state_26239__$1;
(statearr_26293_26345[(2)] = inst_26164);

(statearr_26293_26345[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (30))){
var inst_26198 = (state_26239[(35)]);
var inst_26201 = fluree.db.query.schema.setting_map.call(null,inst_26198);
var state_26239__$1 = state_26239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26239__$1,(33),inst_26201);
} else {
if((state_val_26240 === (10))){
var inst_26089 = cljs.core.PersistentVector.EMPTY;
var state_26239__$1 = state_26239;
var statearr_26294_26346 = state_26239__$1;
(statearr_26294_26346[(2)] = inst_26089);

(statearr_26294_26346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (18))){
var inst_26160 = (state_26239[(21)]);
var inst_26171 = (state_26239[(32)]);
var inst_26170 = cljs.core.seq.call(null,inst_26160);
var inst_26171__$1 = cljs.core.first.call(null,inst_26170);
var inst_26172 = cljs.core.next.call(null,inst_26170);
var inst_26173 = cljs.core.not.call(null,inst_26171__$1);
var state_26239__$1 = (function (){var statearr_26295 = state_26239;
(statearr_26295[(17)] = inst_26172);

(statearr_26295[(32)] = inst_26171__$1);

return statearr_26295;
})();
if(inst_26173){
var statearr_26296_26347 = state_26239__$1;
(statearr_26296_26347[(1)] = (20));

} else {
var statearr_26297_26348 = state_26239__$1;
(statearr_26297_26348[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (37))){
var inst_26164 = (state_26239[(9)]);
var inst_26171 = (state_26239[(32)]);
var inst_26226 = cljs.core.conj.call(null,inst_26164,inst_26171);
var state_26239__$1 = state_26239;
var statearr_26298_26349 = state_26239__$1;
(statearr_26298_26349[(2)] = inst_26226);

(statearr_26298_26349[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26240 === (8))){
var inst_26051 = (state_26239[(23)]);
var inst_26076 = (state_26239[(24)]);
var inst_26066 = (state_26239[(25)]);
var inst_26068 = (state_26239[(28)]);
var inst_26082 = (state_26239[(11)]);
var inst_26072 = (state_26239[(34)]);
var inst_26066__$1 = (state_26239[(2)]);
var inst_26067 = (function (){var t = inst_26051;
var _ = inst_26066__$1;
return (function (p1__26041_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__26041_SHARP_.p));
});
})();
var inst_26068__$1 = cljs.core.filter.call(null,inst_26067,flakes);
var inst_26069 = cljs.core.PersistentHashSet.EMPTY;
var inst_26070 = (function (){var t = inst_26051;
var _ = inst_26066__$1;
var add_flakes = inst_26068__$1;
return (function (p1__26042_SHARP_){
return p1__26042_SHARP_.p;
});
})();
var inst_26071 = cljs.core.map.call(null,inst_26070,inst_26068__$1);
var inst_26072__$1 = cljs.core.into.call(null,inst_26069,inst_26071);
var inst_26073 = cljs.core.PersistentHashMap.EMPTY;
var inst_26074 = (function (){var t = inst_26051;
var _ = inst_26066__$1;
var add_flakes = inst_26068__$1;
var add_preds = inst_26072__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26075 = cljs.core.map.call(null,inst_26074,inst_26072__$1);
var inst_26076__$1 = cljs.core.into.call(null,inst_26073,inst_26075);
var inst_26077 = cljs.core.PersistentHashMap.EMPTY;
var inst_26078 = (function (){var t = inst_26051;
var _ = inst_26066__$1;
var add_flakes = inst_26068__$1;
var add_preds = inst_26072__$1;
var idx_QMARK__map = inst_26076__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26079 = cljs.core.map.call(null,inst_26078,inst_26072__$1);
var inst_26080 = cljs.core.into.call(null,inst_26077,inst_26079);
var inst_26081 = fluree.db.flake.size_bytes.call(null,inst_26068__$1);
var inst_26082__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_26068__$1);
var inst_26083 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_26068__$1);
var inst_26084 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26085 = cljs.core.get.call(null,inst_26084,(0));
var state_26239__$1 = (function (){var statearr_26299 = state_26239;
(statearr_26299[(24)] = inst_26076__$1);

(statearr_26299[(25)] = inst_26066__$1);

(statearr_26299[(28)] = inst_26068__$1);

(statearr_26299[(29)] = inst_26085);

(statearr_26299[(11)] = inst_26082__$1);

(statearr_26299[(12)] = inst_26081);

(statearr_26299[(30)] = inst_26083);

(statearr_26299[(31)] = inst_26080);

(statearr_26299[(34)] = inst_26072__$1);

return statearr_26299;
})();
if(cljs.core.truth_(inst_26082__$1)){
var statearr_26300_26350 = state_26239__$1;
(statearr_26300_26350[(1)] = (9));

} else {
var statearr_26301_26351 = state_26239__$1;
(statearr_26301_26351[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__2468__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__2468__auto____0 = (function (){
var statearr_26302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26302[(0)] = fluree$db$graphdb$with_t_$_state_machine__2468__auto__);

(statearr_26302[(1)] = (1));

return statearr_26302;
});
var fluree$db$graphdb$with_t_$_state_machine__2468__auto____1 = (function (state_26239){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26303){var ex__2471__auto__ = e26303;
var statearr_26304_26352 = state_26239;
(statearr_26304_26352[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26239[(4)]))){
var statearr_26305_26353 = state_26239;
(statearr_26305_26353[(1)] = cljs.core.first.call(null,(state_26239[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26354 = state_26239;
state_26239 = G__26354;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__2468__auto__ = function(state_26239){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__2468__auto____1.call(this,state_26239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__2468__auto____0;
fluree$db$graphdb$with_t_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__2468__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26306 = f__2491__auto__.call(null);
(statearr_26306[(6)] = c__2490__auto__);

return statearr_26306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2490__auto___26488 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26443){
var state_val_26444 = (state_26443[(1)]);
if((state_val_26444 === (7))){
var state_26443__$1 = state_26443;
var statearr_26445_26489 = state_26443__$1;
(statearr_26445_26489[(2)] = null);

(statearr_26445_26489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (20))){
var inst_26401 = (state_26443[(7)]);
var inst_26418 = (state_26443[(2)]);
var inst_26419 = fluree.db.util.async.throw_err.call(null,inst_26418);
var inst_26420 = (inst_26401 == null);
var state_26443__$1 = (function (){var statearr_26446 = state_26443;
(statearr_26446[(8)] = inst_26419);

return statearr_26446;
})();
if(cljs.core.truth_(inst_26420)){
var statearr_26447_26490 = state_26443__$1;
(statearr_26447_26490[(1)] = (21));

} else {
var statearr_26448_26491 = state_26443__$1;
(statearr_26448_26491[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (1))){
var state_26443__$1 = state_26443;
var statearr_26449_26492 = state_26443__$1;
(statearr_26449_26492[(2)] = null);

(statearr_26449_26492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (4))){
var inst_26355 = (state_26443[(2)]);
var inst_26356 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26355);
var state_26443__$1 = state_26443;
var statearr_26450_26493 = state_26443__$1;
(statearr_26450_26493[(2)] = inst_26356);

(statearr_26450_26493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (15))){
var state_26443__$1 = state_26443;
var statearr_26451_26494 = state_26443__$1;
(statearr_26451_26494[(1)] = (17));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (21))){
var inst_26419 = (state_26443[(8)]);
var inst_26422 = cljs.core.assoc.call(null,inst_26419,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26443__$1 = state_26443;
var statearr_26453_26495 = state_26443__$1;
(statearr_26453_26495[(2)] = inst_26422);

(statearr_26453_26495[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (13))){
var inst_26408 = (state_26443[(2)]);
var state_26443__$1 = state_26443;
if(cljs.core.truth_(inst_26408)){
var statearr_26454_26496 = state_26443__$1;
(statearr_26454_26496[(1)] = (14));

} else {
var statearr_26455_26497 = state_26443__$1;
(statearr_26455_26497[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (22))){
var inst_26401 = (state_26443[(7)]);
var inst_26402 = (state_26443[(9)]);
var inst_26419 = (state_26443[(8)]);
var inst_26424 = inst_26401.t;
var inst_26425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26426 = [inst_26401];
var inst_26427 = (new cljs.core.PersistentVector(null,1,(5),inst_26425,inst_26426,null));
var inst_26392 = inst_26402;
var inst_26393 = inst_26424;
var inst_26394 = inst_26427;
var inst_26395 = inst_26419;
var state_26443__$1 = (function (){var statearr_26456 = state_26443;
(statearr_26456[(10)] = inst_26394);

(statearr_26456[(11)] = inst_26393);

(statearr_26456[(12)] = inst_26392);

(statearr_26456[(13)] = inst_26395);

return statearr_26456;
})();
var statearr_26457_26498 = state_26443__$1;
(statearr_26457_26498[(2)] = null);

(statearr_26457_26498[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (6))){
var inst_26366 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26367 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26368 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26366)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26367)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26369 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26370 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26371 = cljs.core.PersistentHashMap.fromArrays(inst_26369,inst_26370);
var inst_26372 = cljs.core.ex_info.call(null,inst_26368,inst_26371);
var inst_26373 = (function(){throw inst_26372})();
var state_26443__$1 = state_26443;
var statearr_26458_26499 = state_26443__$1;
(statearr_26458_26499[(2)] = inst_26373);

(statearr_26458_26499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (17))){
var inst_26394 = (state_26443[(10)]);
var inst_26393 = (state_26443[(11)]);
var inst_26395 = (state_26443[(13)]);
var inst_26414 = (inst_26393 + (1));
var inst_26415 = cljs.core.assoc.call(null,inst_26395,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26414);
var inst_26416 = fluree.db.graphdb.with_t.call(null,inst_26415,inst_26394);
var state_26443__$1 = state_26443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26443__$1,(20),inst_26416);
} else {
if((state_val_26444 === (3))){
var inst_26441 = (state_26443[(2)]);
var state_26443__$1 = state_26443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26443__$1,inst_26441);
} else {
if((state_val_26444 === (12))){
var inst_26401 = (state_26443[(7)]);
var state_26443__$1 = state_26443;
var statearr_26459_26500 = state_26443__$1;
(statearr_26459_26500[(2)] = inst_26401);

(statearr_26459_26500[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (2))){
var _ = (function (){var statearr_26460 = state_26443;
(statearr_26460[(4)] = cljs.core.cons.call(null,(5),(state_26443[(4)])));

return statearr_26460;
})();
var inst_26362 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26363 = (inst_26362 + (1));
var inst_26364 = cljs.core.not_EQ_.call(null,block,inst_26363);
var state_26443__$1 = state_26443;
if(inst_26364){
var statearr_26461_26501 = state_26443__$1;
(statearr_26461_26501[(1)] = (6));

} else {
var statearr_26462_26502 = state_26443__$1;
(statearr_26462_26502[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (23))){
var inst_26430 = (state_26443[(2)]);
var state_26443__$1 = state_26443;
var statearr_26463_26503 = state_26443__$1;
(statearr_26463_26503[(2)] = inst_26430);

(statearr_26463_26503[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (19))){
var inst_26433 = (state_26443[(2)]);
var state_26443__$1 = state_26443;
var statearr_26464_26504 = state_26443__$1;
(statearr_26464_26504[(2)] = inst_26433);

(statearr_26464_26504[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (11))){
var inst_26401 = (state_26443[(7)]);
var inst_26393 = (state_26443[(11)]);
var inst_26404 = inst_26401.t;
var inst_26405 = cljs.core._EQ_.call(null,inst_26393,inst_26404);
var state_26443__$1 = state_26443;
var statearr_26466_26505 = state_26443__$1;
(statearr_26466_26505[(2)] = inst_26405);

(statearr_26466_26505[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (9))){
var inst_26401 = (state_26443[(7)]);
var inst_26392 = (state_26443[(12)]);
var inst_26400 = cljs.core.seq.call(null,inst_26392);
var inst_26401__$1 = cljs.core.first.call(null,inst_26400);
var inst_26402 = cljs.core.next.call(null,inst_26400);
var state_26443__$1 = (function (){var statearr_26469 = state_26443;
(statearr_26469[(7)] = inst_26401__$1);

(statearr_26469[(9)] = inst_26402);

return statearr_26469;
})();
if(cljs.core.truth_(inst_26401__$1)){
var statearr_26470_26506 = state_26443__$1;
(statearr_26470_26506[(1)] = (11));

} else {
var statearr_26471_26507 = state_26443__$1;
(statearr_26471_26507[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (5))){
var _ = (function (){var statearr_26472 = state_26443;
(statearr_26472[(4)] = cljs.core.rest.call(null,(state_26443[(4)])));

return statearr_26472;
})();
var state_26443__$1 = state_26443;
var ex26465 = (state_26443__$1[(2)]);
var statearr_26473_26508 = state_26443__$1;
(statearr_26473_26508[(5)] = ex26465);


if((ex26465 instanceof java.lang.Exception)){
var statearr_26474_26509 = state_26443__$1;
(statearr_26474_26509[(1)] = (4));

(statearr_26474_26509[(5)] = null);

} else {
throw ex26465;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (14))){
var inst_26394 = (state_26443[(10)]);
var inst_26401 = (state_26443[(7)]);
var inst_26402 = (state_26443[(9)]);
var inst_26393 = (state_26443[(11)]);
var inst_26395 = (state_26443[(13)]);
var inst_26410 = cljs.core.conj.call(null,inst_26394,inst_26401);
var tmp26467 = inst_26393;
var tmp26468 = inst_26395;
var inst_26392 = inst_26402;
var inst_26393__$1 = tmp26467;
var inst_26394__$1 = inst_26410;
var inst_26395__$1 = tmp26468;
var state_26443__$1 = (function (){var statearr_26475 = state_26443;
(statearr_26475[(10)] = inst_26394__$1);

(statearr_26475[(11)] = inst_26393__$1);

(statearr_26475[(12)] = inst_26392);

(statearr_26475[(13)] = inst_26395__$1);

return statearr_26475;
})();
var statearr_26476_26510 = state_26443__$1;
(statearr_26476_26510[(2)] = null);

(statearr_26476_26510[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (16))){
var inst_26435 = (state_26443[(2)]);
var state_26443__$1 = state_26443;
var statearr_26477_26511 = state_26443__$1;
(statearr_26477_26511[(2)] = inst_26435);

(statearr_26477_26511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (10))){
var inst_26437 = (state_26443[(2)]);
var inst_26438 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26437);
var _ = (function (){var statearr_26478 = state_26443;
(statearr_26478[(4)] = cljs.core.rest.call(null,(state_26443[(4)])));

return statearr_26478;
})();
var state_26443__$1 = state_26443;
var statearr_26479_26512 = state_26443__$1;
(statearr_26479_26512[(2)] = inst_26438);

(statearr_26479_26512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (18))){
var state_26443__$1 = state_26443;
var statearr_26480_26513 = state_26443__$1;
(statearr_26480_26513[(2)] = null);

(statearr_26480_26513[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26444 === (8))){
var inst_26376 = (state_26443[(2)]);
var inst_26377 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26385 = cljs.core.seq.call(null,inst_26377);
var inst_26386 = cljs.core.first.call(null,inst_26385);
var inst_26387 = cljs.core.next.call(null,inst_26385);
var inst_26388 = cljs.core.first.call(null,inst_26377);
var inst_26389 = inst_26388.t;
var inst_26390 = cljs.core.PersistentVector.EMPTY;
var inst_26391 = db;
var inst_26392 = inst_26377;
var inst_26393 = inst_26389;
var inst_26394 = inst_26390;
var inst_26395 = inst_26391;
var state_26443__$1 = (function (){var statearr_26481 = state_26443;
(statearr_26481[(10)] = inst_26394);

(statearr_26481[(14)] = inst_26386);

(statearr_26481[(15)] = inst_26387);

(statearr_26481[(16)] = inst_26376);

(statearr_26481[(11)] = inst_26393);

(statearr_26481[(12)] = inst_26392);

(statearr_26481[(13)] = inst_26395);

return statearr_26481;
})();
var statearr_26482_26514 = state_26443__$1;
(statearr_26482_26514[(2)] = null);

(statearr_26482_26514[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__2468__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__2468__auto____0 = (function (){
var statearr_26483 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26483[(0)] = fluree$db$graphdb$with_$_state_machine__2468__auto__);

(statearr_26483[(1)] = (1));

return statearr_26483;
});
var fluree$db$graphdb$with_$_state_machine__2468__auto____1 = (function (state_26443){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26484){var ex__2471__auto__ = e26484;
var statearr_26485_26515 = state_26443;
(statearr_26485_26515[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26443[(4)]))){
var statearr_26486_26516 = state_26443;
(statearr_26486_26516[(1)] = cljs.core.first.call(null,(state_26443[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26517 = state_26443;
state_26443 = G__26517;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__2468__auto__ = function(state_26443){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__2468__auto____1.call(this,state_26443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__2468__auto____0;
fluree$db$graphdb$with_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__2468__auto____1;
return fluree$db$graphdb$with_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26487 = f__2491__auto__.call(null);
(statearr_26487[(6)] = c__2490__auto___26488);

return statearr_26487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26573){
var state_val_26574 = (state_26573[(1)]);
if((state_val_26574 === (7))){
var state_26573__$1 = state_26573;
var statearr_26575_26602 = state_26573__$1;
(statearr_26575_26602[(2)] = tt_id);

(statearr_26575_26602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (1))){
var state_26573__$1 = state_26573;
var statearr_26576_26603 = state_26573__$1;
(statearr_26576_26603[(2)] = null);

(statearr_26576_26603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (4))){
var inst_26518 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26577_26604 = state_26573__$1;
(statearr_26577_26604[(2)] = inst_26518);

(statearr_26577_26604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (13))){
var inst_26566 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26578_26605 = state_26573__$1;
(statearr_26578_26605[(2)] = inst_26566);

(statearr_26578_26605[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (6))){
var inst_26526 = fluree.db.util.core.random_uuid.call(null);
var state_26573__$1 = state_26573;
var statearr_26579_26606 = state_26573__$1;
(statearr_26579_26606[(2)] = inst_26526);

(statearr_26579_26606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (3))){
var inst_26571 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26573__$1,inst_26571);
} else {
if((state_val_26574 === (12))){
var inst_26549 = (state_26573[(7)]);
var state_26573__$1 = state_26573;
var statearr_26580_26607 = state_26573__$1;
(statearr_26580_26607[(2)] = inst_26549);

(statearr_26580_26607[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (2))){
var _ = (function (){var statearr_26581 = state_26573;
(statearr_26581[(4)] = cljs.core.cons.call(null,(5),(state_26573[(4)])));

return statearr_26581;
})();
var inst_26524 = (tt_id == null);
var state_26573__$1 = state_26573;
if(cljs.core.truth_(inst_26524)){
var statearr_26582_26608 = state_26573__$1;
(statearr_26582_26608[(1)] = (6));

} else {
var statearr_26583_26609 = state_26573__$1;
(statearr_26583_26609[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (11))){
var inst_26556 = (state_26573[(8)]);
var inst_26549 = (state_26573[(7)]);
var inst_26559 = fluree.db.graphdb.with_t.call(null,inst_26549,inst_26556);
var state_26573__$1 = state_26573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26573__$1,(14),inst_26559);
} else {
if((state_val_26574 === (9))){
var inst_26556 = (state_26573[(8)]);
var inst_26550 = (state_26573[(9)]);
var inst_26555 = cljs.core.seq.call(null,inst_26550);
var inst_26556__$1 = cljs.core.first.call(null,inst_26555);
var inst_26557 = cljs.core.next.call(null,inst_26555);
var state_26573__$1 = (function (){var statearr_26585 = state_26573;
(statearr_26585[(8)] = inst_26556__$1);

(statearr_26585[(10)] = inst_26557);

return statearr_26585;
})();
if(cljs.core.truth_(inst_26556__$1)){
var statearr_26586_26610 = state_26573__$1;
(statearr_26586_26610[(1)] = (11));

} else {
var statearr_26587_26611 = state_26573__$1;
(statearr_26587_26611[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (5))){
var _ = (function (){var statearr_26588 = state_26573;
(statearr_26588[(4)] = cljs.core.rest.call(null,(state_26573[(4)])));

return statearr_26588;
})();
var state_26573__$1 = state_26573;
var ex26584 = (state_26573__$1[(2)]);
var statearr_26589_26612 = state_26573__$1;
(statearr_26589_26612[(5)] = ex26584);


if((ex26584 instanceof Error)){
var statearr_26590_26613 = state_26573__$1;
(statearr_26590_26613[(1)] = (4));

(statearr_26590_26613[(5)] = null);

} else {
throw ex26584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (14))){
var inst_26557 = (state_26573[(10)]);
var inst_26561 = (state_26573[(2)]);
var inst_26562 = fluree.db.util.async.throw_err.call(null,inst_26561);
var inst_26549 = inst_26562;
var inst_26550 = inst_26557;
var state_26573__$1 = (function (){var statearr_26591 = state_26573;
(statearr_26591[(7)] = inst_26549);

(statearr_26591[(9)] = inst_26550);

return statearr_26591;
})();
var statearr_26592_26614 = state_26573__$1;
(statearr_26592_26614[(2)] = null);

(statearr_26592_26614[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (10))){
var inst_26568 = (state_26573[(2)]);
var _ = (function (){var statearr_26593 = state_26573;
(statearr_26593[(4)] = cljs.core.rest.call(null,(state_26573[(4)])));

return statearr_26593;
})();
var state_26573__$1 = state_26573;
var statearr_26594_26615 = state_26573__$1;
(statearr_26594_26615[(2)] = inst_26568);

(statearr_26594_26615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (8))){
var inst_26529 = (state_26573[(2)]);
var inst_26530 = (function (){var tt_id_SINGLEQUOTE_ = inst_26529;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26531 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26529);
var inst_26532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26533 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26534 = (new cljs.core.PersistentVector(null,4,(5),inst_26532,inst_26533,null));
var inst_26535 = cljs.core.reduce.call(null,inst_26530,inst_26531,inst_26534);
var inst_26536 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26537 = cljs.core.reverse.call(null,inst_26536);
var inst_26538 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26537);
var inst_26546 = cljs.core.seq.call(null,inst_26538);
var inst_26547 = cljs.core.first.call(null,inst_26546);
var inst_26548 = cljs.core.next.call(null,inst_26546);
var inst_26549 = inst_26535;
var inst_26550 = inst_26538;
var state_26573__$1 = (function (){var statearr_26595 = state_26573;
(statearr_26595[(11)] = inst_26547);

(statearr_26595[(7)] = inst_26549);

(statearr_26595[(12)] = inst_26548);

(statearr_26595[(9)] = inst_26550);

return statearr_26595;
})();
var statearr_26596_26616 = state_26573__$1;
(statearr_26596_26616[(2)] = null);

(statearr_26596_26616[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto____0 = (function (){
var statearr_26597 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26597[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto__);

(statearr_26597[(1)] = (1));

return statearr_26597;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto____1 = (function (state_26573){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26598){var ex__2471__auto__ = e26598;
var statearr_26599_26617 = state_26573;
(statearr_26599_26617[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26573[(4)]))){
var statearr_26600_26618 = state_26573;
(statearr_26600_26618[(1)] = cljs.core.first.call(null,(state_26573[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26619 = state_26573;
state_26573 = G__26619;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto__ = function(state_26573){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto____1.call(this,state_26573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26601 = f__2491__auto__.call(null);
(statearr_26601[(6)] = c__2490__auto__);

return statearr_26601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2490__auto___26797 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26734){
var state_val_26735 = (state_26734[(1)]);
if((state_val_26735 === (7))){
var inst_26647 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var inst_26648 = cljs.core.first.call(null,ident);
var inst_26649 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26648);
var inst_26650 = (inst_26649 == null);
var inst_26651 = ((inst_26647) && (inst_26650));
var state_26734__$1 = state_26734;
if(cljs.core.truth_(inst_26651)){
var statearr_26736_26798 = state_26734__$1;
(statearr_26736_26798[(1)] = (13));

} else {
var statearr_26737_26799 = state_26734__$1;
(statearr_26737_26799[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (20))){
var state_26734__$1 = state_26734;
var statearr_26738_26800 = state_26734__$1;
(statearr_26738_26800[(2)] = null);

(statearr_26738_26800[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (27))){
var state_26734__$1 = state_26734;
var statearr_26739_26801 = state_26734__$1;
(statearr_26739_26801[(2)] = null);

(statearr_26739_26801[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (1))){
var state_26734__$1 = state_26734;
var statearr_26740_26802 = state_26734__$1;
(statearr_26740_26802[(2)] = null);

(statearr_26740_26802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (24))){
var inst_26680 = (state_26734[(7)]);
var inst_26684 = inst_26680.s;
var state_26734__$1 = state_26734;
var statearr_26741_26803 = state_26734__$1;
(statearr_26741_26803[(2)] = inst_26684);

(statearr_26741_26803[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (39))){
var state_26734__$1 = state_26734;
var statearr_26742_26804 = state_26734__$1;
(statearr_26742_26804[(2)] = null);

(statearr_26742_26804[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (4))){
var inst_26620 = (state_26734[(2)]);
var inst_26621 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26622 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26623 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26624 = cljs.core.PersistentHashMap.fromArrays(inst_26622,inst_26623);
var inst_26625 = cljs.core.ex_info.call(null,inst_26621,inst_26624,inst_26620);
var inst_26626 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26625);
var state_26734__$1 = state_26734;
var statearr_26743_26805 = state_26734__$1;
(statearr_26743_26805[(2)] = inst_26626);

(statearr_26743_26805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (15))){
var inst_26702 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26744_26806 = state_26734__$1;
(statearr_26744_26806[(2)] = inst_26702);

(statearr_26744_26806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (21))){
var inst_26674 = (state_26734[(8)]);
var inst_26678 = cljs.core.first.call(null,inst_26674);
var state_26734__$1 = state_26734;
var statearr_26745_26807 = state_26734__$1;
(statearr_26745_26807[(2)] = inst_26678);

(statearr_26745_26807[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (31))){
var inst_26729 = (state_26734[(2)]);
var _ = (function (){var statearr_26746 = state_26734;
(statearr_26746[(4)] = cljs.core.rest.call(null,(state_26734[(4)])));

return statearr_26746;
})();
var state_26734__$1 = state_26734;
var statearr_26747_26808 = state_26734__$1;
(statearr_26747_26808[(2)] = inst_26729);

(statearr_26747_26808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (32))){
var state_26734__$1 = state_26734;
var statearr_26748_26809 = state_26734__$1;
(statearr_26748_26809[(2)] = strict_QMARK_);

(statearr_26748_26809[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (40))){
var inst_26725 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26749_26810 = state_26734__$1;
(statearr_26749_26810[(2)] = inst_26725);

(statearr_26749_26810[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (33))){
var state_26734__$1 = state_26734;
var statearr_26750_26811 = state_26734__$1;
(statearr_26750_26811[(2)] = false);

(statearr_26750_26811[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (13))){
var inst_26653 = cljs.core.first.call(null,ident);
var inst_26654 = cljs.core.pr_str.call(null,inst_26653);
var inst_26655 = ["Subject ID lookup failed. The predicate ",inst_26654," does not exist."].join('');
var inst_26656 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26657 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26658 = cljs.core.PersistentHashMap.fromArrays(inst_26656,inst_26657);
var inst_26659 = cljs.core.ex_info.call(null,inst_26655,inst_26658);
var inst_26660 = (function(){throw inst_26659})();
var state_26734__$1 = state_26734;
var statearr_26751_26812 = state_26734__$1;
(statearr_26751_26812[(2)] = inst_26660);

(statearr_26751_26812[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (22))){
var inst_26680 = (state_26734[(7)]);
var inst_26680__$1 = (state_26734[(2)]);
var inst_26681 = (inst_26680__$1 == null);
var state_26734__$1 = (function (){var statearr_26752 = state_26734;
(statearr_26752[(7)] = inst_26680__$1);

return statearr_26752;
})();
if(cljs.core.truth_(inst_26681)){
var statearr_26753_26813 = state_26734__$1;
(statearr_26753_26813[(1)] = (23));

} else {
var statearr_26754_26814 = state_26734__$1;
(statearr_26754_26814[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (36))){
var state_26734__$1 = state_26734;
var statearr_26755_26815 = state_26734__$1;
(statearr_26755_26815[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (29))){
var inst_26704 = (state_26734[(9)]);
var inst_26706 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26704);
var state_26734__$1 = state_26734;
var statearr_26757_26816 = state_26734__$1;
(statearr_26757_26816[(2)] = inst_26706);

(statearr_26757_26816[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (6))){
var inst_26634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26635 = [ident];
var inst_26636 = (new cljs.core.PersistentVector(null,1,(5),inst_26634,inst_26635,null));
var inst_26637 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26636);
var state_26734__$1 = state_26734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26734__$1,(9),inst_26637);
} else {
if((state_val_26735 === (28))){
var inst_26698 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26758_26817 = state_26734__$1;
(statearr_26758_26817[(2)] = inst_26698);

(statearr_26758_26817[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (25))){
var inst_26686 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26759_26818 = state_26734__$1;
(statearr_26759_26818[(2)] = inst_26686);

(statearr_26759_26818[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (34))){
var inst_26712 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
if(cljs.core.truth_(inst_26712)){
var statearr_26760_26819 = state_26734__$1;
(statearr_26760_26819[(1)] = (35));

} else {
var statearr_26761_26820 = state_26734__$1;
(statearr_26761_26820[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (17))){
var state_26734__$1 = state_26734;
var statearr_26762_26821 = state_26734__$1;
(statearr_26762_26821[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (3))){
var inst_26732 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26734__$1,inst_26732);
} else {
if((state_val_26735 === (12))){
var inst_26645 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26764_26822 = state_26734__$1;
(statearr_26764_26822[(2)] = inst_26645);

(statearr_26764_26822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (2))){
var _ = (function (){var statearr_26765 = state_26734;
(statearr_26765[(4)] = cljs.core.cons.call(null,(5),(state_26734[(4)])));

return statearr_26765;
})();
var inst_26632 = typeof ident === 'number';
var state_26734__$1 = state_26734;
if(cljs.core.truth_(inst_26632)){
var statearr_26766_26823 = state_26734__$1;
(statearr_26766_26823[(1)] = (6));

} else {
var statearr_26767_26824 = state_26734__$1;
(statearr_26767_26824[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (23))){
var state_26734__$1 = state_26734;
var statearr_26768_26825 = state_26734__$1;
(statearr_26768_26825[(2)] = null);

(statearr_26768_26825[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (35))){
var inst_26714 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26715 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26716 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26717 = cljs.core.PersistentHashMap.fromArrays(inst_26715,inst_26716);
var inst_26718 = cljs.core.ex_info.call(null,inst_26714,inst_26717);
var inst_26719 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26718);
var state_26734__$1 = state_26734;
var statearr_26769_26826 = state_26734__$1;
(statearr_26769_26826[(2)] = inst_26719);

(statearr_26769_26826[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (19))){
var inst_26674 = (state_26734[(8)]);
var inst_26673 = (state_26734[(2)]);
var inst_26674__$1 = fluree.db.util.async.throw_err.call(null,inst_26673);
var inst_26675 = (inst_26674__$1 == null);
var state_26734__$1 = (function (){var statearr_26770 = state_26734;
(statearr_26770[(8)] = inst_26674__$1);

return statearr_26770;
})();
if(cljs.core.truth_(inst_26675)){
var statearr_26771_26827 = state_26734__$1;
(statearr_26771_26827[(1)] = (20));

} else {
var statearr_26772_26828 = state_26734__$1;
(statearr_26772_26828[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (11))){
var state_26734__$1 = state_26734;
var statearr_26774_26829 = state_26734__$1;
(statearr_26774_26829[(2)] = null);

(statearr_26774_26829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (9))){
var inst_26639 = (state_26734[(2)]);
var inst_26640 = fluree.db.util.async.throw_err.call(null,inst_26639);
var inst_26641 = cljs.core.not_empty.call(null,inst_26640);
var state_26734__$1 = state_26734;
if(cljs.core.truth_(inst_26641)){
var statearr_26775_26830 = state_26734__$1;
(statearr_26775_26830[(1)] = (10));

} else {
var statearr_26776_26831 = state_26734__$1;
(statearr_26776_26831[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (5))){
var _ = (function (){var statearr_26777 = state_26734;
(statearr_26777[(4)] = cljs.core.rest.call(null,(state_26734[(4)])));

return statearr_26777;
})();
var state_26734__$1 = state_26734;
var ex26773 = (state_26734__$1[(2)]);
var statearr_26778_26832 = state_26734__$1;
(statearr_26778_26832[(5)] = ex26773);


if((ex26773 instanceof java.lang.Exception)){
var statearr_26779_26833 = state_26734__$1;
(statearr_26779_26833[(1)] = (4));

(statearr_26779_26833[(5)] = null);

} else {
throw ex26773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (14))){
var inst_26662 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26734__$1 = state_26734;
if(inst_26662){
var statearr_26780_26834 = state_26734__$1;
(statearr_26780_26834[(1)] = (16));

} else {
var statearr_26781_26835 = state_26734__$1;
(statearr_26781_26835[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (26))){
var inst_26689 = cljs.core.pr_str.call(null,ident);
var inst_26690 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26689].join('');
var inst_26691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26692 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26693 = cljs.core.PersistentHashMap.fromArrays(inst_26691,inst_26692);
var inst_26694 = cljs.core.ex_info.call(null,inst_26690,inst_26693);
var inst_26695 = (function(){throw inst_26694})();
var state_26734__$1 = state_26734;
var statearr_26782_26836 = state_26734__$1;
(statearr_26782_26836[(2)] = inst_26695);

(statearr_26782_26836[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (16))){
var inst_26665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26666 = cljs.core.first.call(null,ident);
var inst_26667 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26666);
var inst_26668 = cljs.core.second.call(null,ident);
var inst_26669 = [inst_26667,inst_26668];
var inst_26670 = (new cljs.core.PersistentVector(null,2,(5),inst_26665,inst_26669,null));
var inst_26671 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26670);
var state_26734__$1 = state_26734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26734__$1,(19),inst_26671);
} else {
if((state_val_26735 === (38))){
var inst_26722 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26734__$1 = state_26734;
var statearr_26783_26837 = state_26734__$1;
(statearr_26783_26837[(2)] = inst_26722);

(statearr_26783_26837[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (30))){
var inst_26704 = (state_26734[(9)]);
var inst_26708 = (inst_26704 == null);
var state_26734__$1 = state_26734;
if(cljs.core.truth_(inst_26708)){
var statearr_26784_26838 = state_26734__$1;
(statearr_26784_26838[(1)] = (32));

} else {
var statearr_26785_26839 = state_26734__$1;
(statearr_26785_26839[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (10))){
var state_26734__$1 = state_26734;
var statearr_26786_26840 = state_26734__$1;
(statearr_26786_26840[(2)] = ident);

(statearr_26786_26840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (18))){
var inst_26700 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26787_26841 = state_26734__$1;
(statearr_26787_26841[(2)] = inst_26700);

(statearr_26787_26841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (37))){
var inst_26727 = (state_26734[(2)]);
var state_26734__$1 = state_26734;
var statearr_26788_26842 = state_26734__$1;
(statearr_26788_26842[(2)] = inst_26727);

(statearr_26788_26842[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26735 === (8))){
var inst_26704 = (state_26734[(9)]);
var inst_26704__$1 = (state_26734[(2)]);
var state_26734__$1 = (function (){var statearr_26789 = state_26734;
(statearr_26789[(9)] = inst_26704__$1);

return statearr_26789;
})();
if(cljs.core.truth_(inst_26704__$1)){
var statearr_26790_26843 = state_26734__$1;
(statearr_26790_26843[(1)] = (29));

} else {
var statearr_26791_26844 = state_26734__$1;
(statearr_26791_26844[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2468__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2468__auto____0 = (function (){
var statearr_26792 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26792[(0)] = fluree$db$graphdb$subid_$_state_machine__2468__auto__);

(statearr_26792[(1)] = (1));

return statearr_26792;
});
var fluree$db$graphdb$subid_$_state_machine__2468__auto____1 = (function (state_26734){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26793){var ex__2471__auto__ = e26793;
var statearr_26794_26845 = state_26734;
(statearr_26794_26845[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26734[(4)]))){
var statearr_26795_26846 = state_26734;
(statearr_26795_26846[(1)] = cljs.core.first.call(null,(state_26734[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26847 = state_26734;
state_26734 = G__26847;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2468__auto__ = function(state_26734){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2468__auto____1.call(this,state_26734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2468__auto____0;
fluree$db$graphdb$subid_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2468__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26796 = f__2491__auto__.call(null);
(statearr_26796[(6)] = c__2490__auto___26797);

return statearr_26796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k26849,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__26853 = k26849;
var G__26853__$1 = (((G__26853 instanceof cljs.core.Keyword))?G__26853.fqn:null);
switch (G__26853__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26849,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__26854){
var vec__26855 = p__26854;
var k__4403__auto__ = cljs.core.nth.call(null,vec__26855,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__26855,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26848){
var self__ = this;
var G__26848__$1 = this;
return (new cljs.core.RecordIter((0),G__26848__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26850,other26851){
var self__ = this;
var this26850__$1 = this;
return (((!((other26851 == null)))) && ((this26850__$1.constructor === other26851.constructor)) && (cljs.core._EQ_.call(null,this26850__$1.conn,other26851.conn)) && (cljs.core._EQ_.call(null,this26850__$1.network,other26851.network)) && (cljs.core._EQ_.call(null,this26850__$1.dbid,other26851.dbid)) && (cljs.core._EQ_.call(null,this26850__$1.block,other26851.block)) && (cljs.core._EQ_.call(null,this26850__$1.t,other26851.t)) && (cljs.core._EQ_.call(null,this26850__$1.tt_id,other26851.tt_id)) && (cljs.core._EQ_.call(null,this26850__$1.stats,other26851.stats)) && (cljs.core._EQ_.call(null,this26850__$1.spot,other26851.spot)) && (cljs.core._EQ_.call(null,this26850__$1.psot,other26851.psot)) && (cljs.core._EQ_.call(null,this26850__$1.post,other26851.post)) && (cljs.core._EQ_.call(null,this26850__$1.opst,other26851.opst)) && (cljs.core._EQ_.call(null,this26850__$1.schema,other26851.schema)) && (cljs.core._EQ_.call(null,this26850__$1.settings,other26851.settings)) && (cljs.core._EQ_.call(null,this26850__$1.index_configs,other26851.index_configs)) && (cljs.core._EQ_.call(null,this26850__$1.schema_cache,other26851.schema_cache)) && (cljs.core._EQ_.call(null,this26850__$1.novelty,other26851.novelty)) && (cljs.core._EQ_.call(null,this26850__$1.permissions,other26851.permissions)) && (cljs.core._EQ_.call(null,this26850__$1.fork,other26851.fork)) && (cljs.core._EQ_.call(null,this26850__$1.fork_block,other26851.fork_block)) && (cljs.core._EQ_.call(null,this26850__$1.current_db_fn,other26851.current_db_fn)) && (cljs.core._EQ_.call(null,this26850__$1.__extmap,other26851.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__26848){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__26858 = cljs.core.keyword_identical_QMARK_;
var expr__26859 = k__4388__auto__;
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26859))){
return (new fluree.db.graphdb.GraphDb(G__26848,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__26848,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__26848,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__26848,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__26848,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__26848,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__26848,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__26848,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__26848,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__26848,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__26848,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__26848,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__26848,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__26848,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__26848,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__26848,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__26848,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__26848,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__26848,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26858.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__26859))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__26848,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__26848),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__26848){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__26848,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26876){
var state_val_26877 = (state_26876[(1)]);
if((state_val_26877 === (1))){
var state_26876__$1 = state_26876;
var statearr_26878_27141 = state_26876__$1;
(statearr_26878_27141[(2)] = null);

(statearr_26878_27141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26877 === (2))){
var _ = (function (){var statearr_26879 = state_26876;
(statearr_26879[(4)] = cljs.core.cons.call(null,(5),(state_26876[(4)])));

return statearr_26879;
})();
var inst_26867 = self__.current_db_fn.call(null);
var state_26876__$1 = state_26876;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26876__$1,(6),inst_26867);
} else {
if((state_val_26877 === (3))){
var inst_26874 = (state_26876[(2)]);
var state_26876__$1 = state_26876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26876__$1,inst_26874);
} else {
if((state_val_26877 === (4))){
var inst_26861 = (state_26876[(2)]);
var state_26876__$1 = state_26876;
var statearr_26881_27142 = state_26876__$1;
(statearr_26881_27142[(2)] = inst_26861);

(statearr_26881_27142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26877 === (5))){
var _ = (function (){var statearr_26882 = state_26876;
(statearr_26882[(4)] = cljs.core.rest.call(null,(state_26876[(4)])));

return statearr_26882;
})();
var state_26876__$1 = state_26876;
var ex26880 = (state_26876__$1[(2)]);
var statearr_26883_27143 = state_26876__$1;
(statearr_26883_27143[(5)] = ex26880);


if((ex26880 instanceof Error)){
var statearr_26884_27144 = state_26876__$1;
(statearr_26884_27144[(1)] = (4));

(statearr_26884_27144[(5)] = null);

} else {
throw ex26880;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26877 === (6))){
var inst_26869 = (state_26876[(2)]);
var inst_26870 = fluree.db.util.async.throw_err.call(null,inst_26869);
var inst_26871 = cljs.core.assoc.call(null,inst_26870,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_26885 = state_26876;
(statearr_26885[(4)] = cljs.core.rest.call(null,(state_26876[(4)])));

return statearr_26885;
})();
var state_26876__$1 = state_26876;
var statearr_26886_27145 = state_26876__$1;
(statearr_26886_27145[(2)] = inst_26871);

(statearr_26886_27145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2468__auto__ = null;
var fluree$db$graphdb$state_machine__2468__auto____0 = (function (){
var statearr_26887 = [null,null,null,null,null,null,null];
(statearr_26887[(0)] = fluree$db$graphdb$state_machine__2468__auto__);

(statearr_26887[(1)] = (1));

return statearr_26887;
});
var fluree$db$graphdb$state_machine__2468__auto____1 = (function (state_26876){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26888){var ex__2471__auto__ = e26888;
var statearr_26889_27146 = state_26876;
(statearr_26889_27146[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26876[(4)]))){
var statearr_26890_27147 = state_26876;
(statearr_26890_27147[(1)] = cljs.core.first.call(null,(state_26876[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27148 = state_26876;
state_26876 = G__27148;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2468__auto__ = function(state_26876){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2468__auto____1.call(this,state_26876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2468__auto____0;
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2468__auto____1;
return fluree$db$graphdb$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26891 = f__2491__auto__.call(null);
(statearr_26891[(6)] = c__2490__auto__);

return statearr_26891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__26892 = cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__26892);
} else {
return G__26892;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26924){
var state_val_26925 = (state_26924[(1)]);
if((state_val_26925 === (7))){
var state_26924__$1 = state_26924;
var statearr_26926_27149 = state_26924__$1;
(statearr_26926_27149[(2)] = null);

(statearr_26926_27149[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (1))){
var state_26924__$1 = state_26924;
var statearr_26927_27150 = state_26924__$1;
(statearr_26927_27150[(2)] = null);

(statearr_26927_27150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (4))){
var inst_26893 = (state_26924[(2)]);
var state_26924__$1 = state_26924;
var statearr_26928_27151 = state_26924__$1;
(statearr_26928_27151[(2)] = inst_26893);

(statearr_26928_27151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (6))){
var inst_26907 = (state_26924[(7)]);
var inst_26906 = (state_26924[(2)]);
var inst_26907__$1 = fluree.db.util.async.throw_err.call(null,inst_26906);
var inst_26908 = (inst_26907__$1 == null);
var state_26924__$1 = (function (){var statearr_26929 = state_26924;
(statearr_26929[(7)] = inst_26907__$1);

return statearr_26929;
})();
if(cljs.core.truth_(inst_26908)){
var statearr_26930_27152 = state_26924__$1;
(statearr_26930_27152[(1)] = (7));

} else {
var statearr_26931_27153 = state_26924__$1;
(statearr_26931_27153[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (3))){
var inst_26922 = (state_26924[(2)]);
var state_26924__$1 = state_26924;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26924__$1,inst_26922);
} else {
if((state_val_26925 === (12))){
var inst_26919 = (state_26924[(2)]);
var _ = (function (){var statearr_26932 = state_26924;
(statearr_26932[(4)] = cljs.core.rest.call(null,(state_26924[(4)])));

return statearr_26932;
})();
var state_26924__$1 = state_26924;
var statearr_26933_27154 = state_26924__$1;
(statearr_26933_27154[(2)] = inst_26919);

(statearr_26933_27154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (2))){
var _ = (function (){var statearr_26934 = state_26924;
(statearr_26934[(4)] = cljs.core.cons.call(null,(5),(state_26924[(4)])));

return statearr_26934;
})();
var inst_26900 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_26901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26902 = [tag_id,(30)];
var inst_26903 = (new cljs.core.PersistentVector(null,2,(5),inst_26901,inst_26902,null));
var inst_26904 = fluree.db.query.range.index_range.call(null,inst_26900,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26903);
var state_26924__$1 = state_26924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26924__$1,(6),inst_26904);
} else {
if((state_val_26925 === (11))){
var inst_26913 = (state_26924[(8)]);
var inst_26917 = inst_26913.o;
var state_26924__$1 = state_26924;
var statearr_26936_27155 = state_26924__$1;
(statearr_26936_27155[(2)] = inst_26917);

(statearr_26936_27155[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (9))){
var inst_26913 = (state_26924[(8)]);
var inst_26913__$1 = (state_26924[(2)]);
var inst_26914 = (inst_26913__$1 == null);
var state_26924__$1 = (function (){var statearr_26937 = state_26924;
(statearr_26937[(8)] = inst_26913__$1);

return statearr_26937;
})();
if(cljs.core.truth_(inst_26914)){
var statearr_26938_27156 = state_26924__$1;
(statearr_26938_27156[(1)] = (10));

} else {
var statearr_26939_27157 = state_26924__$1;
(statearr_26939_27157[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (5))){
var _ = (function (){var statearr_26940 = state_26924;
(statearr_26940[(4)] = cljs.core.rest.call(null,(state_26924[(4)])));

return statearr_26940;
})();
var state_26924__$1 = state_26924;
var ex26935 = (state_26924__$1[(2)]);
var statearr_26941_27158 = state_26924__$1;
(statearr_26941_27158[(5)] = ex26935);


if((ex26935 instanceof Error)){
var statearr_26942_27159 = state_26924__$1;
(statearr_26942_27159[(1)] = (4));

(statearr_26942_27159[(5)] = null);

} else {
throw ex26935;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (10))){
var state_26924__$1 = state_26924;
var statearr_26943_27160 = state_26924__$1;
(statearr_26943_27160[(2)] = null);

(statearr_26943_27160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26925 === (8))){
var inst_26907 = (state_26924[(7)]);
var inst_26911 = cljs.core.first.call(null,inst_26907);
var state_26924__$1 = state_26924;
var statearr_26944_27161 = state_26924__$1;
(statearr_26944_27161[(2)] = inst_26911);

(statearr_26944_27161[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2468__auto__ = null;
var fluree$db$graphdb$state_machine__2468__auto____0 = (function (){
var statearr_26945 = [null,null,null,null,null,null,null,null,null];
(statearr_26945[(0)] = fluree$db$graphdb$state_machine__2468__auto__);

(statearr_26945[(1)] = (1));

return statearr_26945;
});
var fluree$db$graphdb$state_machine__2468__auto____1 = (function (state_26924){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26924);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e26946){var ex__2471__auto__ = e26946;
var statearr_26947_27162 = state_26924;
(statearr_26947_27162[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26924[(4)]))){
var statearr_26948_27163 = state_26924;
(statearr_26948_27163[(1)] = cljs.core.first.call(null,(state_26924[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27164 = state_26924;
state_26924 = G__27164;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2468__auto__ = function(state_26924){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2468__auto____1.call(this,state_26924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2468__auto____0;
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2468__auto____1;
return fluree$db$graphdb$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_26949 = f__2491__auto__.call(null);
(statearr_26949[(6)] = c__2490__auto__);

return statearr_26949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_26985){
var state_val_26986 = (state_26985[(1)]);
if((state_val_26986 === (7))){
var inst_26959 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26985__$1 = state_26985;
var statearr_26987_27165 = state_26985__$1;
(statearr_26987_27165[(2)] = inst_26959);

(statearr_26987_27165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (1))){
var state_26985__$1 = state_26985;
var statearr_26988_27166 = state_26985__$1;
(statearr_26988_27166[(2)] = null);

(statearr_26988_27166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (4))){
var inst_26950 = (state_26985[(2)]);
var state_26985__$1 = state_26985;
var statearr_26989_27167 = state_26985__$1;
(statearr_26989_27167[(2)] = inst_26950);

(statearr_26989_27167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (15))){
var inst_26980 = (state_26985[(2)]);
var _ = (function (){var statearr_26990 = state_26985;
(statearr_26990[(4)] = cljs.core.rest.call(null,(state_26985[(4)])));

return statearr_26990;
})();
var state_26985__$1 = state_26985;
var statearr_26991_27168 = state_26985__$1;
(statearr_26991_27168[(2)] = inst_26980);

(statearr_26991_27168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (13))){
var inst_26965 = (state_26985[(7)]);
var inst_26971 = clojure.string.includes_QMARK_.call(null,inst_26965,":");
var state_26985__$1 = state_26985;
if(inst_26971){
var statearr_26992_27169 = state_26985__$1;
(statearr_26992_27169[(1)] = (16));

} else {
var statearr_26993_27170 = state_26985__$1;
(statearr_26993_27170[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (6))){
var state_26985__$1 = state_26985;
var statearr_26994_27171 = state_26985__$1;
(statearr_26994_27171[(2)] = pred);

(statearr_26994_27171[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (17))){
var inst_26965 = (state_26985[(7)]);
var state_26985__$1 = state_26985;
var statearr_26995_27172 = state_26985__$1;
(statearr_26995_27172[(2)] = inst_26965);

(statearr_26995_27172[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (3))){
var inst_26983 = (state_26985[(2)]);
var state_26985__$1 = state_26985;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26985__$1,inst_26983);
} else {
if((state_val_26986 === (12))){
var inst_26969 = (state_26985[(2)]);
var state_26985__$1 = state_26985;
if(cljs.core.truth_(inst_26969)){
var statearr_26996_27173 = state_26985__$1;
(statearr_26996_27173[(1)] = (13));

} else {
var statearr_26997_27174 = state_26985__$1;
(statearr_26997_27174[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (2))){
var _ = (function (){var statearr_26998 = state_26985;
(statearr_26998[(4)] = cljs.core.cons.call(null,(5),(state_26985[(4)])));

return statearr_26998;
})();
var inst_26956 = typeof pred === 'string';
var state_26985__$1 = state_26985;
if(cljs.core.truth_(inst_26956)){
var statearr_26999_27175 = state_26985__$1;
(statearr_26999_27175[(1)] = (6));

} else {
var statearr_27000_27176 = state_26985__$1;
(statearr_27000_27176[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (11))){
var inst_26961 = (state_26985[(8)]);
var state_26985__$1 = state_26985;
var statearr_27002_27177 = state_26985__$1;
(statearr_27002_27177[(2)] = inst_26961);

(statearr_27002_27177[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (9))){
var inst_26961 = (state_26985[(8)]);
var inst_26964 = (state_26985[(2)]);
var inst_26965 = fluree.db.util.async.throw_err.call(null,inst_26964);
var state_26985__$1 = (function (){var statearr_27003 = state_26985;
(statearr_27003[(7)] = inst_26965);

return statearr_27003;
})();
if(cljs.core.truth_(inst_26961)){
var statearr_27004_27178 = state_26985__$1;
(statearr_27004_27178[(1)] = (10));

} else {
var statearr_27005_27179 = state_26985__$1;
(statearr_27005_27179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (5))){
var _ = (function (){var statearr_27006 = state_26985;
(statearr_27006[(4)] = cljs.core.rest.call(null,(state_26985[(4)])));

return statearr_27006;
})();
var state_26985__$1 = state_26985;
var ex27001 = (state_26985__$1[(2)]);
var statearr_27007_27180 = state_26985__$1;
(statearr_27007_27180[(5)] = ex27001);


if((ex27001 instanceof Error)){
var statearr_27008_27181 = state_26985__$1;
(statearr_27008_27181[(1)] = (4));

(statearr_27008_27181[(5)] = null);

} else {
throw ex27001;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (14))){
var state_26985__$1 = state_26985;
var statearr_27009_27182 = state_26985__$1;
(statearr_27009_27182[(2)] = null);

(statearr_27009_27182[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (16))){
var inst_26965 = (state_26985[(7)]);
var inst_26973 = clojure.string.split.call(null,inst_26965,/:/);
var inst_26974 = cljs.core.second.call(null,inst_26973);
var state_26985__$1 = state_26985;
var statearr_27010_27183 = state_26985__$1;
(statearr_27010_27183[(2)] = inst_26974);

(statearr_27010_27183[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (10))){
var inst_26965 = (state_26985[(7)]);
var state_26985__$1 = state_26985;
var statearr_27011_27184 = state_26985__$1;
(statearr_27011_27184[(2)] = inst_26965);

(statearr_27011_27184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (18))){
var inst_26977 = (state_26985[(2)]);
var state_26985__$1 = state_26985;
var statearr_27012_27185 = state_26985__$1;
(statearr_27012_27185[(2)] = inst_26977);

(statearr_27012_27185[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26986 === (8))){
var inst_26961 = (state_26985[(2)]);
var inst_26962 = fluree.db.dbproto._tag.call(null,this$__$1,tag_id);
var state_26985__$1 = (function (){var statearr_27013 = state_26985;
(statearr_27013[(8)] = inst_26961);

return statearr_27013;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26985__$1,(9),inst_26962);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2468__auto__ = null;
var fluree$db$graphdb$state_machine__2468__auto____0 = (function (){
var statearr_27014 = [null,null,null,null,null,null,null,null,null];
(statearr_27014[(0)] = fluree$db$graphdb$state_machine__2468__auto__);

(statearr_27014[(1)] = (1));

return statearr_27014;
});
var fluree$db$graphdb$state_machine__2468__auto____1 = (function (state_26985){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_26985);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27015){var ex__2471__auto__ = e27015;
var statearr_27016_27186 = state_26985;
(statearr_27016_27186[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_26985[(4)]))){
var statearr_27017_27187 = state_26985;
(statearr_27017_27187[(1)] = cljs.core.first.call(null,(state_26985[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27188 = state_26985;
state_26985 = G__27188;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2468__auto__ = function(state_26985){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2468__auto____1.call(this,state_26985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2468__auto____0;
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2468__auto____1;
return fluree$db$graphdb$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27018 = f__2491__auto__.call(null);
(statearr_27018[(6)] = c__2490__auto__);

return statearr_27018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27050){
var state_val_27051 = (state_27050[(1)]);
if((state_val_27051 === (7))){
var state_27050__$1 = state_27050;
var statearr_27052_27189 = state_27050__$1;
(statearr_27052_27189[(2)] = null);

(statearr_27052_27189[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (1))){
var state_27050__$1 = state_27050;
var statearr_27053_27190 = state_27050__$1;
(statearr_27053_27190[(2)] = null);

(statearr_27053_27190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (4))){
var inst_27019 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
var statearr_27054_27191 = state_27050__$1;
(statearr_27054_27191[(2)] = inst_27019);

(statearr_27054_27191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (6))){
var inst_27033 = (state_27050[(7)]);
var inst_27032 = (state_27050[(2)]);
var inst_27033__$1 = fluree.db.util.async.throw_err.call(null,inst_27032);
var inst_27034 = (inst_27033__$1 == null);
var state_27050__$1 = (function (){var statearr_27055 = state_27050;
(statearr_27055[(7)] = inst_27033__$1);

return statearr_27055;
})();
if(cljs.core.truth_(inst_27034)){
var statearr_27056_27192 = state_27050__$1;
(statearr_27056_27192[(1)] = (7));

} else {
var statearr_27057_27193 = state_27050__$1;
(statearr_27057_27193[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (3))){
var inst_27048 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27050__$1,inst_27048);
} else {
if((state_val_27051 === (12))){
var inst_27045 = (state_27050[(2)]);
var _ = (function (){var statearr_27058 = state_27050;
(statearr_27058[(4)] = cljs.core.rest.call(null,(state_27050[(4)])));

return statearr_27058;
})();
var state_27050__$1 = state_27050;
var statearr_27059_27194 = state_27050__$1;
(statearr_27059_27194[(2)] = inst_27045);

(statearr_27059_27194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (2))){
var _ = (function (){var statearr_27060 = state_27050;
(statearr_27060[(4)] = cljs.core.cons.call(null,(5),(state_27050[(4)])));

return statearr_27060;
})();
var inst_27026 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27028 = [(30),tag_name];
var inst_27029 = (new cljs.core.PersistentVector(null,2,(5),inst_27027,inst_27028,null));
var inst_27030 = fluree.db.query.range.index_range.call(null,inst_27026,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27029);
var state_27050__$1 = state_27050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(6),inst_27030);
} else {
if((state_val_27051 === (11))){
var inst_27039 = (state_27050[(8)]);
var inst_27043 = inst_27039.s;
var state_27050__$1 = state_27050;
var statearr_27062_27195 = state_27050__$1;
(statearr_27062_27195[(2)] = inst_27043);

(statearr_27062_27195[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (9))){
var inst_27039 = (state_27050[(8)]);
var inst_27039__$1 = (state_27050[(2)]);
var inst_27040 = (inst_27039__$1 == null);
var state_27050__$1 = (function (){var statearr_27063 = state_27050;
(statearr_27063[(8)] = inst_27039__$1);

return statearr_27063;
})();
if(cljs.core.truth_(inst_27040)){
var statearr_27064_27196 = state_27050__$1;
(statearr_27064_27196[(1)] = (10));

} else {
var statearr_27065_27197 = state_27050__$1;
(statearr_27065_27197[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (5))){
var _ = (function (){var statearr_27066 = state_27050;
(statearr_27066[(4)] = cljs.core.rest.call(null,(state_27050[(4)])));

return statearr_27066;
})();
var state_27050__$1 = state_27050;
var ex27061 = (state_27050__$1[(2)]);
var statearr_27067_27198 = state_27050__$1;
(statearr_27067_27198[(5)] = ex27061);


if((ex27061 instanceof Error)){
var statearr_27068_27199 = state_27050__$1;
(statearr_27068_27199[(1)] = (4));

(statearr_27068_27199[(5)] = null);

} else {
throw ex27061;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (10))){
var state_27050__$1 = state_27050;
var statearr_27069_27200 = state_27050__$1;
(statearr_27069_27200[(2)] = null);

(statearr_27069_27200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (8))){
var inst_27033 = (state_27050[(7)]);
var inst_27037 = cljs.core.first.call(null,inst_27033);
var state_27050__$1 = state_27050;
var statearr_27070_27201 = state_27050__$1;
(statearr_27070_27201[(2)] = inst_27037);

(statearr_27070_27201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2468__auto__ = null;
var fluree$db$graphdb$state_machine__2468__auto____0 = (function (){
var statearr_27071 = [null,null,null,null,null,null,null,null,null];
(statearr_27071[(0)] = fluree$db$graphdb$state_machine__2468__auto__);

(statearr_27071[(1)] = (1));

return statearr_27071;
});
var fluree$db$graphdb$state_machine__2468__auto____1 = (function (state_27050){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27072){var ex__2471__auto__ = e27072;
var statearr_27073_27202 = state_27050;
(statearr_27073_27202[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27050[(4)]))){
var statearr_27074_27203 = state_27050;
(statearr_27074_27203[(1)] = cljs.core.first.call(null,(state_27050[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27204 = state_27050;
state_27050 = G__27204;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2468__auto__ = function(state_27050){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2468__auto____1.call(this,state_27050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2468__auto____0;
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2468__auto____1;
return fluree$db$graphdb$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27075 = f__2491__auto__.call(null);
(statearr_27075[(6)] = c__2490__auto__);

return statearr_27075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_27110){
var state_val_27111 = (state_27110[(1)]);
if((state_val_27111 === (7))){
var inst_27089 = typeof pred === 'string';
var state_27110__$1 = state_27110;
if(cljs.core.truth_(inst_27089)){
var statearr_27112_27205 = state_27110__$1;
(statearr_27112_27205[(1)] = (10));

} else {
var statearr_27113_27206 = state_27110__$1;
(statearr_27113_27206[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (1))){
var state_27110__$1 = state_27110;
var statearr_27114_27207 = state_27110__$1;
(statearr_27114_27207[(2)] = null);

(statearr_27114_27207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (4))){
var inst_27076 = (state_27110[(2)]);
var state_27110__$1 = state_27110;
var statearr_27115_27208 = state_27110__$1;
(statearr_27115_27208[(2)] = inst_27076);

(statearr_27115_27208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (15))){
var inst_27103 = (state_27110[(2)]);
var state_27110__$1 = state_27110;
var statearr_27116_27209 = state_27110__$1;
(statearr_27116_27209[(2)] = inst_27103);

(statearr_27116_27209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (13))){
var inst_27094 = (state_27110[(7)]);
var inst_27096 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27094),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27097 = fluree.db.dbproto._tag_id.call(null,this$__$1,inst_27096);
var state_27110__$1 = state_27110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27110__$1,(16),inst_27097);
} else {
if((state_val_27111 === (6))){
var inst_27084 = fluree.db.dbproto._tag_id.call(null,this$__$1,tag_name);
var state_27110__$1 = state_27110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27110__$1,(9),inst_27084);
} else {
if((state_val_27111 === (3))){
var inst_27108 = (state_27110[(2)]);
var state_27110__$1 = state_27110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27110__$1,inst_27108);
} else {
if((state_val_27111 === (12))){
var inst_27094 = (state_27110[(7)]);
var inst_27094__$1 = (state_27110[(2)]);
var state_27110__$1 = (function (){var statearr_27117 = state_27110;
(statearr_27117[(7)] = inst_27094__$1);

return statearr_27117;
})();
if(cljs.core.truth_(inst_27094__$1)){
var statearr_27118_27210 = state_27110__$1;
(statearr_27118_27210[(1)] = (13));

} else {
var statearr_27119_27211 = state_27110__$1;
(statearr_27119_27211[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (2))){
var _ = (function (){var statearr_27120 = state_27110;
(statearr_27120[(4)] = cljs.core.cons.call(null,(5),(state_27110[(4)])));

return statearr_27120;
})();
var inst_27082 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27110__$1 = state_27110;
if(inst_27082){
var statearr_27121_27212 = state_27110__$1;
(statearr_27121_27212[(1)] = (6));

} else {
var statearr_27122_27213 = state_27110__$1;
(statearr_27122_27213[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (11))){
var inst_27092 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27110__$1 = state_27110;
var statearr_27124_27214 = state_27110__$1;
(statearr_27124_27214[(2)] = inst_27092);

(statearr_27124_27214[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (9))){
var inst_27086 = (state_27110[(2)]);
var inst_27087 = fluree.db.util.async.throw_err.call(null,inst_27086);
var state_27110__$1 = state_27110;
var statearr_27125_27215 = state_27110__$1;
(statearr_27125_27215[(2)] = inst_27087);

(statearr_27125_27215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (5))){
var _ = (function (){var statearr_27126 = state_27110;
(statearr_27126[(4)] = cljs.core.rest.call(null,(state_27110[(4)])));

return statearr_27126;
})();
var state_27110__$1 = state_27110;
var ex27123 = (state_27110__$1[(2)]);
var statearr_27127_27216 = state_27110__$1;
(statearr_27127_27216[(5)] = ex27123);


if((ex27123 instanceof Error)){
var statearr_27128_27217 = state_27110__$1;
(statearr_27128_27217[(1)] = (4));

(statearr_27128_27217[(5)] = null);

} else {
throw ex27123;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (14))){
var state_27110__$1 = state_27110;
var statearr_27129_27218 = state_27110__$1;
(statearr_27129_27218[(2)] = null);

(statearr_27129_27218[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (16))){
var inst_27099 = (state_27110[(2)]);
var inst_27100 = fluree.db.util.async.throw_err.call(null,inst_27099);
var state_27110__$1 = state_27110;
var statearr_27130_27219 = state_27110__$1;
(statearr_27130_27219[(2)] = inst_27100);

(statearr_27130_27219[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (10))){
var state_27110__$1 = state_27110;
var statearr_27131_27220 = state_27110__$1;
(statearr_27131_27220[(2)] = pred);

(statearr_27131_27220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27111 === (8))){
var inst_27105 = (state_27110[(2)]);
var _ = (function (){var statearr_27132 = state_27110;
(statearr_27132[(4)] = cljs.core.rest.call(null,(state_27110[(4)])));

return statearr_27132;
})();
var state_27110__$1 = state_27110;
var statearr_27133_27221 = state_27110__$1;
(statearr_27133_27221[(2)] = inst_27105);

(statearr_27133_27221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2468__auto__ = null;
var fluree$db$graphdb$state_machine__2468__auto____0 = (function (){
var statearr_27134 = [null,null,null,null,null,null,null,null];
(statearr_27134[(0)] = fluree$db$graphdb$state_machine__2468__auto__);

(statearr_27134[(1)] = (1));

return statearr_27134;
});
var fluree$db$graphdb$state_machine__2468__auto____1 = (function (state_27110){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_27110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e27135){var ex__2471__auto__ = e27135;
var statearr_27136_27222 = state_27110;
(statearr_27136_27222[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_27110[(4)]))){
var statearr_27137_27223 = state_27110;
(statearr_27137_27223[(1)] = cljs.core.first.call(null,(state_27110[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27224 = state_27110;
state_27110 = G__27224;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2468__auto__ = function(state_27110){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2468__auto____1.call(this,state_27110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2468__auto____0;
fluree$db$graphdb$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2468__auto____1;
return fluree$db$graphdb$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_27138 = f__2491__auto__.call(null);
(statearr_27138[(6)] = c__2490__auto__);

return statearr_27138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__26852){
var extmap__4419__auto__ = (function (){var G__27139 = cljs.core.dissoc.call(null,G__26852,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__26852)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27139);
} else {
return G__27139;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__26852),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__26852),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});

//# sourceMappingURL=graphdb.js.map
