// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16307){
var state_val_16308 = (state_16307[(1)]);
if((state_val_16308 === (7))){
var inst_16296 = (state_16307[(7)]);
var inst_16298 = fluree.db.storage.core.serde.call(null,conn);
var inst_16299 = fluree.db.serde.protocol._deserialize_block.call(null,inst_16298,inst_16296);
var state_16307__$1 = state_16307;
var statearr_16309_16328 = state_16307__$1;
(statearr_16309_16328[(2)] = inst_16299);

(statearr_16309_16328[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16308 === (1))){
var state_16307__$1 = state_16307;
var statearr_16310_16329 = state_16307__$1;
(statearr_16310_16329[(2)] = null);

(statearr_16310_16329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16308 === (4))){
var inst_16286 = (state_16307[(2)]);
var state_16307__$1 = state_16307;
var statearr_16311_16330 = state_16307__$1;
(statearr_16311_16330[(2)] = inst_16286);

(statearr_16311_16330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16308 === (6))){
var inst_16296 = (state_16307[(7)]);
var inst_16295 = (state_16307[(2)]);
var inst_16296__$1 = fluree.db.util.async.throw_err.call(null,inst_16295);
var state_16307__$1 = (function (){var statearr_16312 = state_16307;
(statearr_16312[(7)] = inst_16296__$1);

return statearr_16312;
})();
if(cljs.core.truth_(inst_16296__$1)){
var statearr_16313_16331 = state_16307__$1;
(statearr_16313_16331[(1)] = (7));

} else {
var statearr_16314_16332 = state_16307__$1;
(statearr_16314_16332[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16308 === (3))){
var inst_16305 = (state_16307[(2)]);
var state_16307__$1 = state_16307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16307__$1,inst_16305);
} else {
if((state_val_16308 === (2))){
var _ = (function (){var statearr_16316 = state_16307;
(statearr_16316[(4)] = cljs.core.cons.call(null,(5),(state_16307[(4)])));

return statearr_16316;
})();
var inst_16292 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_16293 = fluree.db.storage.core.storage_read.call(null,conn,inst_16292);
var state_16307__$1 = state_16307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16307__$1,(6),inst_16293);
} else {
if((state_val_16308 === (9))){
var inst_16302 = (state_16307[(2)]);
var _ = (function (){var statearr_16317 = state_16307;
(statearr_16317[(4)] = cljs.core.rest.call(null,(state_16307[(4)])));

return statearr_16317;
})();
var state_16307__$1 = state_16307;
var statearr_16318_16333 = state_16307__$1;
(statearr_16318_16333[(2)] = inst_16302);

(statearr_16318_16333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16308 === (5))){
var _ = (function (){var statearr_16319 = state_16307;
(statearr_16319[(4)] = cljs.core.rest.call(null,(state_16307[(4)])));

return statearr_16319;
})();
var state_16307__$1 = state_16307;
var ex16315 = (state_16307__$1[(2)]);
var statearr_16320_16334 = state_16307__$1;
(statearr_16320_16334[(5)] = ex16315);


if((ex16315 instanceof Error)){
var statearr_16321_16335 = state_16307__$1;
(statearr_16321_16335[(1)] = (4));

(statearr_16321_16335[(5)] = null);

} else {
throw ex16315;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16308 === (8))){
var state_16307__$1 = state_16307;
var statearr_16322_16336 = state_16307__$1;
(statearr_16322_16336[(2)] = null);

(statearr_16322_16336[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2468__auto____0 = (function (){
var statearr_16323 = [null,null,null,null,null,null,null,null];
(statearr_16323[(0)] = fluree$db$storage$core$read_block_$_state_machine__2468__auto__);

(statearr_16323[(1)] = (1));

return statearr_16323;
});
var fluree$db$storage$core$read_block_$_state_machine__2468__auto____1 = (function (state_16307){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16324){var ex__2471__auto__ = e16324;
var statearr_16325_16337 = state_16307;
(statearr_16325_16337[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16307[(4)]))){
var statearr_16326_16338 = state_16307;
(statearr_16326_16338[(1)] = cljs.core.first.call(null,(state_16307[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16339 = state_16307;
state_16307 = G__16339;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2468__auto__ = function(state_16307){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2468__auto____1.call(this,state_16307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2468__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2468__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16327 = f__2491__auto__.call(null);
(statearr_16327[(6)] = c__2490__auto__);

return statearr_16327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16362){
var state_val_16363 = (state_16362[(1)]);
if((state_val_16363 === (7))){
var inst_16351 = (state_16362[(7)]);
var inst_16353 = fluree.db.storage.core.serde.call(null,conn);
var inst_16354 = fluree.db.serde.protocol._deserialize_block.call(null,inst_16353,inst_16351);
var state_16362__$1 = state_16362;
var statearr_16364_16383 = state_16362__$1;
(statearr_16364_16383[(2)] = inst_16354);

(statearr_16364_16383[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16363 === (1))){
var state_16362__$1 = state_16362;
var statearr_16365_16384 = state_16362__$1;
(statearr_16365_16384[(2)] = null);

(statearr_16365_16384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16363 === (4))){
var inst_16340 = (state_16362[(2)]);
var state_16362__$1 = state_16362;
var statearr_16366_16385 = state_16362__$1;
(statearr_16366_16385[(2)] = inst_16340);

(statearr_16366_16385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16363 === (6))){
var inst_16351 = (state_16362[(7)]);
var inst_16350 = (state_16362[(2)]);
var inst_16351__$1 = fluree.db.util.async.throw_err.call(null,inst_16350);
var state_16362__$1 = (function (){var statearr_16367 = state_16362;
(statearr_16367[(7)] = inst_16351__$1);

return statearr_16367;
})();
if(cljs.core.truth_(inst_16351__$1)){
var statearr_16368_16386 = state_16362__$1;
(statearr_16368_16386[(1)] = (7));

} else {
var statearr_16369_16387 = state_16362__$1;
(statearr_16369_16387[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16363 === (3))){
var inst_16360 = (state_16362[(2)]);
var state_16362__$1 = state_16362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16362__$1,inst_16360);
} else {
if((state_val_16363 === (2))){
var _ = (function (){var statearr_16371 = state_16362;
(statearr_16371[(4)] = cljs.core.cons.call(null,(5),(state_16362[(4)])));

return statearr_16371;
})();
var inst_16346 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_16347 = [inst_16346,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16348 = fluree.db.storage.core.storage_read.call(null,conn,inst_16347);
var state_16362__$1 = state_16362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16362__$1,(6),inst_16348);
} else {
if((state_val_16363 === (9))){
var inst_16357 = (state_16362[(2)]);
var _ = (function (){var statearr_16372 = state_16362;
(statearr_16372[(4)] = cljs.core.rest.call(null,(state_16362[(4)])));

return statearr_16372;
})();
var state_16362__$1 = state_16362;
var statearr_16373_16388 = state_16362__$1;
(statearr_16373_16388[(2)] = inst_16357);

(statearr_16373_16388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16363 === (5))){
var _ = (function (){var statearr_16374 = state_16362;
(statearr_16374[(4)] = cljs.core.rest.call(null,(state_16362[(4)])));

return statearr_16374;
})();
var state_16362__$1 = state_16362;
var ex16370 = (state_16362__$1[(2)]);
var statearr_16375_16389 = state_16362__$1;
(statearr_16375_16389[(5)] = ex16370);


if((ex16370 instanceof Error)){
var statearr_16376_16390 = state_16362__$1;
(statearr_16376_16390[(1)] = (4));

(statearr_16376_16390[(5)] = null);

} else {
throw ex16370;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16363 === (8))){
var state_16362__$1 = state_16362;
var statearr_16377_16391 = state_16362__$1;
(statearr_16377_16391[(2)] = null);

(statearr_16377_16391[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2468__auto____0 = (function (){
var statearr_16378 = [null,null,null,null,null,null,null,null];
(statearr_16378[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2468__auto__);

(statearr_16378[(1)] = (1));

return statearr_16378;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2468__auto____1 = (function (state_16362){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16379){var ex__2471__auto__ = e16379;
var statearr_16380_16392 = state_16362;
(statearr_16380_16392[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16362[(4)]))){
var statearr_16381_16393 = state_16362;
(statearr_16381_16393[(1)] = cljs.core.first.call(null,(state_16362[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16394 = state_16362;
state_16362 = G__16394;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2468__auto__ = function(state_16362){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2468__auto____1.call(this,state_16362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2468__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2468__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16382 = f__2491__auto__.call(null);
(statearr_16382[(6)] = c__2490__auto__);

return statearr_16382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16418){
var state_val_16419 = (state_16418[(1)]);
if((state_val_16419 === (1))){
var state_16418__$1 = state_16418;
var statearr_16420_16434 = state_16418__$1;
(statearr_16420_16434[(2)] = null);

(statearr_16420_16434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (2))){
var _ = (function (){var statearr_16421 = state_16418;
(statearr_16421[(4)] = cljs.core.cons.call(null,(5),(state_16418[(4)])));

return statearr_16421;
})();
var inst_16401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16402 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16403 = (new cljs.core.PersistentVector(null,3,(5),inst_16401,inst_16402,null));
var inst_16404 = cljs.core.select_keys.call(null,block_data,inst_16403);
var inst_16405 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16404);
var inst_16406 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_16405);
var inst_16407 = [inst_16406,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_16408 = fluree.db.storage.core.serde.call(null,conn);
var inst_16409 = fluree.db.serde.protocol._serialize_block.call(null,inst_16408,inst_16404);
var inst_16410 = fluree.db.storage.core.storage_write.call(null,conn,inst_16407,inst_16409);
var state_16418__$1 = state_16418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16418__$1,(6),inst_16410);
} else {
if((state_val_16419 === (3))){
var inst_16416 = (state_16418[(2)]);
var state_16418__$1 = state_16418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16418__$1,inst_16416);
} else {
if((state_val_16419 === (4))){
var inst_16395 = (state_16418[(2)]);
var state_16418__$1 = state_16418;
var statearr_16423_16435 = state_16418__$1;
(statearr_16423_16435[(2)] = inst_16395);

(statearr_16423_16435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (5))){
var _ = (function (){var statearr_16424 = state_16418;
(statearr_16424[(4)] = cljs.core.rest.call(null,(state_16418[(4)])));

return statearr_16424;
})();
var state_16418__$1 = state_16418;
var ex16422 = (state_16418__$1[(2)]);
var statearr_16425_16436 = state_16418__$1;
(statearr_16425_16436[(5)] = ex16422);


if((ex16422 instanceof Error)){
var statearr_16426_16437 = state_16418__$1;
(statearr_16426_16437[(1)] = (4));

(statearr_16426_16437[(5)] = null);

} else {
throw ex16422;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16419 === (6))){
var inst_16412 = (state_16418[(2)]);
var inst_16413 = fluree.db.util.async.throw_err.call(null,inst_16412);
var _ = (function (){var statearr_16427 = state_16418;
(statearr_16427[(4)] = cljs.core.rest.call(null,(state_16418[(4)])));

return statearr_16427;
})();
var state_16418__$1 = state_16418;
var statearr_16428_16438 = state_16418__$1;
(statearr_16428_16438[(2)] = inst_16413);

(statearr_16428_16438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2468__auto____0 = (function (){
var statearr_16429 = [null,null,null,null,null,null,null];
(statearr_16429[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2468__auto__);

(statearr_16429[(1)] = (1));

return statearr_16429;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2468__auto____1 = (function (state_16418){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16430){var ex__2471__auto__ = e16430;
var statearr_16431_16439 = state_16418;
(statearr_16431_16439[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16418[(4)]))){
var statearr_16432_16440 = state_16418;
(statearr_16432_16440[(1)] = cljs.core.first.call(null,(state_16418[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16441 = state_16418;
state_16418 = G__16441;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2468__auto__ = function(state_16418){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2468__auto____1.call(this,state_16418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2468__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2468__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16433 = f__2491__auto__.call(null);
(statearr_16433[(6)] = c__2490__auto__);

return statearr_16433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16464){
var state_val_16465 = (state_16464[(1)]);
if((state_val_16465 === (1))){
var state_16464__$1 = state_16464;
var statearr_16466_16480 = state_16464__$1;
(statearr_16466_16480[(2)] = null);

(statearr_16466_16480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (2))){
var _ = (function (){var statearr_16467 = state_16464;
(statearr_16467[(4)] = cljs.core.cons.call(null,(5),(state_16464[(4)])));

return statearr_16467;
})();
var inst_16448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16449 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_16450 = (new cljs.core.PersistentVector(null,3,(5),inst_16448,inst_16449,null));
var inst_16451 = cljs.core.select_keys.call(null,block_data,inst_16450);
var inst_16452 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_16451);
var inst_16453 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_16452);
var inst_16454 = fluree.db.storage.core.serde.call(null,conn);
var inst_16455 = fluree.db.serde.protocol._serialize_block.call(null,inst_16454,inst_16451);
var inst_16456 = fluree.db.storage.core.storage_write.call(null,conn,inst_16453,inst_16455);
var state_16464__$1 = state_16464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16464__$1,(6),inst_16456);
} else {
if((state_val_16465 === (3))){
var inst_16462 = (state_16464[(2)]);
var state_16464__$1 = state_16464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16464__$1,inst_16462);
} else {
if((state_val_16465 === (4))){
var inst_16442 = (state_16464[(2)]);
var state_16464__$1 = state_16464;
var statearr_16469_16481 = state_16464__$1;
(statearr_16469_16481[(2)] = inst_16442);

(statearr_16469_16481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (5))){
var _ = (function (){var statearr_16470 = state_16464;
(statearr_16470[(4)] = cljs.core.rest.call(null,(state_16464[(4)])));

return statearr_16470;
})();
var state_16464__$1 = state_16464;
var ex16468 = (state_16464__$1[(2)]);
var statearr_16471_16482 = state_16464__$1;
(statearr_16471_16482[(5)] = ex16468);


if((ex16468 instanceof Error)){
var statearr_16472_16483 = state_16464__$1;
(statearr_16472_16483[(1)] = (4));

(statearr_16472_16483[(5)] = null);

} else {
throw ex16468;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16465 === (6))){
var inst_16458 = (state_16464[(2)]);
var inst_16459 = fluree.db.util.async.throw_err.call(null,inst_16458);
var _ = (function (){var statearr_16473 = state_16464;
(statearr_16473[(4)] = cljs.core.rest.call(null,(state_16464[(4)])));

return statearr_16473;
})();
var state_16464__$1 = state_16464;
var statearr_16474_16484 = state_16464__$1;
(statearr_16474_16484[(2)] = inst_16459);

(statearr_16474_16484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2468__auto____0 = (function (){
var statearr_16475 = [null,null,null,null,null,null,null];
(statearr_16475[(0)] = fluree$db$storage$core$write_block_$_state_machine__2468__auto__);

(statearr_16475[(1)] = (1));

return statearr_16475;
});
var fluree$db$storage$core$write_block_$_state_machine__2468__auto____1 = (function (state_16464){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16476){var ex__2471__auto__ = e16476;
var statearr_16477_16485 = state_16464;
(statearr_16477_16485[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16464[(4)]))){
var statearr_16478_16486 = state_16464;
(statearr_16478_16486[(1)] = cljs.core.first.call(null,(state_16464[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16487 = state_16464;
state_16464 = G__16487;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2468__auto__ = function(state_16464){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2468__auto____1.call(this,state_16464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2468__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2468__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16479 = f__2491__auto__.call(null);
(statearr_16479[(6)] = c__2490__auto__);

return statearr_16479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16507){
var state_val_16508 = (state_16507[(1)]);
if((state_val_16508 === (1))){
var state_16507__$1 = state_16507;
var statearr_16509_16523 = state_16507__$1;
(statearr_16509_16523[(2)] = null);

(statearr_16509_16523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (2))){
var _ = (function (){var statearr_16510 = state_16507;
(statearr_16510[(4)] = cljs.core.cons.call(null,(5),(state_16507[(4)])));

return statearr_16510;
})();
var inst_16494 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_16495 = [history,next_his_key];
var inst_16496 = cljs.core.PersistentHashMap.fromArrays(inst_16494,inst_16495);
var inst_16497 = fluree.db.storage.core.serde.call(null,conn);
var inst_16498 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_16497,inst_16496);
var inst_16499 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_16498);
var state_16507__$1 = state_16507;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16507__$1,(6),inst_16499);
} else {
if((state_val_16508 === (3))){
var inst_16505 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16507__$1,inst_16505);
} else {
if((state_val_16508 === (4))){
var inst_16488 = (state_16507[(2)]);
var state_16507__$1 = state_16507;
var statearr_16512_16524 = state_16507__$1;
(statearr_16512_16524[(2)] = inst_16488);

(statearr_16512_16524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (5))){
var _ = (function (){var statearr_16513 = state_16507;
(statearr_16513[(4)] = cljs.core.rest.call(null,(state_16507[(4)])));

return statearr_16513;
})();
var state_16507__$1 = state_16507;
var ex16511 = (state_16507__$1[(2)]);
var statearr_16514_16525 = state_16507__$1;
(statearr_16514_16525[(5)] = ex16511);


if((ex16511 instanceof Error)){
var statearr_16515_16526 = state_16507__$1;
(statearr_16515_16526[(1)] = (4));

(statearr_16515_16526[(5)] = null);

} else {
throw ex16511;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16508 === (6))){
var inst_16501 = (state_16507[(2)]);
var inst_16502 = fluree.db.util.async.throw_err.call(null,inst_16501);
var _ = (function (){var statearr_16516 = state_16507;
(statearr_16516[(4)] = cljs.core.rest.call(null,(state_16507[(4)])));

return statearr_16516;
})();
var state_16507__$1 = state_16507;
var statearr_16517_16527 = state_16507__$1;
(statearr_16517_16527[(2)] = inst_16502);

(statearr_16517_16527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2468__auto____0 = (function (){
var statearr_16518 = [null,null,null,null,null,null,null];
(statearr_16518[(0)] = fluree$db$storage$core$write_history_$_state_machine__2468__auto__);

(statearr_16518[(1)] = (1));

return statearr_16518;
});
var fluree$db$storage$core$write_history_$_state_machine__2468__auto____1 = (function (state_16507){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16507);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16519){var ex__2471__auto__ = e16519;
var statearr_16520_16528 = state_16507;
(statearr_16520_16528[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16507[(4)]))){
var statearr_16521_16529 = state_16507;
(statearr_16521_16529[(1)] = cljs.core.first.call(null,(state_16507[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16530 = state_16507;
state_16507 = G__16530;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2468__auto__ = function(state_16507){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2468__auto____1.call(this,state_16507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2468__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2468__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16522 = f__2491__auto__.call(null);
(statearr_16522[(6)] = c__2490__auto__);

return statearr_16522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16556){
var state_val_16557 = (state_16556[(1)]);
if((state_val_16557 === (1))){
var state_16556__$1 = state_16556;
var statearr_16558_16575 = state_16556__$1;
(statearr_16558_16575[(2)] = null);

(statearr_16558_16575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16557 === (2))){
var inst_16537 = (state_16556[(7)]);
var _ = (function (){var statearr_16559 = state_16556;
(statearr_16559[(4)] = cljs.core.cons.call(null,(5),(state_16556[(4)])));

return statearr_16559;
})();
var inst_16537__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_16538 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16537__$1),"-his"].join('');
var inst_16539 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_16540 = [flakes,inst_16538];
var inst_16541 = cljs.core.PersistentHashMap.fromArrays(inst_16539,inst_16540);
var inst_16542 = fluree.db.storage.core.serde.call(null,conn);
var inst_16543 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_16542,inst_16541);
var inst_16544 = fluree.db.storage.core.write_history.call(null,conn,history,inst_16538,null);
var inst_16545 = fluree.db.storage.core.storage_write.call(null,conn,inst_16537__$1,inst_16543);
var state_16556__$1 = (function (){var statearr_16560 = state_16556;
(statearr_16560[(8)] = inst_16545);

(statearr_16560[(7)] = inst_16537__$1);

return statearr_16560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16556__$1,(6),inst_16544);
} else {
if((state_val_16557 === (3))){
var inst_16554 = (state_16556[(2)]);
var state_16556__$1 = state_16556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16556__$1,inst_16554);
} else {
if((state_val_16557 === (4))){
var inst_16531 = (state_16556[(2)]);
var state_16556__$1 = state_16556;
var statearr_16562_16576 = state_16556__$1;
(statearr_16562_16576[(2)] = inst_16531);

(statearr_16562_16576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16557 === (5))){
var _ = (function (){var statearr_16563 = state_16556;
(statearr_16563[(4)] = cljs.core.rest.call(null,(state_16556[(4)])));

return statearr_16563;
})();
var state_16556__$1 = state_16556;
var ex16561 = (state_16556__$1[(2)]);
var statearr_16564_16577 = state_16556__$1;
(statearr_16564_16577[(5)] = ex16561);


if((ex16561 instanceof Error)){
var statearr_16565_16578 = state_16556__$1;
(statearr_16565_16578[(1)] = (4));

(statearr_16565_16578[(5)] = null);

} else {
throw ex16561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16557 === (6))){
var inst_16545 = (state_16556[(8)]);
var inst_16547 = (state_16556[(2)]);
var inst_16548 = fluree.db.util.async.throw_err.call(null,inst_16547);
var state_16556__$1 = (function (){var statearr_16566 = state_16556;
(statearr_16566[(9)] = inst_16548);

return statearr_16566;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16556__$1,(7),inst_16545);
} else {
if((state_val_16557 === (7))){
var inst_16537 = (state_16556[(7)]);
var inst_16550 = (state_16556[(2)]);
var inst_16551 = fluree.db.util.async.throw_err.call(null,inst_16550);
var _ = (function (){var statearr_16567 = state_16556;
(statearr_16567[(4)] = cljs.core.rest.call(null,(state_16556[(4)])));

return statearr_16567;
})();
var state_16556__$1 = (function (){var statearr_16568 = state_16556;
(statearr_16568[(10)] = inst_16551);

return statearr_16568;
})();
var statearr_16569_16579 = state_16556__$1;
(statearr_16569_16579[(2)] = inst_16537);

(statearr_16569_16579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2468__auto____0 = (function (){
var statearr_16570 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16570[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2468__auto__);

(statearr_16570[(1)] = (1));

return statearr_16570;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2468__auto____1 = (function (state_16556){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16571){var ex__2471__auto__ = e16571;
var statearr_16572_16580 = state_16556;
(statearr_16572_16580[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16556[(4)]))){
var statearr_16573_16581 = state_16556;
(statearr_16573_16581[(1)] = cljs.core.first.call(null,(state_16556[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16582 = state_16556;
state_16556 = G__16582;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2468__auto__ = function(state_16556){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2468__auto____1.call(this,state_16556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2468__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2468__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16574 = f__2491__auto__.call(null);
(statearr_16574[(6)] = c__2490__auto__);

return statearr_16574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16599){
var state_val_16600 = (state_16599[(1)]);
if((state_val_16600 === (1))){
var state_16599__$1 = state_16599;
var statearr_16601_16616 = state_16599__$1;
(statearr_16601_16616[(2)] = null);

(statearr_16601_16616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16600 === (2))){
var _ = (function (){var statearr_16602 = state_16599;
(statearr_16602[(4)] = cljs.core.cons.call(null,(5),(state_16599[(4)])));

return statearr_16602;
})();
var inst_16589 = fluree.db.storage.core.serde.call(null,conn);
var inst_16590 = fluree.db.serde.protocol._serialize_branch.call(null,inst_16589,data);
var inst_16591 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_16590);
var state_16599__$1 = state_16599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16599__$1,(6),inst_16591);
} else {
if((state_val_16600 === (3))){
var inst_16597 = (state_16599[(2)]);
var state_16599__$1 = state_16599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16599__$1,inst_16597);
} else {
if((state_val_16600 === (4))){
var inst_16583 = (state_16599[(2)]);
var state_16599__$1 = state_16599;
var statearr_16604_16617 = state_16599__$1;
(statearr_16604_16617[(2)] = inst_16583);

(statearr_16604_16617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16600 === (5))){
var _ = (function (){var statearr_16605 = state_16599;
(statearr_16605[(4)] = cljs.core.rest.call(null,(state_16599[(4)])));

return statearr_16605;
})();
var state_16599__$1 = state_16599;
var ex16603 = (state_16599__$1[(2)]);
var statearr_16606_16618 = state_16599__$1;
(statearr_16606_16618[(5)] = ex16603);


if((ex16603 instanceof Error)){
var statearr_16607_16619 = state_16599__$1;
(statearr_16607_16619[(1)] = (4));

(statearr_16607_16619[(5)] = null);

} else {
throw ex16603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16600 === (6))){
var inst_16593 = (state_16599[(2)]);
var inst_16594 = fluree.db.util.async.throw_err.call(null,inst_16593);
var _ = (function (){var statearr_16608 = state_16599;
(statearr_16608[(4)] = cljs.core.rest.call(null,(state_16599[(4)])));

return statearr_16608;
})();
var state_16599__$1 = (function (){var statearr_16609 = state_16599;
(statearr_16609[(7)] = inst_16594);

return statearr_16609;
})();
var statearr_16610_16620 = state_16599__$1;
(statearr_16610_16620[(2)] = key);

(statearr_16610_16620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto____0 = (function (){
var statearr_16611 = [null,null,null,null,null,null,null,null];
(statearr_16611[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto__);

(statearr_16611[(1)] = (1));

return statearr_16611;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto____1 = (function (state_16599){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16612){var ex__2471__auto__ = e16612;
var statearr_16613_16621 = state_16599;
(statearr_16613_16621[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16599[(4)]))){
var statearr_16614_16622 = state_16599;
(statearr_16614_16622[(1)] = cljs.core.first.call(null,(state_16599[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16623 = state_16599;
state_16599 = G__16623;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto__ = function(state_16599){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto____1.call(this,state_16599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16615 = f__2491__auto__.call(null);
(statearr_16615[(6)] = c__2490__auto__);

return statearr_16615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__16624_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__16624_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__16625){
var map__16626 = p__16625;
var map__16626__$1 = (((((!((map__16626 == null))))?(((((map__16626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16626.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16626):map__16626);
var progress = map__16626__$1;
var garbage = cljs.core.get.call(null,map__16626__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16675){
var state_val_16676 = (state_16675[(1)]);
if((state_val_16676 === (7))){
var state_16675__$1 = state_16675;
var statearr_16677_16706 = state_16675__$1;
(statearr_16677_16706[(2)] = false);

(statearr_16677_16706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (1))){
var state_16675__$1 = state_16675;
var statearr_16678_16707 = state_16675__$1;
(statearr_16678_16707[(2)] = null);

(statearr_16678_16707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (4))){
var inst_16628 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
var statearr_16679_16708 = state_16675__$1;
(statearr_16679_16708[(2)] = inst_16628);

(statearr_16679_16708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (15))){
var inst_16661 = (state_16675[(7)]);
var inst_16669 = (state_16675[(2)]);
var inst_16670 = fluree.db.util.async.throw_err.call(null,inst_16669);
var _ = (function (){var statearr_16680 = state_16675;
(statearr_16680[(4)] = cljs.core.rest.call(null,(state_16675[(4)])));

return statearr_16680;
})();
var state_16675__$1 = (function (){var statearr_16681 = state_16675;
(statearr_16681[(8)] = inst_16670);

return statearr_16681;
})();
var statearr_16682_16709 = state_16675__$1;
(statearr_16682_16709[(2)] = inst_16661);

(statearr_16682_16709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (13))){
var inst_16635 = (state_16675[(9)]);
var state_16675__$1 = state_16675;
var statearr_16683_16710 = state_16675__$1;
(statearr_16683_16710[(2)] = inst_16635);

(statearr_16683_16710[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (6))){
var inst_16635 = (state_16675[(9)]);
var inst_16640 = inst_16635.cljs$lang$protocol_mask$partition0$;
var inst_16641 = (inst_16640 & (64));
var inst_16642 = inst_16635.cljs$core$ISeq$;
var inst_16643 = (cljs.core.PROTOCOL_SENTINEL === inst_16642);
var inst_16644 = ((inst_16641) || (inst_16643));
var state_16675__$1 = state_16675;
if(cljs.core.truth_(inst_16644)){
var statearr_16684_16711 = state_16675__$1;
(statearr_16684_16711[(1)] = (9));

} else {
var statearr_16685_16712 = state_16675__$1;
(statearr_16685_16712[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (3))){
var inst_16673 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16675__$1,inst_16673);
} else {
if((state_val_16676 === (12))){
var inst_16635 = (state_16675[(9)]);
var inst_16653 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16635);
var state_16675__$1 = state_16675;
var statearr_16686_16713 = state_16675__$1;
(statearr_16686_16713[(2)] = inst_16653);

(statearr_16686_16713[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (2))){
var inst_16635 = (state_16675[(9)]);
var _ = (function (){var statearr_16687 = state_16675;
(statearr_16687[(4)] = cljs.core.cons.call(null,(5),(state_16675[(4)])));

return statearr_16687;
})();
var inst_16635__$1 = db;
var inst_16637 = (inst_16635__$1 == null);
var inst_16638 = cljs.core.not.call(null,inst_16637);
var state_16675__$1 = (function (){var statearr_16688 = state_16675;
(statearr_16688[(9)] = inst_16635__$1);

return statearr_16688;
})();
if(inst_16638){
var statearr_16689_16714 = state_16675__$1;
(statearr_16689_16714[(1)] = (6));

} else {
var statearr_16690_16715 = state_16675__$1;
(statearr_16690_16715[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (11))){
var inst_16648 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
var statearr_16692_16716 = state_16675__$1;
(statearr_16692_16716[(2)] = inst_16648);

(statearr_16692_16716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (9))){
var state_16675__$1 = state_16675;
var statearr_16693_16717 = state_16675__$1;
(statearr_16693_16717[(2)] = true);

(statearr_16693_16717[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (5))){
var _ = (function (){var statearr_16694 = state_16675;
(statearr_16694[(4)] = cljs.core.rest.call(null,(state_16675[(4)])));

return statearr_16694;
})();
var state_16675__$1 = state_16675;
var ex16691 = (state_16675__$1[(2)]);
var statearr_16695_16718 = state_16675__$1;
(statearr_16695_16718[(5)] = ex16691);


if((ex16691 instanceof Error)){
var statearr_16696_16719 = state_16675__$1;
(statearr_16696_16719[(1)] = (4));

(statearr_16696_16719[(5)] = null);

} else {
throw ex16691;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (14))){
var inst_16661 = (state_16675[(7)]);
var inst_16656 = (state_16675[(2)]);
var inst_16657 = cljs.core.get.call(null,inst_16656,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16658 = cljs.core.get.call(null,inst_16656,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16659 = cljs.core.get.call(null,inst_16656,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_16660 = cljs.core.get.call(null,inst_16656,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16661__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_16658,inst_16659,inst_16660);
var inst_16662 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_16663 = [inst_16659,inst_16660,garbage];
var inst_16664 = cljs.core.PersistentHashMap.fromArrays(inst_16662,inst_16663);
var inst_16665 = fluree.db.storage.core.serde.call(null,inst_16657);
var inst_16666 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_16665,inst_16664);
var inst_16667 = fluree.db.storage.core.storage_write.call(null,inst_16657,inst_16661__$1,inst_16666);
var state_16675__$1 = (function (){var statearr_16697 = state_16675;
(statearr_16697[(7)] = inst_16661__$1);

return statearr_16697;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16675__$1,(15),inst_16667);
} else {
if((state_val_16676 === (10))){
var state_16675__$1 = state_16675;
var statearr_16698_16720 = state_16675__$1;
(statearr_16698_16720[(2)] = false);

(statearr_16698_16720[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16676 === (8))){
var inst_16651 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
if(cljs.core.truth_(inst_16651)){
var statearr_16699_16721 = state_16675__$1;
(statearr_16699_16721[(1)] = (12));

} else {
var statearr_16700_16722 = state_16675__$1;
(statearr_16700_16722[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2468__auto____0 = (function (){
var statearr_16701 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16701[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2468__auto__);

(statearr_16701[(1)] = (1));

return statearr_16701;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2468__auto____1 = (function (state_16675){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16702){var ex__2471__auto__ = e16702;
var statearr_16703_16723 = state_16675;
(statearr_16703_16723[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16675[(4)]))){
var statearr_16704_16724 = state_16675;
(statearr_16704_16724[(1)] = cljs.core.first.call(null,(state_16675[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16725 = state_16675;
state_16675 = G__16725;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2468__auto__ = function(state_16675){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2468__auto____1.call(this,state_16675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2468__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2468__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16705 = f__2491__auto__.call(null);
(statearr_16705[(6)] = c__2490__auto__);

return statearr_16705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__16727 = arguments.length;
switch (G__16727) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16803){
var state_val_16804 = (state_16803[(1)]);
if((state_val_16804 === (7))){
var state_16803__$1 = state_16803;
var statearr_16805_16844 = state_16803__$1;
(statearr_16805_16844[(2)] = false);

(statearr_16805_16844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (20))){
var inst_16759 = (state_16803[(7)]);
var inst_16765 = (state_16803[(8)]);
var inst_16767 = (state_16803[(9)]);
var inst_16760 = (state_16803[(10)]);
var inst_16762 = (state_16803[(11)]);
var inst_16772 = (state_16803[(12)]);
var inst_16777 = (state_16803[(13)]);
var inst_16761 = (state_16803[(14)]);
var inst_16768 = (state_16803[(15)]);
var inst_16758 = (state_16803[(16)]);
var inst_16771 = (state_16803[(17)]);
var inst_16770 = (state_16803[(18)]);
var inst_16763 = (state_16803[(19)]);
var inst_16769 = (state_16803[(20)]);
var inst_16782 = (state_16803[(2)]);
var inst_16783 = fluree.db.storage.core.child_data.call(null,inst_16767);
var inst_16784 = fluree.db.storage.core.child_data.call(null,inst_16769);
var inst_16785 = fluree.db.util.core.current_time_millis.call(null);
var inst_16786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16787 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_16788 = (new cljs.core.PersistentVector(null,2,(5),inst_16786,inst_16787,null));
var inst_16789 = cljs.core.select_keys.call(null,inst_16761,inst_16788);
var inst_16790 = fluree.db.storage.core.child_data.call(null,inst_16760);
var inst_16791 = [inst_16763,inst_16772,inst_16765,inst_16777,inst_16782,inst_16783,inst_16784,inst_16758,inst_16785,inst_16759,inst_16768,inst_16789,inst_16790];
var inst_16792 = cljs.core.PersistentHashMap.fromArrays(inst_16771,inst_16791);
var inst_16793 = fluree.db.storage.core.serde.call(null,inst_16762);
var inst_16794 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_16793,inst_16792);
var inst_16795 = fluree.db.storage.core.storage_write.call(null,inst_16762,inst_16770,inst_16794);
var state_16803__$1 = state_16803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16803__$1,(21),inst_16795);
} else {
if((state_val_16804 === (1))){
var state_16803__$1 = state_16803;
var statearr_16806_16845 = state_16803__$1;
(statearr_16806_16845[(2)] = null);

(statearr_16806_16845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (4))){
var inst_16728 = (state_16803[(2)]);
var state_16803__$1 = state_16803;
var statearr_16807_16846 = state_16803__$1;
(statearr_16807_16846[(2)] = inst_16728);

(statearr_16807_16846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (15))){
var inst_16773 = (state_16803[(21)]);
var state_16803__$1 = state_16803;
var statearr_16808_16847 = state_16803__$1;
(statearr_16808_16847[(2)] = inst_16773);

(statearr_16808_16847[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (21))){
var inst_16770 = (state_16803[(18)]);
var inst_16797 = (state_16803[(2)]);
var inst_16798 = fluree.db.util.async.throw_err.call(null,inst_16797);
var _ = (function (){var statearr_16809 = state_16803;
(statearr_16809[(4)] = cljs.core.rest.call(null,(state_16803[(4)])));

return statearr_16809;
})();
var state_16803__$1 = (function (){var statearr_16810 = state_16803;
(statearr_16810[(22)] = inst_16798);

return statearr_16810;
})();
var statearr_16811_16848 = state_16803__$1;
(statearr_16811_16848[(2)] = inst_16770);

(statearr_16811_16848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (13))){
var inst_16735 = (state_16803[(23)]);
var state_16803__$1 = state_16803;
var statearr_16812_16849 = state_16803__$1;
(statearr_16812_16849[(2)] = inst_16735);

(statearr_16812_16849[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (6))){
var inst_16735 = (state_16803[(23)]);
var inst_16740 = inst_16735.cljs$lang$protocol_mask$partition0$;
var inst_16741 = (inst_16740 & (64));
var inst_16742 = inst_16735.cljs$core$ISeq$;
var inst_16743 = (cljs.core.PROTOCOL_SENTINEL === inst_16742);
var inst_16744 = ((inst_16741) || (inst_16743));
var state_16803__$1 = state_16803;
if(cljs.core.truth_(inst_16744)){
var statearr_16813_16850 = state_16803__$1;
(statearr_16813_16850[(1)] = (9));

} else {
var statearr_16814_16851 = state_16803__$1;
(statearr_16814_16851[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (17))){
var inst_16778 = (state_16803[(24)]);
var inst_16777 = (state_16803[(2)]);
var inst_16778__$1 = custom_ecount;
var state_16803__$1 = (function (){var statearr_16815 = state_16803;
(statearr_16815[(13)] = inst_16777);

(statearr_16815[(24)] = inst_16778__$1);

return statearr_16815;
})();
if(cljs.core.truth_(inst_16778__$1)){
var statearr_16816_16852 = state_16803__$1;
(statearr_16816_16852[(1)] = (18));

} else {
var statearr_16817_16853 = state_16803__$1;
(statearr_16817_16853[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (3))){
var inst_16801 = (state_16803[(2)]);
var state_16803__$1 = state_16803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16803__$1,inst_16801);
} else {
if((state_val_16804 === (12))){
var inst_16735 = (state_16803[(23)]);
var inst_16753 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16735);
var state_16803__$1 = state_16803;
var statearr_16818_16854 = state_16803__$1;
(statearr_16818_16854[(2)] = inst_16753);

(statearr_16818_16854[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (2))){
var inst_16735 = (state_16803[(23)]);
var _ = (function (){var statearr_16819 = state_16803;
(statearr_16819[(4)] = cljs.core.cons.call(null,(5),(state_16803[(4)])));

return statearr_16819;
})();
var inst_16735__$1 = db;
var inst_16737 = (inst_16735__$1 == null);
var inst_16738 = cljs.core.not.call(null,inst_16737);
var state_16803__$1 = (function (){var statearr_16820 = state_16803;
(statearr_16820[(23)] = inst_16735__$1);

return statearr_16820;
})();
if(inst_16738){
var statearr_16821_16855 = state_16803__$1;
(statearr_16821_16855[(1)] = (6));

} else {
var statearr_16822_16856 = state_16803__$1;
(statearr_16822_16856[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (19))){
var inst_16766 = (state_16803[(25)]);
var state_16803__$1 = state_16803;
var statearr_16823_16857 = state_16803__$1;
(statearr_16823_16857[(2)] = inst_16766);

(statearr_16823_16857[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (11))){
var inst_16748 = (state_16803[(2)]);
var state_16803__$1 = state_16803;
var statearr_16825_16858 = state_16803__$1;
(statearr_16825_16858[(2)] = inst_16748);

(statearr_16825_16858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (9))){
var state_16803__$1 = state_16803;
var statearr_16826_16859 = state_16803__$1;
(statearr_16826_16859[(2)] = true);

(statearr_16826_16859[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (5))){
var _ = (function (){var statearr_16827 = state_16803;
(statearr_16827[(4)] = cljs.core.rest.call(null,(state_16803[(4)])));

return statearr_16827;
})();
var state_16803__$1 = state_16803;
var ex16824 = (state_16803__$1[(2)]);
var statearr_16828_16860 = state_16803__$1;
(statearr_16828_16860[(5)] = ex16824);


if((ex16824 instanceof Error)){
var statearr_16829_16861 = state_16803__$1;
(statearr_16829_16861[(1)] = (4));

(statearr_16829_16861[(5)] = null);

} else {
throw ex16824;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (14))){
var inst_16773 = (state_16803[(21)]);
var inst_16765 = (state_16803[(8)]);
var inst_16761 = (state_16803[(14)]);
var inst_16763 = (state_16803[(19)]);
var inst_16756 = (state_16803[(2)]);
var inst_16757 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_16758 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_16759 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_16760 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_16761__$1 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_16762 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_16763__$1 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"block","block",664686210));
var inst_16764 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_16765__$1 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_16766 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_16767 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_16768 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_16769 = cljs.core.get.call(null,inst_16756,new cljs.core.Keyword(null,"post","post",269697687));
var inst_16770 = fluree.db.storage.core.ledger_root_key.call(null,inst_16757,inst_16765__$1,inst_16763__$1);
var inst_16771 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_16772 = fluree.db.storage.core.child_data.call(null,inst_16764);
var inst_16773__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_16761__$1);
var state_16803__$1 = (function (){var statearr_16830 = state_16803;
(statearr_16830[(7)] = inst_16759);

(statearr_16830[(21)] = inst_16773__$1);

(statearr_16830[(8)] = inst_16765__$1);

(statearr_16830[(9)] = inst_16767);

(statearr_16830[(10)] = inst_16760);

(statearr_16830[(11)] = inst_16762);

(statearr_16830[(12)] = inst_16772);

(statearr_16830[(14)] = inst_16761__$1);

(statearr_16830[(25)] = inst_16766);

(statearr_16830[(15)] = inst_16768);

(statearr_16830[(16)] = inst_16758);

(statearr_16830[(17)] = inst_16771);

(statearr_16830[(18)] = inst_16770);

(statearr_16830[(19)] = inst_16763__$1);

(statearr_16830[(20)] = inst_16769);

return statearr_16830;
})();
if(cljs.core.truth_(inst_16773__$1)){
var statearr_16831_16862 = state_16803__$1;
(statearr_16831_16862[(1)] = (15));

} else {
var statearr_16832_16863 = state_16803__$1;
(statearr_16832_16863[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (16))){
var state_16803__$1 = state_16803;
var statearr_16833_16864 = state_16803__$1;
(statearr_16833_16864[(2)] = (0));

(statearr_16833_16864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (10))){
var state_16803__$1 = state_16803;
var statearr_16834_16865 = state_16803__$1;
(statearr_16834_16865[(2)] = false);

(statearr_16834_16865[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (18))){
var inst_16778 = (state_16803[(24)]);
var state_16803__$1 = state_16803;
var statearr_16835_16866 = state_16803__$1;
(statearr_16835_16866[(2)] = inst_16778);

(statearr_16835_16866[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16804 === (8))){
var inst_16751 = (state_16803[(2)]);
var state_16803__$1 = state_16803;
if(cljs.core.truth_(inst_16751)){
var statearr_16836_16867 = state_16803__$1;
(statearr_16836_16867[(1)] = (12));

} else {
var statearr_16837_16868 = state_16803__$1;
(statearr_16837_16868[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2468__auto__ = null;
var fluree$db$storage$core$state_machine__2468__auto____0 = (function (){
var statearr_16838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16838[(0)] = fluree$db$storage$core$state_machine__2468__auto__);

(statearr_16838[(1)] = (1));

return statearr_16838;
});
var fluree$db$storage$core$state_machine__2468__auto____1 = (function (state_16803){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16839){var ex__2471__auto__ = e16839;
var statearr_16840_16869 = state_16803;
(statearr_16840_16869[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16803[(4)]))){
var statearr_16841_16870 = state_16803;
(statearr_16841_16870[(1)] = cljs.core.first.call(null,(state_16803[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16871 = state_16803;
state_16803 = G__16871;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2468__auto__ = function(state_16803){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2468__auto____1.call(this,state_16803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2468__auto____0;
fluree$db$storage$core$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2468__auto____1;
return fluree$db$storage$core$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16842 = f__2491__auto__.call(null);
(statearr_16842[(6)] = c__2490__auto__);

return statearr_16842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2490__auto___16923 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16901){
var state_val_16902 = (state_16901[(1)]);
if((state_val_16902 === (7))){
var inst_16888 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_16901__$1 = state_16901;
var statearr_16903_16924 = state_16901__$1;
(statearr_16903_16924[(2)] = inst_16888);

(statearr_16903_16924[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16902 === (1))){
var state_16901__$1 = state_16901;
var statearr_16904_16925 = state_16901__$1;
(statearr_16904_16925[(2)] = null);

(statearr_16904_16925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16902 === (4))){
var inst_16872 = (state_16901[(2)]);
var inst_16873 = error_fn.call(null);
var inst_16874 = cljs.core.async.put_BANG_.call(null,return_ch,inst_16872);
var inst_16875 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_16901__$1 = (function (){var statearr_16905 = state_16901;
(statearr_16905[(7)] = inst_16873);

(statearr_16905[(8)] = inst_16874);

return statearr_16905;
})();
var statearr_16906_16926 = state_16901__$1;
(statearr_16906_16926[(2)] = inst_16875);

(statearr_16906_16926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16902 === (6))){
var inst_16883 = (state_16901[(9)]);
var inst_16883__$1 = (state_16901[(2)]);
var inst_16884 = (inst_16883__$1 == null);
var inst_16885 = (inst_16883__$1 instanceof Error);
var inst_16886 = ((inst_16884) || (inst_16885));
var state_16901__$1 = (function (){var statearr_16907 = state_16901;
(statearr_16907[(9)] = inst_16883__$1);

return statearr_16907;
})();
if(cljs.core.truth_(inst_16886)){
var statearr_16908_16927 = state_16901__$1;
(statearr_16908_16927[(1)] = (7));

} else {
var statearr_16909_16928 = state_16901__$1;
(statearr_16909_16928[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16902 === (3))){
var inst_16899 = (state_16901[(2)]);
var state_16901__$1 = state_16901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16901__$1,inst_16899);
} else {
if((state_val_16902 === (2))){
var _ = (function (){var statearr_16911 = state_16901;
(statearr_16911[(4)] = cljs.core.cons.call(null,(5),(state_16901[(4)])));

return statearr_16911;
})();
var inst_16881 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_16901__$1 = state_16901;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16901__$1,(6),inst_16881);
} else {
if((state_val_16902 === (9))){
var inst_16896 = (state_16901[(2)]);
var _ = (function (){var statearr_16912 = state_16901;
(statearr_16912[(4)] = cljs.core.rest.call(null,(state_16901[(4)])));

return statearr_16912;
})();
var state_16901__$1 = state_16901;
var statearr_16913_16929 = state_16901__$1;
(statearr_16913_16929[(2)] = inst_16896);

(statearr_16913_16929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16902 === (5))){
var _ = (function (){var statearr_16914 = state_16901;
(statearr_16914[(4)] = cljs.core.rest.call(null,(state_16901[(4)])));

return statearr_16914;
})();
var state_16901__$1 = state_16901;
var ex16910 = (state_16901__$1[(2)]);
var statearr_16915_16930 = state_16901__$1;
(statearr_16915_16930[(5)] = ex16910);


if((ex16910 instanceof java.lang.Exception)){
var statearr_16916_16931 = state_16901__$1;
(statearr_16916_16931[(1)] = (4));

(statearr_16916_16931[(5)] = null);

} else {
throw ex16910;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16902 === (8))){
var inst_16883 = (state_16901[(9)]);
var inst_16890 = fluree.db.storage.core.serde.call(null,conn);
var inst_16891 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_16890,inst_16883);
var inst_16892 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_16891);
var inst_16893 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_16892);
var inst_16894 = cljs.core.async.put_BANG_.call(null,return_ch,inst_16893);
var state_16901__$1 = state_16901;
var statearr_16917_16932 = state_16901__$1;
(statearr_16917_16932[(2)] = inst_16894);

(statearr_16917_16932[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2468__auto____0 = (function (){
var statearr_16918 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16918[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2468__auto__);

(statearr_16918[(1)] = (1));

return statearr_16918;
});
var fluree$db$storage$core$reify_history_$_state_machine__2468__auto____1 = (function (state_16901){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16919){var ex__2471__auto__ = e16919;
var statearr_16920_16933 = state_16901;
(statearr_16920_16933[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16901[(4)]))){
var statearr_16921_16934 = state_16901;
(statearr_16921_16934[(1)] = cljs.core.first.call(null,(state_16901[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16935 = state_16901;
state_16901 = G__16935;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2468__auto__ = function(state_16901){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2468__auto____1.call(this,state_16901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2468__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2468__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16922 = f__2491__auto__.call(null);
(statearr_16922[(6)] = c__2490__auto___16923);

return statearr_16922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__16937 = arguments.length;
switch (G__16937) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2490__auto___17047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17000){
var state_val_17001 = (state_17000[(1)]);
if((state_val_17001 === (7))){
var state_17000__$1 = state_17000;
var statearr_17002_17048 = state_17000__$1;
(statearr_17002_17048[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17002_17048[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (20))){
var inst_16979 = cljs.core.PersistentVector.EMPTY;
var state_17000__$1 = state_17000;
var statearr_17003_17049 = state_17000__$1;
(statearr_17003_17049[(2)] = inst_16979);

(statearr_17003_17049[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (1))){
var state_17000__$1 = state_17000;
var statearr_17004_17050 = state_17000__$1;
(statearr_17004_17050[(2)] = null);

(statearr_17004_17050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (24))){
var state_17000__$1 = state_17000;
var statearr_17005_17051 = state_17000__$1;
(statearr_17005_17051[(2)] = null);

(statearr_17005_17051[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (4))){
var inst_16940 = (state_17000[(2)]);
var inst_16941 = error_fn.call(null);
var inst_16942 = cljs.core.async.put_BANG_.call(null,result_ch,inst_16940);
var inst_16943 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_17000__$1 = (function (){var statearr_17006 = state_17000;
(statearr_17006[(7)] = inst_16942);

(statearr_17006[(8)] = inst_16941);

return statearr_17006;
})();
var statearr_17007_17052 = state_17000__$1;
(statearr_17007_17052[(2)] = inst_16943);

(statearr_17007_17052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (15))){
var inst_16965 = (state_17000[(2)]);
var state_17000__$1 = state_17000;
var statearr_17008_17053 = state_17000__$1;
(statearr_17008_17053[(2)] = inst_16965);

(statearr_17008_17053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (21))){
var inst_16969 = (state_17000[(9)]);
var inst_16953 = (state_17000[(10)]);
var inst_16982 = (state_17000[(11)]);
var inst_16952 = (state_17000[(12)]);
var inst_16954 = (state_17000[(13)]);
var inst_16989 = (state_17000[(2)]);
var inst_16990 = (function (){var base_node = inst_16952;
var first_flake = inst_16953;
var node_t = inst_16954;
var source = inst_16969;
var coll = inst_16982;
var conj_QMARK_ = inst_16989;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_16991 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_16952);
var inst_16992 = cljs.core.reduce.call(null,inst_16990,inst_16991,inst_16982);
var inst_16993 = cljs.core.doall.call(null,inst_16992);
var inst_16994 = cljs.core.assoc.call(null,inst_16952,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_16993);
var inst_16995 = cljs.core.async.put_BANG_.call(null,result_ch,inst_16994);
var _ = (function (){var statearr_17009 = state_17000;
(statearr_17009[(4)] = cljs.core.rest.call(null,(state_17000[(4)])));

return statearr_17009;
})();
var state_17000__$1 = state_17000;
var statearr_17010_17054 = state_17000__$1;
(statearr_17010_17054[(2)] = inst_16995);

(statearr_17010_17054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (13))){
var state_17000__$1 = state_17000;
var statearr_17011_17055 = state_17000__$1;
(statearr_17011_17055[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17011_17055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (22))){
var inst_16969 = (state_17000[(9)]);
var inst_16953 = (state_17000[(10)]);
var inst_16982 = (state_17000[(11)]);
var inst_16952 = (state_17000[(12)]);
var inst_16954 = (state_17000[(13)]);
var inst_16983 = (function (){var base_node = inst_16952;
var first_flake = inst_16953;
var node_t = inst_16954;
var source = inst_16969;
var coll = inst_16982;
return (function (f){
return f.op === true;
});
})();
var state_17000__$1 = state_17000;
var statearr_17012_17056 = state_17000__$1;
(statearr_17012_17056[(2)] = inst_16983);

(statearr_17012_17056[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (6))){
var inst_16952 = (state_17000[(12)]);
var inst_16954 = (state_17000[(13)]);
var inst_16951 = (state_17000[(2)]);
var inst_16952__$1 = fluree.db.util.async.throw_err.call(null,inst_16951);
var inst_16953 = fluree.db.dbproto._first_flake.call(null,inst_16952__$1);
var inst_16954__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_16952__$1);
var inst_16955 = (inst_16954__$1 > t);
var state_17000__$1 = (function (){var statearr_17013 = state_17000;
(statearr_17013[(10)] = inst_16953);

(statearr_17013[(12)] = inst_16952__$1);

(statearr_17013[(13)] = inst_16954__$1);

return statearr_17013;
})();
if(cljs.core.truth_(inst_16955)){
var statearr_17014_17057 = state_17000__$1;
(statearr_17014_17057[(1)] = (7));

} else {
var statearr_17015_17058 = state_17000__$1;
(statearr_17015_17058[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (17))){
var inst_16953 = (state_17000[(10)]);
var inst_16970 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_16953,rhs,leftmost_QMARK_,t);
var state_17000__$1 = state_17000;
var statearr_17016_17059 = state_17000__$1;
(statearr_17016_17059[(2)] = inst_16970);

(statearr_17016_17059[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (3))){
var inst_16998 = (state_17000[(2)]);
var state_17000__$1 = state_17000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17000__$1,inst_16998);
} else {
if((state_val_17001 === (12))){
var inst_16967 = (state_17000[(2)]);
var state_17000__$1 = state_17000;
var statearr_17017_17060 = state_17000__$1;
(statearr_17017_17060[(2)] = inst_16967);

(statearr_17017_17060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (2))){
var _ = (function (){var statearr_17018 = state_17000;
(statearr_17018[(4)] = cljs.core.cons.call(null,(5),(state_17000[(4)])));

return statearr_17018;
})();
var inst_16949 = fluree.db.dbproto._resolve.call(null,node);
var state_17000__$1 = state_17000;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17000__$1,(6),inst_16949);
} else {
if((state_val_17001 === (23))){
var inst_16969 = (state_17000[(9)]);
var inst_16953 = (state_17000[(10)]);
var inst_16982 = (state_17000[(11)]);
var inst_16952 = (state_17000[(12)]);
var inst_16954 = (state_17000[(13)]);
var inst_16985 = (function (){var base_node = inst_16952;
var first_flake = inst_16953;
var node_t = inst_16954;
var source = inst_16969;
var coll = inst_16982;
return (function (f){
return f.op === false;
});
})();
var state_17000__$1 = state_17000;
var statearr_17019_17061 = state_17000__$1;
(statearr_17019_17061[(2)] = inst_16985);

(statearr_17019_17061[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (19))){
var inst_16972 = (state_17000[(14)]);
var inst_16975 = (state_17000[(2)]);
var inst_16976 = fluree.db.util.async.throw_err.call(null,inst_16975);
var inst_16977 = cljs.core.take_while.call(null,inst_16972,inst_16976);
var state_17000__$1 = state_17000;
var statearr_17020_17062 = state_17000__$1;
(statearr_17020_17062[(2)] = inst_16977);

(statearr_17020_17062[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (11))){
var inst_16954 = (state_17000[(13)]);
var inst_16961 = cljs.core._EQ_.call(null,inst_16954,t);
var state_17000__$1 = state_17000;
if(inst_16961){
var statearr_17022_17063 = state_17000__$1;
(statearr_17022_17063[(1)] = (13));

} else {
var statearr_17023_17064 = state_17000__$1;
(statearr_17023_17064[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (9))){
var inst_16969 = (state_17000[(9)]);
var inst_16969__$1 = (state_17000[(2)]);
var state_17000__$1 = (function (){var statearr_17024 = state_17000;
(statearr_17024[(9)] = inst_16969__$1);

return statearr_17024;
})();
var G__17025_17065 = inst_16969__$1;
var G__17025_17066__$1 = (((G__17025_17065 instanceof cljs.core.Keyword))?G__17025_17065.fqn:null);
switch (G__17025_17066__$1) {
case "novelty":
var statearr_17026_17068 = state_17000__$1;
(statearr_17026_17068[(1)] = (17));


break;
case "history":
var statearr_17027_17069 = state_17000__$1;
(statearr_17027_17069[(1)] = (18));


break;
case "none":
var statearr_17028_17070 = state_17000__$1;
(statearr_17028_17070[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17025_17066__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (5))){
var _ = (function (){var statearr_17029 = state_17000;
(statearr_17029[(4)] = cljs.core.rest.call(null,(state_17000[(4)])));

return statearr_17029;
})();
var state_17000__$1 = state_17000;
var ex17021 = (state_17000__$1[(2)]);
var statearr_17030_17071 = state_17000__$1;
(statearr_17030_17071[(5)] = ex17021);


if((ex17021 instanceof java.lang.Exception)){
var statearr_17031_17072 = state_17000__$1;
(statearr_17031_17072[(1)] = (4));

(statearr_17031_17072[(5)] = null);

} else {
throw ex17021;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (14))){
var state_17000__$1 = state_17000;
var statearr_17032_17073 = state_17000__$1;
(statearr_17032_17073[(2)] = null);

(statearr_17032_17073[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (16))){
var inst_16969 = (state_17000[(9)]);
var inst_16982 = (state_17000[(2)]);
var state_17000__$1 = (function (){var statearr_17033 = state_17000;
(statearr_17033[(11)] = inst_16982);

return statearr_17033;
})();
var G__17034_17074 = inst_16969;
var G__17034_17075__$1 = (((G__17034_17074 instanceof cljs.core.Keyword))?G__17034_17074.fqn:null);
switch (G__17034_17075__$1) {
case "novelty":
var statearr_17035_17077 = state_17000__$1;
(statearr_17035_17077[(1)] = (22));


break;
case "history":
var statearr_17036_17078 = state_17000__$1;
(statearr_17036_17078[(1)] = (23));


break;
case "none":
var statearr_17037_17079 = state_17000__$1;
(statearr_17037_17079[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17034_17075__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (10))){
var state_17000__$1 = state_17000;
var statearr_17038_17080 = state_17000__$1;
(statearr_17038_17080[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17038_17080[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17001 === (18))){
var inst_16969 = (state_17000[(9)]);
var inst_16953 = (state_17000[(10)]);
var inst_16952 = (state_17000[(12)]);
var inst_16954 = (state_17000[(13)]);
var inst_16972 = (function (){var base_node = inst_16952;
var first_flake = inst_16953;
var node_t = inst_16954;
var source = inst_16969;
return (function (p1__16939_SHARP_){
return (p1__16939_SHARP_.t <= t);
});
})();
var inst_16973 = fluree.db.dbproto._resolve_history.call(null,node);
var state_17000__$1 = (function (){var statearr_17039 = state_17000;
(statearr_17039[(14)] = inst_16972);

return statearr_17039;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17000__$1,(19),inst_16973);
} else {
if((state_val_17001 === (8))){
var inst_16954 = (state_17000[(13)]);
var inst_16958 = (inst_16954 < t);
var state_17000__$1 = state_17000;
if(cljs.core.truth_(inst_16958)){
var statearr_17040_17081 = state_17000__$1;
(statearr_17040_17081[(1)] = (10));

} else {
var statearr_17041_17082 = state_17000__$1;
(statearr_17041_17082[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2468__auto____0 = (function (){
var statearr_17042 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17042[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2468__auto__);

(statearr_17042[(1)] = (1));

return statearr_17042;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2468__auto____1 = (function (state_17000){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17043){var ex__2471__auto__ = e17043;
var statearr_17044_17083 = state_17000;
(statearr_17044_17083[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17000[(4)]))){
var statearr_17045_17084 = state_17000;
(statearr_17045_17084[(1)] = cljs.core.first.call(null,(state_17000[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17085 = state_17000;
state_17000 = G__17085;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2468__auto__ = function(state_17000){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2468__auto____1.call(this,state_17000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2468__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2468__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17046 = f__2491__auto__.call(null);
(statearr_17046[(6)] = c__2490__auto___17047);

return statearr_17046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17142){
var state_val_17143 = (state_17142[(1)]);
if((state_val_17143 === (7))){
var state_17142__$1 = state_17142;
var statearr_17144_17180 = state_17142__$1;
(statearr_17144_17180[(2)] = null);

(statearr_17144_17180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (1))){
var state_17142__$1 = state_17142;
var statearr_17145_17181 = state_17142__$1;
(statearr_17145_17181[(2)] = null);

(statearr_17145_17181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (4))){
var inst_17088 = (state_17142[(2)]);
var inst_17089 = fluree.db.util.log.error.call(null,inst_17088);
var inst_17090 = (function(){throw inst_17088})();
var state_17142__$1 = (function (){var statearr_17146 = state_17142;
(statearr_17146[(7)] = inst_17089);

return statearr_17146;
})();
var statearr_17147_17182 = state_17142__$1;
(statearr_17147_17182[(2)] = inst_17090);

(statearr_17147_17182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (15))){
var inst_17118 = (state_17142[(2)]);
var state_17142__$1 = state_17142;
var statearr_17148_17183 = state_17142__$1;
(statearr_17148_17183[(2)] = inst_17118);

(statearr_17148_17183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (13))){
var inst_17112 = (state_17142[(8)]);
var inst_17096 = (state_17142[(9)]);
var inst_17114 = (function (){var node_t = inst_17096;
var G__17101 = inst_17112;
return (function (p1__17087_SHARP_){
return (p1__17087_SHARP_.t <= from_t);
});
})();
var inst_17115 = cljs.core.take_while.call(null,inst_17114,inst_17112);
var state_17142__$1 = state_17142;
var statearr_17149_17184 = state_17142__$1;
(statearr_17149_17184[(2)] = inst_17115);

(statearr_17149_17184[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (6))){
var inst_17102 = fluree.db.dbproto._resolve_history.call(null,node);
var state_17142__$1 = state_17142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17142__$1,(9),inst_17102);
} else {
if((state_val_17143 === (17))){
var inst_17127 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_17128 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17127)].join('');
var inst_17129 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17130 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_17131 = cljs.core.PersistentHashMap.fromArrays(inst_17129,inst_17130);
var inst_17132 = cljs.core.ex_info.call(null,inst_17128,inst_17131);
var inst_17133 = (function(){throw inst_17132})();
var state_17142__$1 = state_17142;
var statearr_17150_17185 = state_17142__$1;
(statearr_17150_17185[(2)] = inst_17133);

(statearr_17150_17185[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (3))){
var inst_17140 = (state_17142[(2)]);
var state_17142__$1 = state_17142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17142__$1,inst_17140);
} else {
if((state_val_17143 === (12))){
var inst_17112 = (state_17142[(2)]);
var state_17142__$1 = (function (){var statearr_17151 = state_17142;
(statearr_17151[(8)] = inst_17112);

return statearr_17151;
})();
if(cljs.core.truth_(from_t)){
var statearr_17152_17186 = state_17142__$1;
(statearr_17152_17186[(1)] = (13));

} else {
var statearr_17153_17187 = state_17142__$1;
(statearr_17153_17187[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (2))){
var inst_17096 = (state_17142[(9)]);
var _ = (function (){var statearr_17154 = state_17142;
(statearr_17154[(4)] = cljs.core.cons.call(null,(5),(state_17142[(4)])));

return statearr_17154;
})();
var inst_17096__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17097 = (from_t == null);
var inst_17098 = (inst_17096__$1 <= from_t);
var inst_17099 = ((inst_17097) || (inst_17098));
var state_17142__$1 = (function (){var statearr_17155 = state_17142;
(statearr_17155[(9)] = inst_17096__$1);

return statearr_17155;
})();
if(cljs.core.truth_(inst_17099)){
var statearr_17156_17188 = state_17142__$1;
(statearr_17156_17188[(1)] = (6));

} else {
var statearr_17157_17189 = state_17142__$1;
(statearr_17157_17189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (11))){
var inst_17105 = (state_17142[(10)]);
var state_17142__$1 = state_17142;
var statearr_17159_17190 = state_17142__$1;
(statearr_17159_17190[(2)] = inst_17105);

(statearr_17159_17190[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (9))){
var inst_17096 = (state_17142[(9)]);
var inst_17104 = (state_17142[(2)]);
var inst_17105 = fluree.db.util.async.throw_err.call(null,inst_17104);
var inst_17106 = (to_t > inst_17096);
var state_17142__$1 = (function (){var statearr_17160 = state_17142;
(statearr_17160[(10)] = inst_17105);

return statearr_17160;
})();
if(cljs.core.truth_(inst_17106)){
var statearr_17161_17191 = state_17142__$1;
(statearr_17161_17191[(1)] = (10));

} else {
var statearr_17162_17192 = state_17142__$1;
(statearr_17162_17192[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (5))){
var _ = (function (){var statearr_17163 = state_17142;
(statearr_17163[(4)] = cljs.core.rest.call(null,(state_17142[(4)])));

return statearr_17163;
})();
var state_17142__$1 = state_17142;
var ex17158 = (state_17142__$1[(2)]);
var statearr_17164_17193 = state_17142__$1;
(statearr_17164_17193[(5)] = ex17158);


if((ex17158 instanceof java.lang.Exception)){
var statearr_17165_17194 = state_17142__$1;
(statearr_17165_17194[(1)] = (4));

(statearr_17165_17194[(5)] = null);

} else {
throw ex17158;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (14))){
var inst_17112 = (state_17142[(8)]);
var state_17142__$1 = state_17142;
var statearr_17166_17195 = state_17142__$1;
(statearr_17166_17195[(2)] = inst_17112);

(statearr_17166_17195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (16))){
var state_17142__$1 = state_17142;
var statearr_17167_17196 = state_17142__$1;
(statearr_17167_17196[(2)] = null);

(statearr_17167_17196[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (10))){
var inst_17105 = (state_17142[(10)]);
var inst_17096 = (state_17142[(9)]);
var inst_17108 = (function (){var node_t = inst_17096;
var G__17101 = inst_17105;
return (function (p1__17086_SHARP_){
return (p1__17086_SHARP_.t < to_t);
});
})();
var inst_17109 = cljs.core.drop_while.call(null,inst_17108,inst_17105);
var state_17142__$1 = state_17142;
var statearr_17168_17197 = state_17142__$1;
(statearr_17168_17197[(2)] = inst_17109);

(statearr_17168_17197[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (18))){
var inst_17122 = (state_17142[(11)]);
var inst_17123 = (state_17142[(12)]);
var inst_17121 = (state_17142[(13)]);
var inst_17135 = (state_17142[(2)]);
var inst_17136 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_17122,inst_17123,leftmost_QMARK_,to_t);
var inst_17137 = cljs.core.into.call(null,inst_17136,inst_17121);
var _ = (function (){var statearr_17169 = state_17142;
(statearr_17169[(4)] = cljs.core.rest.call(null,(state_17142[(4)])));

return statearr_17169;
})();
var state_17142__$1 = (function (){var statearr_17170 = state_17142;
(statearr_17170[(14)] = inst_17135);

return statearr_17170;
})();
var statearr_17171_17198 = state_17142__$1;
(statearr_17171_17198[(2)] = inst_17137);

(statearr_17171_17198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17143 === (8))){
var inst_17121 = (state_17142[(2)]);
var inst_17122 = fluree.db.dbproto._first_flake.call(null,node);
var inst_17123 = fluree.db.dbproto._rhs.call(null,node);
var inst_17124 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_17142__$1 = (function (){var statearr_17172 = state_17142;
(statearr_17172[(11)] = inst_17122);

(statearr_17172[(12)] = inst_17123);

(statearr_17172[(13)] = inst_17121);

return statearr_17172;
})();
if(cljs.core.truth_(inst_17124)){
var statearr_17173_17199 = state_17142__$1;
(statearr_17173_17199[(1)] = (16));

} else {
var statearr_17174_17200 = state_17142__$1;
(statearr_17174_17200[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto____0 = (function (){
var statearr_17175 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17175[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto__);

(statearr_17175[(1)] = (1));

return statearr_17175;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto____1 = (function (state_17142){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17176){var ex__2471__auto__ = e17176;
var statearr_17177_17201 = state_17142;
(statearr_17177_17201[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17142[(4)]))){
var statearr_17178_17202 = state_17142;
(statearr_17178_17202[(1)] = cljs.core.first.call(null,(state_17142[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17203 = state_17142;
state_17142 = G__17203;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto__ = function(state_17142){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto____1.call(this,state_17142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17179 = f__2491__auto__.call(null);
(statearr_17179[(6)] = c__2490__auto__);

return statearr_17179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17224){
var state_val_17225 = (state_17224[(1)]);
if((state_val_17225 === (7))){
var state_17224__$1 = state_17224;
var statearr_17226_17246 = state_17224__$1;
(statearr_17226_17246[(2)] = null);

(statearr_17226_17246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17225 === (1))){
var state_17224__$1 = state_17224;
var statearr_17227_17247 = state_17224__$1;
(statearr_17227_17247[(2)] = null);

(statearr_17227_17247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17225 === (4))){
var inst_17204 = (state_17224[(2)]);
var state_17224__$1 = state_17224;
var statearr_17228_17248 = state_17224__$1;
(statearr_17228_17248[(2)] = inst_17204);

(statearr_17228_17248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17225 === (6))){
var inst_17210 = (state_17224[(7)]);
var inst_17212 = fluree.db.storage.core.serde.call(null,conn);
var state_17224__$1 = (function (){var statearr_17229 = state_17224;
(statearr_17229[(8)] = inst_17212);

return statearr_17229;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17224__$1,(9),inst_17210);
} else {
if((state_val_17225 === (3))){
var inst_17222 = (state_17224[(2)]);
var state_17224__$1 = state_17224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17224__$1,inst_17222);
} else {
if((state_val_17225 === (2))){
var inst_17210 = (state_17224[(7)]);
var _ = (function (){var statearr_17231 = state_17224;
(statearr_17231[(4)] = cljs.core.cons.call(null,(5),(state_17224[(4)])));

return statearr_17231;
})();
var inst_17210__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_17224__$1 = (function (){var statearr_17232 = state_17224;
(statearr_17232[(7)] = inst_17210__$1);

return statearr_17232;
})();
if(cljs.core.truth_(inst_17210__$1)){
var statearr_17233_17249 = state_17224__$1;
(statearr_17233_17249[(1)] = (6));

} else {
var statearr_17234_17250 = state_17224__$1;
(statearr_17234_17250[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17225 === (9))){
var inst_17212 = (state_17224[(8)]);
var inst_17214 = (state_17224[(2)]);
var inst_17215 = fluree.db.util.async.throw_err.call(null,inst_17214);
var inst_17216 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_17212,inst_17215);
var state_17224__$1 = state_17224;
var statearr_17235_17251 = state_17224__$1;
(statearr_17235_17251[(2)] = inst_17216);

(statearr_17235_17251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17225 === (5))){
var _ = (function (){var statearr_17236 = state_17224;
(statearr_17236[(4)] = cljs.core.rest.call(null,(state_17224[(4)])));

return statearr_17236;
})();
var state_17224__$1 = state_17224;
var ex17230 = (state_17224__$1[(2)]);
var statearr_17237_17252 = state_17224__$1;
(statearr_17237_17252[(5)] = ex17230);


if((ex17230 instanceof Error)){
var statearr_17238_17253 = state_17224__$1;
(statearr_17238_17253[(1)] = (4));

(statearr_17238_17253[(5)] = null);

} else {
throw ex17230;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17225 === (8))){
var inst_17219 = (state_17224[(2)]);
var _ = (function (){var statearr_17239 = state_17224;
(statearr_17239[(4)] = cljs.core.rest.call(null,(state_17224[(4)])));

return statearr_17239;
})();
var state_17224__$1 = state_17224;
var statearr_17240_17254 = state_17224__$1;
(statearr_17240_17254[(2)] = inst_17219);

(statearr_17240_17254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2468__auto____0 = (function (){
var statearr_17241 = [null,null,null,null,null,null,null,null,null];
(statearr_17241[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2468__auto__);

(statearr_17241[(1)] = (1));

return statearr_17241;
});
var fluree$db$storage$core$read_branch_$_state_machine__2468__auto____1 = (function (state_17224){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17242){var ex__2471__auto__ = e17242;
var statearr_17243_17255 = state_17224;
(statearr_17243_17255[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17224[(4)]))){
var statearr_17244_17256 = state_17224;
(statearr_17244_17256[(1)] = cljs.core.first.call(null,(state_17224[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17257 = state_17224;
state_17224 = G__17257;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2468__auto__ = function(state_17224){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2468__auto____1.call(this,state_17224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2468__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2468__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17245 = f__2491__auto__.call(null);
(statearr_17245[(6)] = c__2490__auto__);

return statearr_17245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2490__auto___17403 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17348){
var state_val_17349 = (state_17348[(1)]);
if((state_val_17349 === (7))){
var inst_17275 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_17276 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17277 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17278 = cljs.core.PersistentHashMap.fromArrays(inst_17276,inst_17277);
var inst_17279 = cljs.core.ex_info.call(null,inst_17275,inst_17278);
var inst_17280 = (function(){throw inst_17279})();
var state_17348__$1 = state_17348;
var statearr_17350_17404 = state_17348__$1;
(statearr_17350_17404[(2)] = inst_17280);

(statearr_17350_17404[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (20))){
var inst_17272 = (state_17348[(7)]);
var state_17348__$1 = state_17348;
var statearr_17351_17405 = state_17348__$1;
(statearr_17351_17405[(2)] = inst_17272);

(statearr_17351_17405[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (27))){
var inst_17326 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
var statearr_17352_17406 = state_17348__$1;
(statearr_17352_17406[(2)] = inst_17326);

(statearr_17352_17406[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (1))){
var state_17348__$1 = state_17348;
var statearr_17353_17407 = state_17348__$1;
(statearr_17353_17407[(2)] = null);

(statearr_17353_17407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (24))){
var inst_17329 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
if(cljs.core.truth_(inst_17329)){
var statearr_17354_17408 = state_17348__$1;
(statearr_17354_17408[(1)] = (28));

} else {
var statearr_17355_17409 = state_17348__$1;
(statearr_17355_17409[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (4))){
var inst_17258 = (state_17348[(2)]);
var inst_17259 = error_fn.call(null);
var inst_17260 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17258);
var inst_17261 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_17348__$1 = (function (){var statearr_17356 = state_17348;
(statearr_17356[(8)] = inst_17260);

(statearr_17356[(9)] = inst_17259);

return statearr_17356;
})();
var statearr_17357_17410 = state_17348__$1;
(statearr_17357_17410[(2)] = inst_17261);

(statearr_17357_17410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (15))){
var inst_17305 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
if(cljs.core.truth_(inst_17305)){
var statearr_17358_17411 = state_17348__$1;
(statearr_17358_17411[(1)] = (19));

} else {
var statearr_17359_17412 = state_17348__$1;
(statearr_17359_17412[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (21))){
var inst_17310 = (state_17348[(10)]);
var inst_17313 = (state_17348[(11)]);
var inst_17310__$1 = (state_17348[(2)]);
var inst_17311 = cljs.core.get.call(null,inst_17310__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_17312 = cljs.core.get.call(null,inst_17310__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_17313__$1 = config;
var inst_17315 = (inst_17313__$1 == null);
var inst_17316 = cljs.core.not.call(null,inst_17315);
var state_17348__$1 = (function (){var statearr_17360 = state_17348;
(statearr_17360[(12)] = inst_17312);

(statearr_17360[(13)] = inst_17311);

(statearr_17360[(10)] = inst_17310__$1);

(statearr_17360[(11)] = inst_17313__$1);

return statearr_17360;
})();
if(inst_17316){
var statearr_17361_17413 = state_17348__$1;
(statearr_17361_17413[(1)] = (22));

} else {
var statearr_17362_17414 = state_17348__$1;
(statearr_17362_17414[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (13))){
var inst_17272 = (state_17348[(7)]);
var inst_17294 = inst_17272.cljs$lang$protocol_mask$partition0$;
var inst_17295 = (inst_17294 & (64));
var inst_17296 = inst_17272.cljs$core$ISeq$;
var inst_17297 = (cljs.core.PROTOCOL_SENTINEL === inst_17296);
var inst_17298 = ((inst_17295) || (inst_17297));
var state_17348__$1 = state_17348;
if(cljs.core.truth_(inst_17298)){
var statearr_17363_17415 = state_17348__$1;
(statearr_17363_17415[(1)] = (16));

} else {
var statearr_17364_17416 = state_17348__$1;
(statearr_17364_17416[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (22))){
var inst_17313 = (state_17348[(11)]);
var inst_17318 = inst_17313.cljs$lang$protocol_mask$partition0$;
var inst_17319 = (inst_17318 & (64));
var inst_17320 = inst_17313.cljs$core$ISeq$;
var inst_17321 = (cljs.core.PROTOCOL_SENTINEL === inst_17320);
var inst_17322 = ((inst_17319) || (inst_17321));
var state_17348__$1 = state_17348;
if(cljs.core.truth_(inst_17322)){
var statearr_17365_17417 = state_17348__$1;
(statearr_17365_17417[(1)] = (25));

} else {
var statearr_17366_17418 = state_17348__$1;
(statearr_17366_17418[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (29))){
var inst_17313 = (state_17348[(11)]);
var state_17348__$1 = state_17348;
var statearr_17367_17419 = state_17348__$1;
(statearr_17367_17419[(2)] = inst_17313);

(statearr_17367_17419[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (6))){
var inst_17272 = (state_17348[(7)]);
var inst_17271 = (state_17348[(2)]);
var inst_17272__$1 = fluree.db.util.async.throw_err.call(null,inst_17271);
var inst_17273 = (inst_17272__$1 == null);
var state_17348__$1 = (function (){var statearr_17368 = state_17348;
(statearr_17368[(7)] = inst_17272__$1);

return statearr_17368;
})();
if(cljs.core.truth_(inst_17273)){
var statearr_17369_17420 = state_17348__$1;
(statearr_17369_17420[(1)] = (7));

} else {
var statearr_17370_17421 = state_17348__$1;
(statearr_17370_17421[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (28))){
var inst_17313 = (state_17348[(11)]);
var inst_17331 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17313);
var state_17348__$1 = state_17348;
var statearr_17371_17422 = state_17348__$1;
(statearr_17371_17422[(2)] = inst_17331);

(statearr_17371_17422[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (25))){
var state_17348__$1 = state_17348;
var statearr_17372_17423 = state_17348__$1;
(statearr_17372_17423[(2)] = true);

(statearr_17372_17423[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (17))){
var state_17348__$1 = state_17348;
var statearr_17373_17424 = state_17348__$1;
(statearr_17373_17424[(2)] = false);

(statearr_17373_17424[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (3))){
var inst_17346 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17348__$1,inst_17346);
} else {
if((state_val_17349 === (12))){
var inst_17272 = (state_17348[(7)]);
var inst_17289 = (state_17348[(2)]);
var inst_17291 = (inst_17272 == null);
var inst_17292 = cljs.core.not.call(null,inst_17291);
var state_17348__$1 = (function (){var statearr_17374 = state_17348;
(statearr_17374[(14)] = inst_17289);

return statearr_17374;
})();
if(inst_17292){
var statearr_17375_17425 = state_17348__$1;
(statearr_17375_17425[(1)] = (13));

} else {
var statearr_17376_17426 = state_17348__$1;
(statearr_17376_17426[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (2))){
var _ = (function (){var statearr_17377 = state_17348;
(statearr_17377[(4)] = cljs.core.cons.call(null,(5),(state_17348[(4)])));

return statearr_17377;
})();
var inst_17269 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_17348__$1 = state_17348;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17348__$1,(6),inst_17269);
} else {
if((state_val_17349 === (23))){
var state_17348__$1 = state_17348;
var statearr_17378_17427 = state_17348__$1;
(statearr_17378_17427[(2)] = false);

(statearr_17378_17427[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (19))){
var inst_17272 = (state_17348[(7)]);
var inst_17307 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17272);
var state_17348__$1 = state_17348;
var statearr_17379_17428 = state_17348__$1;
(statearr_17379_17428[(2)] = inst_17307);

(statearr_17379_17428[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (11))){
var state_17348__$1 = state_17348;
var statearr_17381_17429 = state_17348__$1;
(statearr_17381_17429[(2)] = null);

(statearr_17381_17429[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (9))){
var inst_17272 = (state_17348[(7)]);
var inst_17283 = (state_17348[(2)]);
var inst_17284 = fluree.db.util.core.exception_QMARK_.call(null,inst_17272);
var state_17348__$1 = (function (){var statearr_17382 = state_17348;
(statearr_17382[(15)] = inst_17283);

return statearr_17382;
})();
if(inst_17284){
var statearr_17383_17430 = state_17348__$1;
(statearr_17383_17430[(1)] = (10));

} else {
var statearr_17384_17431 = state_17348__$1;
(statearr_17384_17431[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (5))){
var _ = (function (){var statearr_17385 = state_17348;
(statearr_17385[(4)] = cljs.core.rest.call(null,(state_17348[(4)])));

return statearr_17385;
})();
var state_17348__$1 = state_17348;
var ex17380 = (state_17348__$1[(2)]);
var statearr_17386_17432 = state_17348__$1;
(statearr_17386_17432[(5)] = ex17380);


if((ex17380 instanceof java.lang.Exception)){
var statearr_17387_17433 = state_17348__$1;
(statearr_17387_17433[(1)] = (4));

(statearr_17387_17433[(5)] = null);

} else {
throw ex17380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (14))){
var state_17348__$1 = state_17348;
var statearr_17388_17434 = state_17348__$1;
(statearr_17388_17434[(2)] = false);

(statearr_17388_17434[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (26))){
var state_17348__$1 = state_17348;
var statearr_17389_17435 = state_17348__$1;
(statearr_17389_17435[(2)] = false);

(statearr_17389_17435[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (16))){
var state_17348__$1 = state_17348;
var statearr_17390_17436 = state_17348__$1;
(statearr_17390_17436[(2)] = true);

(statearr_17390_17436[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (30))){
var inst_17312 = (state_17348[(12)]);
var inst_17289 = (state_17348[(14)]);
var inst_17311 = (state_17348[(13)]);
var inst_17310 = (state_17348[(10)]);
var inst_17272 = (state_17348[(7)]);
var inst_17334 = (state_17348[(2)]);
var inst_17335 = cljs.core.get.call(null,inst_17334,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_17337 = (function (){var data = inst_17272;
var _ = inst_17289;
var map__17267 = inst_17310;
var children = inst_17311;
var rhs = inst_17312;
var map__17268 = inst_17334;
var comparator = inst_17335;
return (function (idx,p__17336){
var map__17391 = p__17336;
var map__17391__$1 = (((((!((map__17391 == null))))?(((((map__17391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17391):map__17391);
var child = map__17391__$1;
var id = cljs.core.get.call(null,map__17391__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__17391__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__17391__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__17391__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__17391__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_17338 = cljs.core.map_indexed.call(null,inst_17337,inst_17311);
var inst_17339 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_17338);
var inst_17340 = cljs.core.interleave.call(null,inst_17339,inst_17338);
var inst_17341 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_17335,inst_17340);
var inst_17342 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_17312,inst_17341,config,leftmost_QMARK_);
var inst_17343 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17342);
var _ = (function (){var statearr_17393 = state_17348;
(statearr_17393[(4)] = cljs.core.rest.call(null,(state_17348[(4)])));

return statearr_17393;
})();
var state_17348__$1 = state_17348;
var statearr_17394_17437 = state_17348__$1;
(statearr_17394_17437[(2)] = inst_17343);

(statearr_17394_17437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (10))){
var inst_17272 = (state_17348[(7)]);
var inst_17286 = (function(){throw inst_17272})();
var state_17348__$1 = state_17348;
var statearr_17395_17438 = state_17348__$1;
(statearr_17395_17438[(2)] = inst_17286);

(statearr_17395_17438[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (18))){
var inst_17302 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
var statearr_17396_17439 = state_17348__$1;
(statearr_17396_17439[(2)] = inst_17302);

(statearr_17396_17439[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17349 === (8))){
var state_17348__$1 = state_17348;
var statearr_17397_17440 = state_17348__$1;
(statearr_17397_17440[(2)] = null);

(statearr_17397_17440[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2468__auto____0 = (function (){
var statearr_17398 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17398[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2468__auto__);

(statearr_17398[(1)] = (1));

return statearr_17398;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2468__auto____1 = (function (state_17348){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17399){var ex__2471__auto__ = e17399;
var statearr_17400_17441 = state_17348;
(statearr_17400_17441[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17348[(4)]))){
var statearr_17401_17442 = state_17348;
(statearr_17401_17442[(1)] = cljs.core.first.call(null,(state_17348[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17443 = state_17348;
state_17348 = G__17443;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2468__auto__ = function(state_17348){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2468__auto____1.call(this,state_17348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2468__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2468__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17402 = f__2491__auto__.call(null);
(statearr_17402[(6)] = c__2490__auto___17403);

return statearr_17402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17464){
var state_val_17465 = (state_17464[(1)]);
if((state_val_17465 === (7))){
var state_17464__$1 = state_17464;
var statearr_17466_17486 = state_17464__$1;
(statearr_17466_17486[(2)] = null);

(statearr_17466_17486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (1))){
var state_17464__$1 = state_17464;
var statearr_17467_17487 = state_17464__$1;
(statearr_17467_17487[(2)] = null);

(statearr_17467_17487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (4))){
var inst_17444 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
var statearr_17468_17488 = state_17464__$1;
(statearr_17468_17488[(2)] = inst_17444);

(statearr_17468_17488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (6))){
var inst_17450 = (state_17464[(7)]);
var inst_17452 = fluree.db.storage.core.serde.call(null,conn);
var state_17464__$1 = (function (){var statearr_17469 = state_17464;
(statearr_17469[(8)] = inst_17452);

return statearr_17469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17464__$1,(9),inst_17450);
} else {
if((state_val_17465 === (3))){
var inst_17462 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17464__$1,inst_17462);
} else {
if((state_val_17465 === (2))){
var inst_17450 = (state_17464[(7)]);
var _ = (function (){var statearr_17471 = state_17464;
(statearr_17471[(4)] = cljs.core.cons.call(null,(5),(state_17464[(4)])));

return statearr_17471;
})();
var inst_17450__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_17464__$1 = (function (){var statearr_17472 = state_17464;
(statearr_17472[(7)] = inst_17450__$1);

return statearr_17472;
})();
if(cljs.core.truth_(inst_17450__$1)){
var statearr_17473_17489 = state_17464__$1;
(statearr_17473_17489[(1)] = (6));

} else {
var statearr_17474_17490 = state_17464__$1;
(statearr_17474_17490[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (9))){
var inst_17452 = (state_17464[(8)]);
var inst_17454 = (state_17464[(2)]);
var inst_17455 = fluree.db.util.async.throw_err.call(null,inst_17454);
var inst_17456 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_17452,inst_17455);
var state_17464__$1 = state_17464;
var statearr_17475_17491 = state_17464__$1;
(statearr_17475_17491[(2)] = inst_17456);

(statearr_17475_17491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (5))){
var _ = (function (){var statearr_17476 = state_17464;
(statearr_17476[(4)] = cljs.core.rest.call(null,(state_17464[(4)])));

return statearr_17476;
})();
var state_17464__$1 = state_17464;
var ex17470 = (state_17464__$1[(2)]);
var statearr_17477_17492 = state_17464__$1;
(statearr_17477_17492[(5)] = ex17470);


if((ex17470 instanceof Error)){
var statearr_17478_17493 = state_17464__$1;
(statearr_17478_17493[(1)] = (4));

(statearr_17478_17493[(5)] = null);

} else {
throw ex17470;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17465 === (8))){
var inst_17459 = (state_17464[(2)]);
var _ = (function (){var statearr_17479 = state_17464;
(statearr_17479[(4)] = cljs.core.rest.call(null,(state_17464[(4)])));

return statearr_17479;
})();
var state_17464__$1 = state_17464;
var statearr_17480_17494 = state_17464__$1;
(statearr_17480_17494[(2)] = inst_17459);

(statearr_17480_17494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2468__auto____0 = (function (){
var statearr_17481 = [null,null,null,null,null,null,null,null,null];
(statearr_17481[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2468__auto__);

(statearr_17481[(1)] = (1));

return statearr_17481;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2468__auto____1 = (function (state_17464){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17482){var ex__2471__auto__ = e17482;
var statearr_17483_17495 = state_17464;
(statearr_17483_17495[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17464[(4)]))){
var statearr_17484_17496 = state_17464;
(statearr_17484_17496[(1)] = cljs.core.first.call(null,(state_17464[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17497 = state_17464;
state_17464 = G__17497;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2468__auto__ = function(state_17464){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2468__auto____1.call(this,state_17464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2468__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2468__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17485 = f__2491__auto__.call(null);
(statearr_17485[(6)] = c__2490__auto__);

return statearr_17485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2490__auto___17635 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17582){
var state_val_17583 = (state_17582[(1)]);
if((state_val_17583 === (7))){
var inst_17514 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_17515 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17516 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_17517 = cljs.core.PersistentHashMap.fromArrays(inst_17515,inst_17516);
var inst_17518 = cljs.core.ex_info.call(null,inst_17514,inst_17517);
var inst_17519 = (function(){throw inst_17518})();
var state_17582__$1 = state_17582;
var statearr_17584_17636 = state_17582__$1;
(statearr_17584_17636[(2)] = inst_17519);

(statearr_17584_17636[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (20))){
var inst_17511 = (state_17582[(7)]);
var state_17582__$1 = state_17582;
var statearr_17585_17637 = state_17582__$1;
(statearr_17585_17637[(2)] = inst_17511);

(statearr_17585_17637[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (27))){
var inst_17565 = (state_17582[(2)]);
var state_17582__$1 = state_17582;
var statearr_17586_17638 = state_17582__$1;
(statearr_17586_17638[(2)] = inst_17565);

(statearr_17586_17638[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (1))){
var state_17582__$1 = state_17582;
var statearr_17587_17639 = state_17582__$1;
(statearr_17587_17639[(2)] = null);

(statearr_17587_17639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (24))){
var inst_17568 = (state_17582[(2)]);
var state_17582__$1 = state_17582;
if(cljs.core.truth_(inst_17568)){
var statearr_17588_17640 = state_17582__$1;
(statearr_17588_17640[(1)] = (28));

} else {
var statearr_17589_17641 = state_17582__$1;
(statearr_17589_17641[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (4))){
var inst_17498 = (state_17582[(2)]);
var inst_17499 = error_fn.call(null);
var inst_17500 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17498);
var inst_17501 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_17582__$1 = (function (){var statearr_17590 = state_17582;
(statearr_17590[(8)] = inst_17499);

(statearr_17590[(9)] = inst_17500);

return statearr_17590;
})();
var statearr_17591_17642 = state_17582__$1;
(statearr_17591_17642[(2)] = inst_17501);

(statearr_17591_17642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (15))){
var inst_17544 = (state_17582[(2)]);
var state_17582__$1 = state_17582;
if(cljs.core.truth_(inst_17544)){
var statearr_17592_17643 = state_17582__$1;
(statearr_17592_17643[(1)] = (19));

} else {
var statearr_17593_17644 = state_17582__$1;
(statearr_17593_17644[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (21))){
var inst_17552 = (state_17582[(10)]);
var inst_17549 = (state_17582[(2)]);
var inst_17550 = cljs.core.get.call(null,inst_17549,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_17551 = cljs.core.get.call(null,inst_17549,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_17552__$1 = config;
var inst_17554 = (inst_17552__$1 == null);
var inst_17555 = cljs.core.not.call(null,inst_17554);
var state_17582__$1 = (function (){var statearr_17594 = state_17582;
(statearr_17594[(11)] = inst_17550);

(statearr_17594[(10)] = inst_17552__$1);

(statearr_17594[(12)] = inst_17551);

return statearr_17594;
})();
if(inst_17555){
var statearr_17595_17645 = state_17582__$1;
(statearr_17595_17645[(1)] = (22));

} else {
var statearr_17596_17646 = state_17582__$1;
(statearr_17596_17646[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (13))){
var inst_17511 = (state_17582[(7)]);
var inst_17533 = inst_17511.cljs$lang$protocol_mask$partition0$;
var inst_17534 = (inst_17533 & (64));
var inst_17535 = inst_17511.cljs$core$ISeq$;
var inst_17536 = (cljs.core.PROTOCOL_SENTINEL === inst_17535);
var inst_17537 = ((inst_17534) || (inst_17536));
var state_17582__$1 = state_17582;
if(cljs.core.truth_(inst_17537)){
var statearr_17597_17647 = state_17582__$1;
(statearr_17597_17647[(1)] = (16));

} else {
var statearr_17598_17648 = state_17582__$1;
(statearr_17598_17648[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (22))){
var inst_17552 = (state_17582[(10)]);
var inst_17557 = inst_17552.cljs$lang$protocol_mask$partition0$;
var inst_17558 = (inst_17557 & (64));
var inst_17559 = inst_17552.cljs$core$ISeq$;
var inst_17560 = (cljs.core.PROTOCOL_SENTINEL === inst_17559);
var inst_17561 = ((inst_17558) || (inst_17560));
var state_17582__$1 = state_17582;
if(cljs.core.truth_(inst_17561)){
var statearr_17599_17649 = state_17582__$1;
(statearr_17599_17649[(1)] = (25));

} else {
var statearr_17600_17650 = state_17582__$1;
(statearr_17600_17650[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (29))){
var inst_17552 = (state_17582[(10)]);
var state_17582__$1 = state_17582;
var statearr_17601_17651 = state_17582__$1;
(statearr_17601_17651[(2)] = inst_17552);

(statearr_17601_17651[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (6))){
var inst_17511 = (state_17582[(7)]);
var inst_17511__$1 = (state_17582[(2)]);
var inst_17512 = (inst_17511__$1 == null);
var state_17582__$1 = (function (){var statearr_17602 = state_17582;
(statearr_17602[(7)] = inst_17511__$1);

return statearr_17602;
})();
if(cljs.core.truth_(inst_17512)){
var statearr_17603_17652 = state_17582__$1;
(statearr_17603_17652[(1)] = (7));

} else {
var statearr_17604_17653 = state_17582__$1;
(statearr_17604_17653[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (28))){
var inst_17552 = (state_17582[(10)]);
var inst_17570 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17552);
var state_17582__$1 = state_17582;
var statearr_17605_17654 = state_17582__$1;
(statearr_17605_17654[(2)] = inst_17570);

(statearr_17605_17654[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (25))){
var state_17582__$1 = state_17582;
var statearr_17606_17655 = state_17582__$1;
(statearr_17606_17655[(2)] = true);

(statearr_17606_17655[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (17))){
var state_17582__$1 = state_17582;
var statearr_17607_17656 = state_17582__$1;
(statearr_17607_17656[(2)] = false);

(statearr_17607_17656[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (3))){
var inst_17580 = (state_17582[(2)]);
var state_17582__$1 = state_17582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17582__$1,inst_17580);
} else {
if((state_val_17583 === (12))){
var inst_17511 = (state_17582[(7)]);
var inst_17528 = (state_17582[(2)]);
var inst_17530 = (inst_17511 == null);
var inst_17531 = cljs.core.not.call(null,inst_17530);
var state_17582__$1 = (function (){var statearr_17608 = state_17582;
(statearr_17608[(13)] = inst_17528);

return statearr_17608;
})();
if(inst_17531){
var statearr_17609_17657 = state_17582__$1;
(statearr_17609_17657[(1)] = (13));

} else {
var statearr_17610_17658 = state_17582__$1;
(statearr_17610_17658[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (2))){
var _ = (function (){var statearr_17611 = state_17582;
(statearr_17611[(4)] = cljs.core.cons.call(null,(5),(state_17582[(4)])));

return statearr_17611;
})();
var inst_17509 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_17582__$1 = state_17582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17582__$1,(6),inst_17509);
} else {
if((state_val_17583 === (23))){
var state_17582__$1 = state_17582;
var statearr_17612_17659 = state_17582__$1;
(statearr_17612_17659[(2)] = false);

(statearr_17612_17659[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (19))){
var inst_17511 = (state_17582[(7)]);
var inst_17546 = cljs.core.apply.call(null,cljs.core.hash_map,inst_17511);
var state_17582__$1 = state_17582;
var statearr_17613_17660 = state_17582__$1;
(statearr_17613_17660[(2)] = inst_17546);

(statearr_17613_17660[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (11))){
var state_17582__$1 = state_17582;
var statearr_17615_17661 = state_17582__$1;
(statearr_17615_17661[(2)] = null);

(statearr_17615_17661[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (9))){
var inst_17511 = (state_17582[(7)]);
var inst_17522 = (state_17582[(2)]);
var inst_17523 = fluree.db.util.core.exception_QMARK_.call(null,inst_17511);
var state_17582__$1 = (function (){var statearr_17616 = state_17582;
(statearr_17616[(14)] = inst_17522);

return statearr_17616;
})();
if(inst_17523){
var statearr_17617_17662 = state_17582__$1;
(statearr_17617_17662[(1)] = (10));

} else {
var statearr_17618_17663 = state_17582__$1;
(statearr_17618_17663[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (5))){
var _ = (function (){var statearr_17619 = state_17582;
(statearr_17619[(4)] = cljs.core.rest.call(null,(state_17582[(4)])));

return statearr_17619;
})();
var state_17582__$1 = state_17582;
var ex17614 = (state_17582__$1[(2)]);
var statearr_17620_17664 = state_17582__$1;
(statearr_17620_17664[(5)] = ex17614);


if((ex17614 instanceof java.lang.Exception)){
var statearr_17621_17665 = state_17582__$1;
(statearr_17621_17665[(1)] = (4));

(statearr_17621_17665[(5)] = null);

} else {
throw ex17614;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (14))){
var state_17582__$1 = state_17582;
var statearr_17622_17666 = state_17582__$1;
(statearr_17622_17666[(2)] = false);

(statearr_17622_17666[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (26))){
var state_17582__$1 = state_17582;
var statearr_17623_17667 = state_17582__$1;
(statearr_17623_17667[(2)] = false);

(statearr_17623_17667[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (16))){
var state_17582__$1 = state_17582;
var statearr_17624_17668 = state_17582__$1;
(statearr_17624_17668[(2)] = true);

(statearr_17624_17668[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (30))){
var inst_17550 = (state_17582[(11)]);
var inst_17573 = (state_17582[(2)]);
var inst_17574 = cljs.core.get.call(null,inst_17573,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_17575 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_17574,inst_17550);
var inst_17576 = fluree.db.index.data_node.call(null,block,t,inst_17575,rhs,config);
var inst_17577 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17576);
var _ = (function (){var statearr_17625 = state_17582;
(statearr_17625[(4)] = cljs.core.rest.call(null,(state_17582[(4)])));

return statearr_17625;
})();
var state_17582__$1 = state_17582;
var statearr_17626_17669 = state_17582__$1;
(statearr_17626_17669[(2)] = inst_17577);

(statearr_17626_17669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (10))){
var inst_17511 = (state_17582[(7)]);
var inst_17525 = (function(){throw inst_17511})();
var state_17582__$1 = state_17582;
var statearr_17627_17670 = state_17582__$1;
(statearr_17627_17670[(2)] = inst_17525);

(statearr_17627_17670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (18))){
var inst_17541 = (state_17582[(2)]);
var state_17582__$1 = state_17582;
var statearr_17628_17671 = state_17582__$1;
(statearr_17628_17671[(2)] = inst_17541);

(statearr_17628_17671[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17583 === (8))){
var state_17582__$1 = state_17582;
var statearr_17629_17672 = state_17582__$1;
(statearr_17629_17672[(2)] = null);

(statearr_17629_17672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto____0 = (function (){
var statearr_17630 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17630[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto__);

(statearr_17630[(1)] = (1));

return statearr_17630;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto____1 = (function (state_17582){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17631){var ex__2471__auto__ = e17631;
var statearr_17632_17673 = state_17582;
(statearr_17632_17673[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17582[(4)]))){
var statearr_17633_17674 = state_17582;
(statearr_17633_17674[(1)] = cljs.core.first.call(null,(state_17582[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17675 = state_17582;
state_17582 = G__17675;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto__ = function(state_17582){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto____1.call(this,state_17582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17634 = f__2491__auto__.call(null);
(statearr_17634[(6)] = c__2490__auto___17635);

return statearr_17634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k17677,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__17681 = k17677;
var G__17681__$1 = (((G__17681 instanceof cljs.core.Keyword))?G__17681.fqn:null);
switch (G__17681__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k17677,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__17682){
var vec__17683 = p__17682;
var k__4403__auto__ = cljs.core.nth.call(null,vec__17683,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__17683,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__17676){
var self__ = this;
var G__17676__$1 = this;
return (new cljs.core.RecordIter((0),G__17676__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this17678,other17679){
var self__ = this;
var this17678__$1 = this;
return (((!((other17679 == null)))) && ((this17678__$1.constructor === other17679.constructor)) && (cljs.core._EQ_.call(null,this17678__$1.conn,other17679.conn)) && (cljs.core._EQ_.call(null,this17678__$1.config,other17679.config)) && (cljs.core._EQ_.call(null,this17678__$1.network,other17679.network)) && (cljs.core._EQ_.call(null,this17678__$1.dbid,other17679.dbid)) && (cljs.core._EQ_.call(null,this17678__$1.id,other17679.id)) && (cljs.core._EQ_.call(null,this17678__$1.leaf,other17679.leaf)) && (cljs.core._EQ_.call(null,this17678__$1.first,other17679.first)) && (cljs.core._EQ_.call(null,this17678__$1.rhs,other17679.rhs)) && (cljs.core._EQ_.call(null,this17678__$1.size,other17679.size)) && (cljs.core._EQ_.call(null,this17678__$1.block,other17679.block)) && (cljs.core._EQ_.call(null,this17678__$1.t,other17679.t)) && (cljs.core._EQ_.call(null,this17678__$1.tt_id,other17679.tt_id)) && (cljs.core._EQ_.call(null,this17678__$1.leftmost_QMARK_,other17679.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this17678__$1.tempid,other17679.tempid)) && (cljs.core._EQ_.call(null,this17678__$1.__extmap,other17679.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__17676){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__17686 = cljs.core.keyword_identical_QMARK_;
var expr__17687 = k__4388__auto__;
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(G__17676,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__17676,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__17676,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__17676,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__17676,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__17676,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__17676,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__17676,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__17676,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__17676,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__17676,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__17676,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__17676,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__17686.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__17687))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__17676,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__17676),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__17676){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__17676,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__17680){
var extmap__4419__auto__ = (function (){var G__17689 = cljs.core.dissoc.call(null,G__17680,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__17680)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__17689);
} else {
return G__17689;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__17680),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__17680),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17691 = blank_db;
var map__17691__$1 = (((((!((map__17691 == null))))?(((((map__17691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17691):map__17691);
var network = cljs.core.get.call(null,map__17691__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__17691__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__17691__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__17692 = root_data;
var map__17692__$1 = (((((!((map__17692 == null))))?(((((map__17692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17692.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17692):map__17692);
var block = cljs.core.get.call(null,map__17692__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17692__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__17692__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__17692__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17716){
var state_val_17717 = (state_17716[(1)]);
if((state_val_17717 === (7))){
var state_17716__$1 = state_17716;
var statearr_17718_17738 = state_17716__$1;
(statearr_17718_17738[(2)] = null);

(statearr_17718_17738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (1))){
var state_17716__$1 = state_17716;
var statearr_17719_17739 = state_17716__$1;
(statearr_17719_17739[(2)] = null);

(statearr_17719_17739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (4))){
var inst_17695 = (state_17716[(2)]);
var state_17716__$1 = state_17716;
var statearr_17720_17740 = state_17716__$1;
(statearr_17720_17740[(2)] = inst_17695);

(statearr_17720_17740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (6))){
var inst_17702 = (state_17716[(7)]);
var inst_17704 = fluree.db.storage.core.serde.call(null,conn);
var state_17716__$1 = (function (){var statearr_17721 = state_17716;
(statearr_17721[(8)] = inst_17704);

return statearr_17721;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17716__$1,(9),inst_17702);
} else {
if((state_val_17717 === (3))){
var inst_17714 = (state_17716[(2)]);
var state_17716__$1 = state_17716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17716__$1,inst_17714);
} else {
if((state_val_17717 === (2))){
var inst_17702 = (state_17716[(7)]);
var _ = (function (){var statearr_17723 = state_17716;
(statearr_17723[(4)] = cljs.core.cons.call(null,(5),(state_17716[(4)])));

return statearr_17723;
})();
var inst_17701 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_17702__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_17701);
var state_17716__$1 = (function (){var statearr_17724 = state_17716;
(statearr_17724[(7)] = inst_17702__$1);

return statearr_17724;
})();
if(cljs.core.truth_(inst_17702__$1)){
var statearr_17725_17741 = state_17716__$1;
(statearr_17725_17741[(1)] = (6));

} else {
var statearr_17726_17742 = state_17716__$1;
(statearr_17726_17742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (9))){
var inst_17704 = (state_17716[(8)]);
var inst_17706 = (state_17716[(2)]);
var inst_17707 = fluree.db.util.async.throw_err.call(null,inst_17706);
var inst_17708 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_17704,inst_17707);
var state_17716__$1 = state_17716;
var statearr_17727_17743 = state_17716__$1;
(statearr_17727_17743[(2)] = inst_17708);

(statearr_17727_17743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (5))){
var _ = (function (){var statearr_17728 = state_17716;
(statearr_17728[(4)] = cljs.core.rest.call(null,(state_17716[(4)])));

return statearr_17728;
})();
var state_17716__$1 = state_17716;
var ex17722 = (state_17716__$1[(2)]);
var statearr_17729_17744 = state_17716__$1;
(statearr_17729_17744[(5)] = ex17722);


if((ex17722 instanceof Error)){
var statearr_17730_17745 = state_17716__$1;
(statearr_17730_17745[(1)] = (4));

(statearr_17730_17745[(5)] = null);

} else {
throw ex17722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (8))){
var inst_17711 = (state_17716[(2)]);
var _ = (function (){var statearr_17731 = state_17716;
(statearr_17731[(4)] = cljs.core.rest.call(null,(state_17716[(4)])));

return statearr_17731;
})();
var state_17716__$1 = state_17716;
var statearr_17732_17746 = state_17716__$1;
(statearr_17732_17746[(2)] = inst_17711);

(statearr_17732_17746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2468__auto____0 = (function (){
var statearr_17733 = [null,null,null,null,null,null,null,null,null];
(statearr_17733[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2468__auto__);

(statearr_17733[(1)] = (1));

return statearr_17733;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2468__auto____1 = (function (state_17716){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17734){var ex__2471__auto__ = e17734;
var statearr_17735_17747 = state_17716;
(statearr_17735_17747[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17716[(4)]))){
var statearr_17736_17748 = state_17716;
(statearr_17736_17748[(1)] = cljs.core.first.call(null,(state_17716[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17749 = state_17716;
state_17716 = G__17749;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2468__auto__ = function(state_17716){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2468__auto____1.call(this,state_17716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2468__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2468__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17737 = f__2491__auto__.call(null);
(statearr_17737[(6)] = c__2490__auto__);

return statearr_17737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17771){
var state_val_17772 = (state_17771[(1)]);
if((state_val_17772 === (7))){
var state_17771__$1 = state_17771;
var statearr_17773_17793 = state_17771__$1;
(statearr_17773_17793[(2)] = null);

(statearr_17773_17793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17772 === (1))){
var state_17771__$1 = state_17771;
var statearr_17774_17794 = state_17771__$1;
(statearr_17774_17794[(2)] = null);

(statearr_17774_17794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17772 === (4))){
var inst_17750 = (state_17771[(2)]);
var state_17771__$1 = state_17771;
var statearr_17775_17795 = state_17771__$1;
(statearr_17775_17795[(2)] = inst_17750);

(statearr_17775_17795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17772 === (6))){
var inst_17757 = (state_17771[(7)]);
var inst_17759 = fluree.db.storage.core.serde.call(null,conn);
var state_17771__$1 = (function (){var statearr_17776 = state_17771;
(statearr_17776[(8)] = inst_17759);

return statearr_17776;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17771__$1,(9),inst_17757);
} else {
if((state_val_17772 === (3))){
var inst_17769 = (state_17771[(2)]);
var state_17771__$1 = state_17771;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17771__$1,inst_17769);
} else {
if((state_val_17772 === (2))){
var inst_17757 = (state_17771[(7)]);
var _ = (function (){var statearr_17778 = state_17771;
(statearr_17778[(4)] = cljs.core.cons.call(null,(5),(state_17771[(4)])));

return statearr_17778;
})();
var inst_17756 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_17757__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_17756);
var state_17771__$1 = (function (){var statearr_17779 = state_17771;
(statearr_17779[(7)] = inst_17757__$1);

return statearr_17779;
})();
if(cljs.core.truth_(inst_17757__$1)){
var statearr_17780_17796 = state_17771__$1;
(statearr_17780_17796[(1)] = (6));

} else {
var statearr_17781_17797 = state_17771__$1;
(statearr_17781_17797[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17772 === (9))){
var inst_17759 = (state_17771[(8)]);
var inst_17761 = (state_17771[(2)]);
var inst_17762 = fluree.db.util.async.throw_err.call(null,inst_17761);
var inst_17763 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_17759,inst_17762);
var state_17771__$1 = state_17771;
var statearr_17782_17798 = state_17771__$1;
(statearr_17782_17798[(2)] = inst_17763);

(statearr_17782_17798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17772 === (5))){
var _ = (function (){var statearr_17783 = state_17771;
(statearr_17783[(4)] = cljs.core.rest.call(null,(state_17771[(4)])));

return statearr_17783;
})();
var state_17771__$1 = state_17771;
var ex17777 = (state_17771__$1[(2)]);
var statearr_17784_17799 = state_17771__$1;
(statearr_17784_17799[(5)] = ex17777);


if((ex17777 instanceof Error)){
var statearr_17785_17800 = state_17771__$1;
(statearr_17785_17800[(1)] = (4));

(statearr_17785_17800[(5)] = null);

} else {
throw ex17777;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17772 === (8))){
var inst_17766 = (state_17771[(2)]);
var _ = (function (){var statearr_17786 = state_17771;
(statearr_17786[(4)] = cljs.core.rest.call(null,(state_17771[(4)])));

return statearr_17786;
})();
var state_17771__$1 = state_17771;
var statearr_17787_17801 = state_17771__$1;
(statearr_17787_17801[(2)] = inst_17766);

(statearr_17787_17801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2468__auto____0 = (function (){
var statearr_17788 = [null,null,null,null,null,null,null,null,null];
(statearr_17788[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2468__auto__);

(statearr_17788[(1)] = (1));

return statearr_17788;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2468__auto____1 = (function (state_17771){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17771);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17789){var ex__2471__auto__ = e17789;
var statearr_17790_17802 = state_17771;
(statearr_17790_17802[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17771[(4)]))){
var statearr_17791_17803 = state_17771;
(statearr_17791_17803[(1)] = cljs.core.first.call(null,(state_17771[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17804 = state_17771;
state_17771 = G__17804;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2468__auto__ = function(state_17771){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2468__auto____1.call(this,state_17771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2468__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2468__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17792 = f__2491__auto__.call(null);
(statearr_17792[(6)] = c__2490__auto__);

return statearr_17792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17840){
var state_val_17841 = (state_17840[(1)]);
if((state_val_17841 === (7))){
var inst_17814 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17815 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17816 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17817 = cljs.core.PersistentHashMap.fromArrays(inst_17815,inst_17816);
var inst_17818 = cljs.core.ex_info.call(null,inst_17814,inst_17817);
var inst_17819 = (function(){throw inst_17818})();
var state_17840__$1 = state_17840;
var statearr_17842_17864 = state_17840__$1;
(statearr_17842_17864[(2)] = inst_17819);

(statearr_17842_17864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (1))){
var state_17840__$1 = state_17840;
var statearr_17843_17865 = state_17840__$1;
(statearr_17843_17865[(2)] = null);

(statearr_17843_17865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (4))){
var inst_17805 = (state_17840[(2)]);
var state_17840__$1 = state_17840;
var statearr_17844_17866 = state_17840__$1;
(statearr_17844_17866[(2)] = inst_17805);

(statearr_17844_17866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (6))){
var state_17840__$1 = state_17840;
var statearr_17845_17867 = state_17840__$1;
(statearr_17845_17867[(2)] = null);

(statearr_17845_17867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (3))){
var inst_17838 = (state_17840[(2)]);
var state_17840__$1 = state_17840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17840__$1,inst_17838);
} else {
if((state_val_17841 === (2))){
var inst_17811 = (state_17840[(7)]);
var _ = (function (){var statearr_17846 = state_17840;
(statearr_17846[(4)] = cljs.core.cons.call(null,(5),(state_17840[(4)])));

return statearr_17846;
})();
var inst_17811__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_17840__$1 = (function (){var statearr_17847 = state_17840;
(statearr_17847[(7)] = inst_17811__$1);

return statearr_17847;
})();
if(cljs.core.truth_(inst_17811__$1)){
var statearr_17848_17868 = state_17840__$1;
(statearr_17848_17868[(1)] = (6));

} else {
var statearr_17849_17869 = state_17840__$1;
(statearr_17849_17869[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (11))){
var inst_17830 = (state_17840[(8)]);
var inst_17833 = (state_17840[(2)]);
var inst_17834 = fluree.db.util.async.throw_err.call(null,inst_17833);
var inst_17835 = cljs.core.assoc.call(null,inst_17830,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17834);
var _ = (function (){var statearr_17851 = state_17840;
(statearr_17851[(4)] = cljs.core.rest.call(null,(state_17840[(4)])));

return statearr_17851;
})();
var state_17840__$1 = state_17840;
var statearr_17852_17870 = state_17840__$1;
(statearr_17852_17870[(2)] = inst_17835);

(statearr_17852_17870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (9))){
var inst_17825 = (state_17840[(9)]);
var inst_17823 = (state_17840[(2)]);
var inst_17824 = fluree.db.util.async.throw_err.call(null,inst_17823);
var inst_17825__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_17824);
var inst_17826 = fluree.db.query.schema.schema_map.call(null,inst_17825__$1);
var state_17840__$1 = (function (){var statearr_17853 = state_17840;
(statearr_17853[(9)] = inst_17825__$1);

return statearr_17853;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17840__$1,(10),inst_17826);
} else {
if((state_val_17841 === (5))){
var _ = (function (){var statearr_17854 = state_17840;
(statearr_17854[(4)] = cljs.core.rest.call(null,(state_17840[(4)])));

return statearr_17854;
})();
var state_17840__$1 = state_17840;
var ex17850 = (state_17840__$1[(2)]);
var statearr_17855_17871 = state_17840__$1;
(statearr_17855_17871[(5)] = ex17850);


if((ex17850 instanceof Error)){
var statearr_17856_17872 = state_17840__$1;
(statearr_17856_17872[(1)] = (4));

(statearr_17856_17872[(5)] = null);

} else {
throw ex17850;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17841 === (10))){
var inst_17825 = (state_17840[(9)]);
var inst_17830 = (state_17840[(8)]);
var inst_17828 = (state_17840[(2)]);
var inst_17829 = fluree.db.util.async.throw_err.call(null,inst_17828);
var inst_17830__$1 = cljs.core.assoc.call(null,inst_17825,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17829);
var inst_17831 = fluree.db.query.schema.setting_map.call(null,inst_17830__$1);
var state_17840__$1 = (function (){var statearr_17857 = state_17840;
(statearr_17857[(8)] = inst_17830__$1);

return statearr_17857;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17840__$1,(11),inst_17831);
} else {
if((state_val_17841 === (8))){
var inst_17811 = (state_17840[(7)]);
var inst_17821 = (state_17840[(2)]);
var state_17840__$1 = (function (){var statearr_17858 = state_17840;
(statearr_17858[(10)] = inst_17821);

return statearr_17858;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17840__$1,(9),inst_17811);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2468__auto____0 = (function (){
var statearr_17859 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17859[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2468__auto__);

(statearr_17859[(1)] = (1));

return statearr_17859;
});
var fluree$db$storage$core$reify_db_$_state_machine__2468__auto____1 = (function (state_17840){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17860){var ex__2471__auto__ = e17860;
var statearr_17861_17873 = state_17840;
(statearr_17861_17873[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17840[(4)]))){
var statearr_17862_17874 = state_17840;
(statearr_17862_17874[(1)] = cljs.core.first.call(null,(state_17840[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17875 = state_17840;
state_17840 = G__17875;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2468__auto__ = function(state_17840){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2468__auto____1.call(this,state_17840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2468__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2468__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17863 = f__2491__auto__.call(null);
(statearr_17863[(6)] = c__2490__auto__);

return statearr_17863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__17877 = arguments.length;
switch (G__17877) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_17927){
var state_val_17928 = (state_17927[(1)]);
if((state_val_17928 === (7))){
var inst_17887 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_17888 = (new Error(inst_17887));
var inst_17889 = (function(){throw inst_17888})();
var state_17927__$1 = state_17927;
var statearr_17929_17965 = state_17927__$1;
(statearr_17929_17965[(2)] = inst_17889);

(statearr_17929_17965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (20))){
var inst_17916 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
var statearr_17930_17966 = state_17927__$1;
(statearr_17930_17966[(2)] = inst_17916);

(statearr_17930_17966[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (1))){
var state_17927__$1 = state_17927;
var statearr_17931_17967 = state_17927__$1;
(statearr_17931_17967[(2)] = null);

(statearr_17931_17967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (4))){
var inst_17878 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
var statearr_17932_17968 = state_17927__$1;
(statearr_17932_17968[(2)] = inst_17878);

(statearr_17932_17968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (15))){
var inst_17900 = (state_17927[(7)]);
var inst_17896 = (state_17927[(8)]);
var inst_17908 = cljs.core.conj.call(null,inst_17896,inst_17900);
var state_17927__$1 = state_17927;
var statearr_17933_17969 = state_17927__$1;
(statearr_17933_17969[(2)] = inst_17908);

(statearr_17933_17969[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (13))){
var inst_17895 = (state_17927[(9)]);
var inst_17906 = cljs.core._EQ_.call(null,inst_17895,end);
var state_17927__$1 = state_17927;
if(inst_17906){
var statearr_17934_17970 = state_17927__$1;
(statearr_17934_17970[(1)] = (15));

} else {
var statearr_17935_17971 = state_17927__$1;
(statearr_17935_17971[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (6))){
var state_17927__$1 = state_17927;
var statearr_17936_17972 = state_17927__$1;
(statearr_17936_17972[(2)] = null);

(statearr_17936_17972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (17))){
var inst_17918 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
var statearr_17937_17973 = state_17927__$1;
(statearr_17937_17973[(2)] = inst_17918);

(statearr_17937_17973[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (3))){
var inst_17925 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17927__$1,inst_17925);
} else {
if((state_val_17928 === (12))){
var inst_17896 = (state_17927[(8)]);
var state_17927__$1 = state_17927;
var statearr_17938_17974 = state_17927__$1;
(statearr_17938_17974[(2)] = inst_17896);

(statearr_17938_17974[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (2))){
var _ = (function (){var statearr_17939 = state_17927;
(statearr_17939[(4)] = cljs.core.cons.call(null,(5),(state_17927[(4)])));

return statearr_17939;
})();
var inst_17884 = (end >= start);
var state_17927__$1 = state_17927;
if(cljs.core.truth_(inst_17884)){
var statearr_17940_17975 = state_17927__$1;
(statearr_17940_17975[(1)] = (6));

} else {
var statearr_17941_17976 = state_17927__$1;
(statearr_17941_17976[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (19))){
var state_17927__$1 = state_17927;
var statearr_17942_17977 = state_17927__$1;
(statearr_17942_17977[(2)] = null);

(statearr_17942_17977[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (11))){
var inst_17900 = (state_17927[(7)]);
var inst_17900__$1 = (state_17927[(2)]);
var inst_17901 = (inst_17900__$1 == null);
var inst_17902 = (inst_17900__$1 instanceof Error);
var inst_17903 = ((inst_17901) || (inst_17902));
var state_17927__$1 = (function (){var statearr_17944 = state_17927;
(statearr_17944[(7)] = inst_17900__$1);

return statearr_17944;
})();
if(cljs.core.truth_(inst_17903)){
var statearr_17945_17978 = state_17927__$1;
(statearr_17945_17978[(1)] = (12));

} else {
var statearr_17946_17979 = state_17927__$1;
(statearr_17946_17979[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (9))){
var inst_17895 = (state_17927[(9)]);
var inst_17898 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_17895);
var state_17927__$1 = state_17927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17927__$1,(11),inst_17898);
} else {
if((state_val_17928 === (5))){
var _ = (function (){var statearr_17947 = state_17927;
(statearr_17947[(4)] = cljs.core.rest.call(null,(state_17927[(4)])));

return statearr_17947;
})();
var state_17927__$1 = state_17927;
var ex17943 = (state_17927__$1[(2)]);
var statearr_17948_17980 = state_17927__$1;
(statearr_17948_17980[(5)] = ex17943);


if((ex17943 instanceof Error)){
var statearr_17949_17981 = state_17927__$1;
(statearr_17949_17981[(1)] = (4));

(statearr_17949_17981[(5)] = null);

} else {
throw ex17943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (14))){
var inst_17920 = (state_17927[(2)]);
var state_17927__$1 = state_17927;
var statearr_17950_17982 = state_17927__$1;
(statearr_17950_17982[(2)] = inst_17920);

(statearr_17950_17982[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (16))){
var state_17927__$1 = state_17927;
var statearr_17951_17983 = state_17927__$1;
(statearr_17951_17983[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (10))){
var inst_17922 = (state_17927[(2)]);
var _ = (function (){var statearr_17953 = state_17927;
(statearr_17953[(4)] = cljs.core.rest.call(null,(state_17927[(4)])));

return statearr_17953;
})();
var state_17927__$1 = state_17927;
var statearr_17954_17984 = state_17927__$1;
(statearr_17954_17984[(2)] = inst_17922);

(statearr_17954_17984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (18))){
var inst_17895 = (state_17927[(9)]);
var inst_17900 = (state_17927[(7)]);
var inst_17896 = (state_17927[(8)]);
var inst_17911 = (inst_17895 + (1));
var inst_17912 = cljs.core.conj.call(null,inst_17896,inst_17900);
var inst_17895__$1 = inst_17911;
var inst_17896__$1 = inst_17912;
var state_17927__$1 = (function (){var statearr_17955 = state_17927;
(statearr_17955[(9)] = inst_17895__$1);

(statearr_17955[(8)] = inst_17896__$1);

return statearr_17955;
})();
var statearr_17956_17985 = state_17927__$1;
(statearr_17956_17985[(2)] = null);

(statearr_17956_17985[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17928 === (8))){
var inst_17891 = (state_17927[(2)]);
var inst_17892 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_17893 = start;
var inst_17894 = cljs.core.PersistentVector.EMPTY;
var inst_17895 = inst_17893;
var inst_17896 = inst_17894;
var state_17927__$1 = (function (){var statearr_17957 = state_17927;
(statearr_17957[(9)] = inst_17895);

(statearr_17957[(8)] = inst_17896);

(statearr_17957[(10)] = inst_17891);

(statearr_17957[(11)] = inst_17892);

return statearr_17957;
})();
var statearr_17958_17986 = state_17927__$1;
(statearr_17958_17986[(2)] = null);

(statearr_17958_17986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2468__auto__ = null;
var fluree$db$storage$core$state_machine__2468__auto____0 = (function (){
var statearr_17959 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17959[(0)] = fluree$db$storage$core$state_machine__2468__auto__);

(statearr_17959[(1)] = (1));

return statearr_17959;
});
var fluree$db$storage$core$state_machine__2468__auto____1 = (function (state_17927){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_17927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e17960){var ex__2471__auto__ = e17960;
var statearr_17961_17987 = state_17927;
(statearr_17961_17987[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_17927[(4)]))){
var statearr_17962_17988 = state_17927;
(statearr_17962_17988[(1)] = cljs.core.first.call(null,(state_17927[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17989 = state_17927;
state_17927 = G__17989;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2468__auto__ = function(state_17927){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2468__auto____1.call(this,state_17927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2468__auto____0;
fluree$db$storage$core$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2468__auto____1;
return fluree$db$storage$core$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_17963 = f__2491__auto__.call(null);
(statearr_17963[(6)] = c__2490__auto__);

return statearr_17963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_18005){
var state_val_18006 = (state_18005[(1)]);
if((state_val_18006 === (1))){
var state_18005__$1 = state_18005;
var statearr_18007_18021 = state_18005__$1;
(statearr_18007_18021[(2)] = null);

(statearr_18007_18021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (2))){
var _ = (function (){var statearr_18008 = state_18005;
(statearr_18008[(4)] = cljs.core.cons.call(null,(5),(state_18005[(4)])));

return statearr_18008;
})();
var inst_17996 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_18005__$1 = state_18005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18005__$1,(6),inst_17996);
} else {
if((state_val_18006 === (3))){
var inst_18003 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18005__$1,inst_18003);
} else {
if((state_val_18006 === (4))){
var inst_17990 = (state_18005[(2)]);
var state_18005__$1 = state_18005;
var statearr_18010_18022 = state_18005__$1;
(statearr_18010_18022[(2)] = inst_17990);

(statearr_18010_18022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (5))){
var _ = (function (){var statearr_18011 = state_18005;
(statearr_18011[(4)] = cljs.core.rest.call(null,(state_18005[(4)])));

return statearr_18011;
})();
var state_18005__$1 = state_18005;
var ex18009 = (state_18005__$1[(2)]);
var statearr_18012_18023 = state_18005__$1;
(statearr_18012_18023[(5)] = ex18009);


if((ex18009 instanceof Error)){
var statearr_18013_18024 = state_18005__$1;
(statearr_18013_18024[(1)] = (4));

(statearr_18013_18024[(5)] = null);

} else {
throw ex18009;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18006 === (6))){
var inst_17998 = (state_18005[(2)]);
var inst_17999 = fluree.db.util.async.throw_err.call(null,inst_17998);
var inst_18000 = cljs.core.first.call(null,inst_17999);
var _ = (function (){var statearr_18014 = state_18005;
(statearr_18014[(4)] = cljs.core.rest.call(null,(state_18005[(4)])));

return statearr_18014;
})();
var state_18005__$1 = state_18005;
var statearr_18015_18025 = state_18005__$1;
(statearr_18015_18025[(2)] = inst_18000);

(statearr_18015_18025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2468__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2468__auto____0 = (function (){
var statearr_18016 = [null,null,null,null,null,null,null];
(statearr_18016[(0)] = fluree$db$storage$core$block_$_state_machine__2468__auto__);

(statearr_18016[(1)] = (1));

return statearr_18016;
});
var fluree$db$storage$core$block_$_state_machine__2468__auto____1 = (function (state_18005){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_18005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e18017){var ex__2471__auto__ = e18017;
var statearr_18018_18026 = state_18005;
(statearr_18018_18026[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_18005[(4)]))){
var statearr_18019_18027 = state_18005;
(statearr_18019_18027[(1)] = cljs.core.first.call(null,(state_18005[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18028 = state_18005;
state_18005 = G__18028;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2468__auto__ = function(state_18005){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2468__auto____1.call(this,state_18005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2468__auto____0;
fluree$db$storage$core$block_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2468__auto____1;
return fluree$db$storage$core$block_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_18020 = f__2491__auto__.call(null);
(statearr_18020[(6)] = c__2490__auto__);

return statearr_18020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});

//# sourceMappingURL=core.js.map
